/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git.traits;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.GitSCMSourceContext;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RefSpec;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RefSpecsSCMSourceTrait
extends SCMSourceTrait {
    @NonNull
    private final List<RefSpecTemplate> templates;

    @DataBoundConstructor
    public RefSpecsSCMSourceTrait(@CheckForNull List<RefSpecTemplate> templates) {
        this.templates = new ArrayList<RefSpecTemplate>(Util.fixNull(templates));
    }

    public RefSpecsSCMSourceTrait(String ... templates) {
        this.templates = new ArrayList<RefSpecTemplate>(templates.length);
        for (String t : templates) {
            this.templates.add(new RefSpecTemplate(t));
        }
    }

    @NonNull
    public List<RefSpecTemplate> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    public List<String> asStrings() {
        ArrayList<String> result = new ArrayList<String>(this.templates.size());
        for (RefSpecTemplate t : this.templates) {
            result.add(t.getValue());
        }
        return result;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        for (RefSpecTemplate template : this.templates) {
            ((GitSCMSourceContext)context).withRefSpec(template.getValue());
        }
    }

    protected void decorateBuilder(SCMBuilder<?, ?> builder) {
        for (RefSpecTemplate template : this.templates) {
            ((GitSCMBuilder)builder).withRefSpec(template.getValue());
        }
    }

    public static class RefSpecTemplate
    extends AbstractDescribableImpl<RefSpecTemplate> {
        @NonNull
        private final String value;

        @DataBoundConstructor
        public RefSpecTemplate(@NonNull String value) {
            this.value = StringUtils.trim((String)value);
        }

        @NonNull
        public String getValue() {
            return this.value;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<RefSpecTemplate> {
            @Restricted(value={NoExternalUse.class})
            public FormValidation doCheckValue(@QueryParameter String value) {
                if (StringUtils.isBlank((String)value)) {
                    return FormValidation.error((String)"No ref spec provided");
                }
                value = StringUtils.trim((String)value);
                try {
                    String spec = value.replaceAll(AbstractGitSCMSource.REF_SPEC_REMOTE_NAME_PLACEHOLDER, "origin");
                    if (spec.contains("@{")) {
                        return FormValidation.errorWithMarkup((String)("Invalid placeholder only <code>" + Util.escape((String)"@{remote}") + "</code> is supported as a placeholder for the remote name"));
                    }
                    new RefSpec(spec);
                    if (!value.startsWith("+")) {
                        return FormValidation.warningWithMarkup((String)"It is recommended to ensure references are always updated by prefixing with <code>+</code>");
                    }
                    return FormValidation.ok();
                }
                catch (IllegalArgumentException e) {
                    return FormValidation.error((String)e.getMessage());
                }
            }

            public String getDisplayName() {
                return "Ref Spec";
            }
        }
    }

    @Extension
    @Symbol(value={"refSpecs"})
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return "Specify ref specs";
        }

        public List<RefSpecTemplate> getDefaultTemplates() {
            return Collections.singletonList(new RefSpecTemplate("+refs/heads/*:refs/remotes/@{remote}/*"));
        }

        public Class<? extends SCMBuilder> getBuilderClass() {
            return GitSCMBuilder.class;
        }

        public Class<? extends SCM> getScmClass() {
            return GitSCM.class;
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GitSCMSourceContext.class;
        }
    }
}

