/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.PersistentDescriptor;
import hudson.util.HttpResponses;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import net.jcip.annotations.GuardedBy;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Restricted(value={NoExternalUse.class})
@Symbol(value={"apiTokenProperty"})
public class ApiTokenPropertyConfiguration
extends GlobalConfiguration
implements PersistentDescriptor {
    private static final Logger LOGGER = Logger.getLogger(ApiTokenPropertyConfiguration.class.getName());
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final String HASH_ALGORITHM = "SHA-256";
    @GuardedBy(value="this")
    private final List<HashedApiToken> apiTokens = new ArrayList<HashedApiToken>();

    public static ApiTokenPropertyConfiguration get() {
        return (ApiTokenPropertyConfiguration)((Object)GlobalConfiguration.all().get(ApiTokenPropertyConfiguration.class));
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    @RequirePOST
    public HttpResponse doGenerate(StaplerRequest req) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        String apiTokenName = req.getParameter("apiTokenName");
        JSONObject json = this.generateApiToken(apiTokenName);
        this.save();
        return HttpResponses.okJSON((JSONObject)json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject generateApiToken(@NonNull String name) {
        byte[] random = new byte[16];
        RANDOM.nextBytes(random);
        String plainTextApiToken = Util.toHexString((byte[])random);
        assert (plainTextApiToken.length() == 32);
        String apiTokenValueHashed = Util.toHexString((byte[])ApiTokenPropertyConfiguration.hashedBytes(plainTextApiToken.getBytes(StandardCharsets.US_ASCII)));
        HashedApiToken apiToken = new HashedApiToken(name, apiTokenValueHashed);
        ApiTokenPropertyConfiguration apiTokenPropertyConfiguration = this;
        synchronized (apiTokenPropertyConfiguration) {
            this.apiTokens.add(apiToken);
        }
        JSONObject json = new JSONObject();
        json.put("uuid", (Object)apiToken.getUuid());
        json.put("name", (Object)apiToken.getName());
        json.put("value", (Object)plainTextApiToken);
        return json;
    }

    @NonNull
    private static byte[] hashedBytes(byte[] tokenBytes) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(HASH_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("There is no SHA-256 available in this system", e);
        }
        return digest.digest(tokenBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public HttpResponse doRevoke(StaplerRequest req) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        String apiTokenUuid = req.getParameter("apiTokenUuid");
        if (StringUtils.isBlank((String)apiTokenUuid)) {
            return HttpResponses.errorWithoutStack((int)400, (String)"API token UUID cannot be empty");
        }
        ApiTokenPropertyConfiguration apiTokenPropertyConfiguration = this;
        synchronized (apiTokenPropertyConfiguration) {
            this.apiTokens.removeIf(apiToken -> apiToken.getUuid().equals(apiTokenUuid));
        }
        this.save();
        return HttpResponses.ok();
    }

    public synchronized Collection<HashedApiToken> getApiTokens() {
        return Collections.unmodifiableList(new ArrayList<HashedApiToken>(this.apiTokens));
    }

    public boolean isValidApiToken(String plainApiToken) {
        if (StringUtils.isBlank((String)plainApiToken)) {
            return false;
        }
        return this.hasMatchingApiToken(plainApiToken);
    }

    public synchronized boolean hasMatchingApiToken(@NonNull String plainApiToken) {
        byte[] hash = ApiTokenPropertyConfiguration.hashedBytes(plainApiToken.getBytes(StandardCharsets.US_ASCII));
        return this.apiTokens.stream().anyMatch(apiToken -> apiToken.match(hash));
    }

    public static class HashedApiToken
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String uuid;
        private final String name;
        private final String hash;

        private HashedApiToken(String name, String hash) {
            this.uuid = UUID.randomUUID().toString();
            this.name = name;
            this.hash = hash;
        }

        private HashedApiToken(String uuid, String name, String hash) {
            this.uuid = uuid;
            this.name = name;
            this.hash = hash;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public String getHash() {
            return this.hash;
        }

        private boolean match(byte[] hashedBytes) {
            byte[] hashFromHex;
            try {
                hashFromHex = Util.fromHexString((String)this.hash);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.INFO, "The API token with name=[{0}] is not in hex-format and so cannot be used", this.name);
                return false;
            }
            return MessageDigest.isEqual(hashFromHex, hashedBytes);
        }
    }
}

