/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.ChangelogToBranchOptions;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserMergeOptions;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.AssemblaWeb;
import hudson.plugins.git.extensions.impl.AuthorInChangelog;
import hudson.plugins.git.extensions.impl.ChangelogToBranch;
import hudson.plugins.git.extensions.impl.CheckoutOption;
import hudson.plugins.git.extensions.impl.CleanBeforeCheckout;
import hudson.plugins.git.extensions.impl.CleanCheckout;
import hudson.plugins.git.extensions.impl.CloneOption;
import hudson.plugins.git.extensions.impl.DisableRemotePoll;
import hudson.plugins.git.extensions.impl.GitLFSPull;
import hudson.plugins.git.extensions.impl.IgnoreNotifyCommit;
import hudson.plugins.git.extensions.impl.LocalBranch;
import hudson.plugins.git.extensions.impl.MessageExclusion;
import hudson.plugins.git.extensions.impl.PathRestriction;
import hudson.plugins.git.extensions.impl.PerBuildTag;
import hudson.plugins.git.extensions.impl.PreBuildMerge;
import hudson.plugins.git.extensions.impl.PruneStaleBranch;
import hudson.plugins.git.extensions.impl.RelativeTargetDirectory;
import hudson.plugins.git.extensions.impl.ScmName;
import hudson.plugins.git.extensions.impl.SparseCheckoutPath;
import hudson.plugins.git.extensions.impl.SparseCheckoutPaths;
import hudson.plugins.git.extensions.impl.SubmoduleOption;
import hudson.plugins.git.extensions.impl.UserExclusion;
import hudson.plugins.git.extensions.impl.UserIdentity;
import hudson.plugins.git.extensions.impl.WipeWorkspace;
import hudson.scm.SCM;
import io.jenkins.plugins.casc.misc.RoundTripAbstractTest;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.beans.HasPropertyWithValue;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.jenkinsci.plugins.workflow.libs.GlobalLibraries;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.libs.SCMRetriever;
import org.junit.Assert;
import org.jvnet.hudson.test.RestartableJenkinsRule;

public class GlobalLibraryWithLegacyJCasCCompatibilityTest
extends RoundTripAbstractTest {
    protected void assertConfiguredAsExpected(RestartableJenkinsRule restartableJenkinsRule, String s) {
        LibraryConfiguration library = (LibraryConfiguration)GlobalLibraries.get().getLibraries().get(0);
        Assert.assertEquals((Object)"My Git Lib", (Object)library.getName());
        Assert.assertEquals((Object)"1.2.3", (Object)library.getDefaultVersion());
        Assert.assertTrue((boolean)library.isImplicit());
        LibraryRetriever retriever = library.getRetriever();
        MatcherAssert.assertThat((Object)retriever, (Matcher)IsInstanceOf.instanceOf(SCMRetriever.class));
        SCM scm = ((SCMRetriever)retriever).getScm();
        MatcherAssert.assertThat((Object)scm, (Matcher)IsInstanceOf.instanceOf(GitSCM.class));
        GitSCM gitSCM = (GitSCM)scm;
        MatcherAssert.assertThat((Object)gitSCM.getUserRemoteConfigs(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        UserRemoteConfig userRemoteConfig = (UserRemoteConfig)gitSCM.getUserRemoteConfigs().get(0);
        Assert.assertEquals((Object)"acmeuser-cred-Id", (Object)userRemoteConfig.getCredentialsId());
        Assert.assertEquals((Object)"field_name", (Object)userRemoteConfig.getName());
        Assert.assertEquals((Object)"field_refspec", (Object)userRemoteConfig.getRefspec());
        Assert.assertEquals((Object)"https://git.acmecorp/myGitLib.git", (Object)userRemoteConfig.getUrl());
        MatcherAssert.assertThat((Object)gitSCM.getBranches(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)gitSCM.getBranches(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(BranchSpec.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"master"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(BranchSpec.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"myprodbranch"))})}));
        MatcherAssert.assertThat((Object)gitSCM.getBrowser(), (Matcher)IsInstanceOf.instanceOf(AssemblaWeb.class));
        Assert.assertEquals((Object)"assemblaweb.url", (Object)gitSCM.getBrowser().getRepoUrl());
        Assert.assertFalse((boolean)gitSCM.isDoGenerateSubmoduleConfigurations());
        MatcherAssert.assertThat((Object)gitSCM.getExtensions(), (Matcher)IsCollectionWithSize.hasSize((int)22));
        MatcherAssert.assertThat((Object)gitSCM.getExtensions(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(CheckoutOption.class), HasPropertyWithValue.hasProperty((String)"timeout", (Matcher)IsEqual.equalTo((Object)1))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(CloneOption.class), HasPropertyWithValue.hasProperty((String)"shallow", (Matcher)IsEqual.equalTo((Object)true)), HasPropertyWithValue.hasProperty((String)"noTags", (Matcher)IsEqual.equalTo((Object)false)), HasPropertyWithValue.hasProperty((String)"reference", (Matcher)IsEqual.equalTo((Object)"/my/path/2")), HasPropertyWithValue.hasProperty((String)"timeout", (Matcher)IsEqual.equalTo((Object)2)), HasPropertyWithValue.hasProperty((String)"depth", (Matcher)IsEqual.equalTo((Object)2)), HasPropertyWithValue.hasProperty((String)"honorRefspec", (Matcher)IsEqual.equalTo((Object)true))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(SubmoduleOption.class), HasPropertyWithValue.hasProperty((String)"disableSubmodules", (Matcher)IsEqual.equalTo((Object)true)), HasPropertyWithValue.hasProperty((String)"parentCredentials", (Matcher)IsEqual.equalTo((Object)true)), HasPropertyWithValue.hasProperty((String)"recursiveSubmodules", (Matcher)IsEqual.equalTo((Object)true)), HasPropertyWithValue.hasProperty((String)"reference", (Matcher)IsEqual.equalTo((Object)"/my/path/3")), HasPropertyWithValue.hasProperty((String)"timeout", (Matcher)IsEqual.equalTo((Object)3)), HasPropertyWithValue.hasProperty((String)"trackingSubmodules", (Matcher)IsEqual.equalTo((Object)true))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(ChangelogToBranch.class), HasPropertyWithValue.hasProperty((String)"options", (Matcher)IsInstanceOf.instanceOf(ChangelogToBranchOptions.class)), HasPropertyWithValue.hasProperty((String)"options", (Matcher)HasPropertyWithValue.hasProperty((String)"compareRemote", (Matcher)IsEqual.equalTo((Object)"myrepo"))), HasPropertyWithValue.hasProperty((String)"options", (Matcher)HasPropertyWithValue.hasProperty((String)"compareTarget", (Matcher)IsEqual.equalTo((Object)"mybranch")))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(RelativeTargetDirectory.class), HasPropertyWithValue.hasProperty((String)"relativeTargetDir", (Matcher)IsEqual.equalTo((Object)"/my/path/5"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LocalBranch.class), HasPropertyWithValue.hasProperty((String)"localBranch", (Matcher)IsEqual.equalTo((Object)"local_branch"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(CleanCheckout.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(CleanBeforeCheckout.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(PerBuildTag.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(IgnoreNotifyCommit.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(DisableRemotePoll.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(GitLFSPull.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(PruneStaleBranch.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(AuthorInChangelog.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(WipeWorkspace.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(ScmName.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"my_scm"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(UserIdentity.class), HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"custom_name")), HasPropertyWithValue.hasProperty((String)"email", (Matcher)IsEqual.equalTo((Object)"custom@mail.com"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(UserExclusion.class), HasPropertyWithValue.hasProperty((String)"excludedUsers", (Matcher)IsEqual.equalTo((Object)"me"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(PathRestriction.class), HasPropertyWithValue.hasProperty((String)"excludedRegions", (Matcher)IsEqual.equalTo((Object)"/path/excluded")), HasPropertyWithValue.hasProperty((String)"includedRegions", (Matcher)IsEqual.equalTo((Object)"/path/included"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(MessageExclusion.class), HasPropertyWithValue.hasProperty((String)"excludedMessage", (Matcher)IsEqual.equalTo((Object)"message_excluded"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(PreBuildMerge.class), HasPropertyWithValue.hasProperty((String)"options", (Matcher)IsInstanceOf.instanceOf(UserMergeOptions.class)), HasPropertyWithValue.hasProperty((String)"options", (Matcher)HasPropertyWithValue.hasProperty((String)"fastForwardMode", (Matcher)IsEqual.equalTo((Object)MergeCommand.GitPluginFastForwardMode.FF_ONLY))), HasPropertyWithValue.hasProperty((String)"options", (Matcher)HasPropertyWithValue.hasProperty((String)"mergeRemote", (Matcher)IsEqual.equalTo((Object)"repo_merge"))), HasPropertyWithValue.hasProperty((String)"options", (Matcher)HasPropertyWithValue.hasProperty((String)"mergeTarget", (Matcher)IsEqual.equalTo((Object)"branch_merge"))), HasPropertyWithValue.hasProperty((String)"options", (Matcher)HasPropertyWithValue.hasProperty((String)"mergeStrategy", (Matcher)IsEqual.equalTo((Object)MergeCommand.Strategy.OCTOPUS)))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(SparseCheckoutPaths.class), HasPropertyWithValue.hasProperty((String)"sparseCheckoutPaths", (Matcher)IsInstanceOf.instanceOf(List.class)), HasPropertyWithValue.hasProperty((String)"sparseCheckoutPaths", (Matcher)IsCollectionWithSize.hasSize((int)2)), HasPropertyWithValue.hasProperty((String)"sparseCheckoutPaths", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(SparseCheckoutPath.class), HasPropertyWithValue.hasProperty((String)"path", (Matcher)IsEqual.equalTo((Object)"/first/last"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(SparseCheckoutPath.class), HasPropertyWithValue.hasProperty((String)"path", (Matcher)IsEqual.equalTo((Object)"/other/path"))})}))})}));
    }

    protected String stringInLogExpected() {
        return "Setting class hudson.plugins.git.BranchSpec.name = myprodbranch";
    }

    protected String configResource() {
        return "global-with-legacy-casc.yaml";
    }
}

