/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Label;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.plugins.git.GitTool;
import hudson.slaves.DumbSlave;
import hudson.tools.CommandInstaller;
import hudson.tools.InstallSourceProperty;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolLocationNodeProperty;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.GitToolChooser;
import jenkins.plugins.git.traits.BranchDiscoveryTrait;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.io.FileMatchers;
import org.jenkinsci.plugins.gitclient.JGitApacheTool;
import org.jenkinsci.plugins.gitclient.JGitTool;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TestExtension;
import org.mockito.Mockito;

public class GitToolChooserTest {
    @Rule
    public JenkinsRule jenkins = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();
    static final String GitBranchSCMHead_DEV_MASTER = "[GitBranchSCMHead{name='dev', ref='refs/heads/dev'}, GitBranchSCMHead{name='master', ref='refs/heads/master'}]";
    private CredentialsStore store = null;
    private static Random random = new Random();

    @Before
    public void enableSystemCredentialsProvider() {
        SystemCredentialsProvider.getInstance().setDomainCredentialsMap(Collections.singletonMap(Domain.global(), Collections.emptyList()));
        for (CredentialsStore s : CredentialsProvider.lookupStores((ModelObject)Jenkins.get())) {
            if (!(s.getProvider() instanceof SystemCredentialsProvider.ProviderImpl)) continue;
            this.store = s;
            break;
        }
        MatcherAssert.assertThat((String)"The system credentials provider is enabled", (Object)this.store, (Matcher)Matchers.notNullValue());
    }

    @Before
    public void resetRepositorySizeCache() {
        GitToolChooser.clearRepositorySizeCache();
    }

    @Test
    public void testResolveGitTool() throws IOException, InterruptedException {
        String remote = "https://gitlab.com/rishabhBudhouliya/git-plugin.git";
        Item context = (Item)Mockito.mock(Item.class);
        String credentialsId = null;
        GitTool tool = new GitTool("my-git", this.isWindows() ? "git.exe" : "git", Collections.emptyList());
        JGitTool JTool = new JGitTool(Collections.emptyList());
        ((GitTool.DescriptorImpl)this.jenkins.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{tool, JTool});
        GitToolChooser r = new GitToolChooser(remote, context, credentialsId, (GitTool)JTool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)r.getGitTool(), (Matcher)Matchers.containsString((String)(this.isWindows() ? "git.exe" : "git")));
    }

    @Test
    public void testResolveGitToolWithJenkins() throws IOException, InterruptedException {
        if (this.isWindows()) {
            return;
        }
        String remote = "https://gitlab.com/rishabhBudhouliya/git-plugin.git";
        Item context = (Item)Mockito.mock(Item.class);
        String credentialsId = null;
        TestToolInstaller inst = new TestToolInstaller("master", "echo Hello", "updated/git");
        GitTool t = new GitTool("myGit", "default/git", Collections.singletonList(new InstallSourceProperty(Collections.singletonList(inst))));
        GitTool tool = new GitTool("my-git", "git", Collections.emptyList());
        JGitTool JTool = new JGitTool(Collections.emptyList());
        ((GitTool.DescriptorImpl)this.jenkins.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{tool, JTool, t});
        GitToolChooser r = new GitToolChooser(remote, context, credentialsId, (GitTool)JTool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)r.getGitTool(), (Matcher)Matchers.containsString((String)"updated/git"));
    }

    @Test
    public void testResolutionGitToolOnAgent() throws Exception {
        if (this.isWindows()) {
            return;
        }
        String remote = "https://gitlab.com/rishabhBudhouliya/git-plugin.git";
        Item context = (Item)Mockito.mock(Item.class);
        String credentialsId = null;
        LabelAtom label = new LabelAtom("agent-windows");
        DumbSlave agent = this.jenkins.createOnlineSlave((Label)label);
        agent.setMode(Node.Mode.NORMAL);
        agent.setLabelString("agent-windows");
        TestToolInstaller inst = new TestToolInstaller("master", "echo Hello", "myGit/git");
        GitTool toolOnMaster = new GitTool("myGit", "default/git", Collections.singletonList(new InstallSourceProperty(Collections.singletonList(inst))));
        TestToolInstaller instonAgent = new TestToolInstaller("agent-windows", "echo Hello", "my-git/git");
        GitTool toolOnAgent = new GitTool("my-git", "git", Collections.singletonList(new InstallSourceProperty(Collections.singletonList(instonAgent))));
        JGitTool JTool = new JGitTool(Collections.emptyList());
        ((GitTool.DescriptorImpl)this.jenkins.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{toolOnMaster, toolOnAgent, JTool});
        agent.getNodeProperties().add((Object)new ToolLocationNodeProperty(new ToolLocationNodeProperty.ToolLocation[]{new ToolLocationNodeProperty.ToolLocation((ToolDescriptor)this.jenkins.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class), toolOnMaster.getName(), toolOnMaster.getHome())}));
        agent.getNodeProperties().add((Object)new ToolLocationNodeProperty(new ToolLocationNodeProperty.ToolLocation[]{new ToolLocationNodeProperty.ToolLocation((ToolDescriptor)this.jenkins.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class), toolOnAgent.getName(), toolOnAgent.getHome())}));
        agent.getNodeProperties().add((Object)new ToolLocationNodeProperty(new ToolLocationNodeProperty.ToolLocation[]{new ToolLocationNodeProperty.ToolLocation((ToolDescriptor)this.jenkins.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class), JTool.getName(), null)}));
        GitToolChooser r = new GitToolChooser(remote, context, credentialsId, (GitTool)JTool, (Node)agent, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)r.getGitTool(), (Matcher)Matchers.containsString((String)"my-git/git"));
    }

    @Test
    public void testSizeEstimationWithNoGitCache() throws Exception {
        this.sampleRepo.init();
        GitSCMSource instance = new GitSCMSource("https://github.com/rishabhBudhouliya/git-plugin.git");
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.GLOBAL, "github"));
        this.store.save();
        this.buildAProject(this.sampleRepo, false);
        List list = this.jenkins.jenkins.getItems();
        GitTool rTool = new GitTool("my-git", this.isWindows() ? "git.exe" : "git", Collections.emptyList());
        GitToolChooser repoSizeEstimator = new GitToolChooser(instance.getRemote(), (Item)list.get(0), "github", rTool, null, TaskListener.NULL, Boolean.valueOf(true));
        String tool = repoSizeEstimator.getGitTool();
        MatcherAssert.assertThat((Object)tool, (Matcher)Matchers.is((Object)"NONE"));
        MatcherAssert.assertThat((Object)repoSizeEstimator.determineSwitchOnSize(Long.valueOf(0L), rTool), (Matcher)Matchers.is((Object)"NONE"));
    }

    @Test
    public void testSizeEstimationWithGitCache() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        this.sampleRepo.git("tag", "lightweight");
        this.sampleRepo.write("file", "modified2");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        this.sampleRepo.git("tag", "-a", "annotated", "-m", "annotated");
        this.sampleRepo.write("file", "modified3");
        this.sampleRepo.git("commit", "--all", "--message=dev3");
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"[]", (Object)source.fetch((TaskListener)listener).toString());
        source.setTraits(Collections.singletonList(new BranchDiscoveryTrait()));
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        JGitTool tool = new JGitTool(Collections.emptyList());
        ((GitTool.DescriptorImpl)this.jenkins.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{tool});
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.GLOBAL, "github"));
        this.store.save();
        this.buildAProject(this.sampleRepo, false);
        List list = this.jenkins.jenkins.getItems();
        GitToolChooser repoSizeEstimator = new GitToolChooser(source.getRemote(), (Item)list.get(0), "github", (GitTool)tool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)repoSizeEstimator.getGitTool(), (Matcher)Matchers.containsString((String)"jgit"));
        String permutedRemote = source.getRemote();
        String suffix = ".git";
        permutedRemote = permutedRemote.endsWith(suffix) ? permutedRemote.substring(0, permutedRemote.length() - suffix.length()) : permutedRemote + suffix;
        GitToolChooser permutedRepoSizeEstimator = new GitToolChooser(permutedRemote, (Item)list.get(0), "github", (GitTool)tool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((String)"Alternative repository name should find the cache", (Object)permutedRepoSizeEstimator.getGitTool(), (Matcher)Matchers.containsString((String)"jgit"));
    }

    @Test
    public void testRemoteAlternatives() throws Exception {
        Set alternatives;
        GitToolChooser sizeEstimator;
        Object[] remoteAlternatives;
        JGitTool tool = new JGitTool(Collections.emptyList());
        GitToolChooser nullRemoteSizeEstimator = new GitToolChooser("git://github.com/git/git.git", null, null, (GitTool)tool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)nullRemoteSizeEstimator.remoteAlternatives(null), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)nullRemoteSizeEstimator.remoteAlternatives(""), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        long sizeOfRepo = 1 + random.nextInt(4000);
        MatcherAssert.assertThat((Object)nullRemoteSizeEstimator.determineSwitchOnSize(Long.valueOf(sizeOfRepo), (GitTool)tool), (Matcher)Matchers.is((Object)"NONE"));
        for (String string : remoteAlternatives = new String[]{"git://github.com/jenkinsci/git-plugin", "git://github.com/jenkinsci/git-plugin.git", "git@github.com:jenkinsci/git-plugin", "git@github.com:jenkinsci/git-plugin.git", "https://github.com/jenkinsci/git-plugin", "https://github.com/jenkinsci/git-plugin.git", "ssh://git@github.com/jenkinsci/git-plugin", "ssh://git@github.com/jenkinsci/git-plugin.git"}) {
            sizeEstimator = new GitToolChooser(string, null, null, (GitTool)tool, null, TaskListener.NULL, Boolean.valueOf(random.nextBoolean()));
            alternatives = sizeEstimator.remoteAlternatives(string);
            MatcherAssert.assertThat((String)("Remote: " + string), (Object)alternatives, (Matcher)Matchers.containsInAnyOrder((Object[])remoteAlternatives));
        }
        for (String string : remoteAlternatives) {
            String string2 = string + "/";
            sizeEstimator = new GitToolChooser(string2, null, null, (GitTool)tool, null, TaskListener.NULL, Boolean.valueOf(random.nextBoolean()));
            alternatives = sizeEstimator.remoteAlternatives(string2);
            MatcherAssert.assertThat((String)("Remote+'/': " + string2), (Object)alternatives, (Matcher)Matchers.containsInAnyOrder((Object[])remoteAlternatives));
        }
    }

    @Test
    public void testConvertToCanonicalURL() throws Exception {
        JGitTool tool = new JGitTool(Collections.emptyList());
        String[] remoteAlternatives = new String[]{"git://github.com/jenkinsci/git-plugin", "git://github.com/jenkinsci/git-plugin.git", "git@github.com:jenkinsci/git-plugin", "git@github.com:jenkinsci/git-plugin.git", "https://github.com/jenkinsci/git-plugin", "https://github.com/jenkinsci/git-plugin.git", "ssh://git@github.com/jenkinsci/git-plugin", "ssh://git@github.com/jenkinsci/git-plugin.git"};
        String actualNormalizedURL = "https://github.com/jenkinsci/git-plugin.git";
        for (String remote : remoteAlternatives) {
            GitToolChooser sizeEstimator = new GitToolChooser(remote, null, null, (GitTool)tool, null, TaskListener.NULL, Boolean.valueOf(random.nextBoolean()));
            String expectedNormalizedURL = sizeEstimator.convertToCanonicalURL(remote);
            MatcherAssert.assertThat((String)("Remote: " + remote), (Object)expectedNormalizedURL, (Matcher)Matchers.is((Object)actualNormalizedURL));
        }
        String otherRemote = "file://srv/git/repo";
        GitToolChooser sizeEstimator = new GitToolChooser(otherRemote, null, null, (GitTool)tool, null, TaskListener.NULL, Boolean.valueOf(random.nextBoolean()));
        MatcherAssert.assertThat((String)("Remote: " + otherRemote), (Object)sizeEstimator.convertToCanonicalURL(otherRemote), (Matcher)Matchers.is((Object)(otherRemote + ".git")));
    }

    @Test
    public void testSizeEstimationWithAPIForGit() throws Exception {
        String remote = "https://gitlab.com/rishabhBudhouliya/git-plugin.git";
        this.sampleRepo.init();
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.GLOBAL, "github"));
        this.store.save();
        this.buildAProject(this.sampleRepo, false);
        List list = this.jenkins.jenkins.getItems();
        GitTool tool = new GitTool("my-git", this.isWindows() ? "git.exe" : "git", Collections.emptyList());
        GitToolChooser sizeEstimator = new GitToolChooser(remote, (Item)list.get(0), "github", tool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)sizeEstimator.getGitTool(), (Matcher)Matchers.containsString((String)"git"));
    }

    @Test
    public void testSizeEstimationWithAPIForJGit() throws Exception {
        String remote = "https://github.com/rishabhBudhouliya/git-plugin.git";
        this.sampleRepo.init();
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.GLOBAL, "github"));
        this.store.save();
        JGitTool tool = new JGitTool(Collections.emptyList());
        ((GitTool.DescriptorImpl)this.jenkins.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{tool});
        this.buildAProject(this.sampleRepo, false);
        List list = this.jenkins.jenkins.getItems();
        GitToolChooser sizeEstimator = new GitToolChooser(remote, (Item)list.get(0), "github", (GitTool)tool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)sizeEstimator.getGitTool(), (Matcher)Matchers.containsString((String)"jgit"));
    }

    @Test
    public void testSizeEstimationWithBitbucketAPIs() throws Exception {
        String remote = "https://bitbucket.com/rishabhBudhouliya/git-plugin.git";
        this.sampleRepo.init();
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.GLOBAL, "github"));
        this.store.save();
        this.buildAProject(this.sampleRepo, false);
        List list = this.jenkins.jenkins.getItems();
        GitTool tool = new GitTool("my-git", this.isWindows() ? "git.exe" : "git", Collections.emptyList());
        GitToolChooser sizeEstimator = new GitToolChooser(remote, (Item)list.get(0), "github", tool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)sizeEstimator.getGitTool(), (Matcher)Matchers.is((Object)"NONE"));
    }

    @Test
    public void testSizeEstimationWithException() throws Exception {
        String remote = "https://bitbucket.com/rishabhBudhouliya/git-plugin.git";
        this.sampleRepo.init();
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.GLOBAL, "github"));
        this.store.save();
        this.buildAProject(this.sampleRepo, false);
        List list = this.jenkins.jenkins.getItems();
        GitTool tool = new GitTool("my-git", this.isWindows() ? "git.exe" : "git", Collections.emptyList());
        GitToolChooser sizeEstimator = new GitToolChooser(remote, (Item)list.get(0), "github", tool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)sizeEstimator.getGitTool(), (Matcher)Matchers.is((Object)"NONE"));
    }

    @Test
    public void testSizeEstimationWithNoCredentials() throws Exception {
        this.sampleRepo.init();
        this.buildAProject(this.sampleRepo, true);
        List list = this.jenkins.jenkins.getItems();
        GitTool tool = new GitTool("my-git", this.isWindows() ? "git.exe" : "git", Collections.emptyList());
        GitToolChooser sizeEstimator = new GitToolChooser(this.sampleRepo.toString(), (Item)list.get(0), null, tool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)sizeEstimator.getGitTool(), (Matcher)Matchers.is((Object)"NONE"));
    }

    @Test
    public void testGitToolChooserWithCustomGitTool() throws Exception {
        String remote = "https://github.com/rishabhBudhouliya/git-plugin.git";
        Item context = (Item)Mockito.mock(Item.class);
        String credentialsId = null;
        GitTool tool = new GitTool("my-git", this.isWindows() ? "git.exe" : "git", Collections.emptyList());
        ((GitTool.DescriptorImpl)this.jenkins.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{tool});
        GitToolChooser gitToolChooser = new GitToolChooser(remote, context, credentialsId, tool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)gitToolChooser.getGitTool(), (Matcher)Matchers.is((Object)"NONE"));
    }

    @Test
    public void testGitToolChooserWithBothGitAndJGit() throws Exception {
        String remote = "https://github.com/rishabhBudhouliya/git-plugin.git";
        Item context = (Item)Mockito.mock(Item.class);
        String credentialsId = null;
        GitTool tool = new GitTool("my-git", this.isWindows() ? "git.exe" : "git", Collections.emptyList());
        JGitTool jgitTool = new JGitTool(Collections.emptyList());
        ((GitTool.DescriptorImpl)this.jenkins.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{tool, jgitTool});
        GitToolChooser gitToolChooser = new GitToolChooser(remote, context, credentialsId, tool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)gitToolChooser.getGitTool(), (Matcher)Matchers.is((Object)"jgit"));
    }

    @Test
    public void testGitToolChooserWithAllTools() throws Exception {
        String remote = "https://github.com/rishabhBudhouliya/git-plugin.git";
        Item context = (Item)Mockito.mock(Item.class);
        String credentialsId = null;
        GitTool tool = new GitTool("my-git", "/usr/bin/git", Collections.emptyList());
        JGitTool jgitTool = new JGitTool(Collections.emptyList());
        JGitApacheTool jGitApacheTool = new JGitApacheTool(Collections.emptyList());
        ((GitTool.DescriptorImpl)this.jenkins.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{tool, jgitTool, jGitApacheTool});
        GitToolChooser gitToolChooser = new GitToolChooser(remote, context, credentialsId, tool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)gitToolChooser.getGitTool(), (Matcher)Matchers.is((Object)"jgit"));
    }

    @Test
    public void testGitToolChooserWithJGitApache() throws Exception {
        String remote = "https://github.com/rishabhBudhouliya/git-plugin.git";
        Item context = (Item)Mockito.mock(Item.class);
        String credentialsId = null;
        GitTool tool = new GitTool("my-git", "/usr/bin/git", Collections.emptyList());
        JGitApacheTool jGitApacheTool = new JGitApacheTool(Collections.emptyList());
        ((GitTool.DescriptorImpl)this.jenkins.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{tool, jGitApacheTool});
        GitToolChooser gitToolChooser = new GitToolChooser(remote, context, credentialsId, (GitTool)jGitApacheTool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)gitToolChooser.getGitTool(), (Matcher)Matchers.is((Object)"jgitapache"));
    }

    @Test
    public void testGitToolChooserWithJGitApacheAndGit() throws Exception {
        String remote = "https://github.com/rishabhBudhouliya/git-plugin.git";
        Item context = (Item)Mockito.mock(Item.class);
        String credentialsId = null;
        JGitApacheTool jGitApacheTool = new JGitApacheTool(Collections.emptyList());
        ((GitTool.DescriptorImpl)this.jenkins.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{jGitApacheTool});
        GitToolChooser gitToolChooser = new GitToolChooser(remote, context, credentialsId, (GitTool)jGitApacheTool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)gitToolChooser.getGitTool(), (Matcher)Matchers.is((Object)"jgitapache"));
    }

    @Test
    public void testGitToolChooserWithDefaultTool() throws Exception {
        String remote = "https://gitlab.com/rishabhBudhouliya/git-plugin.git";
        this.sampleRepo.init();
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.GLOBAL, "github"));
        this.store.save();
        this.buildAProject(this.sampleRepo, false);
        List list = this.jenkins.jenkins.getItems();
        GitTool tool = new GitTool("my-git", this.isWindows() ? "git.exe" : "git", Collections.emptyList());
        GitToolChooser sizeEstimator = new GitToolChooser(remote, (Item)list.get(0), "github", tool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)sizeEstimator.getGitTool(), (Matcher)Matchers.containsString((String)"git"));
    }

    @Test
    public void testGitToolChooserWithOnlyJGit() throws Exception {
        String remote = "https://gitlab.com/rishabhBudhouliya/git-plugin.git";
        this.sampleRepo.init();
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.GLOBAL, "github"));
        this.store.save();
        JGitTool jGitTool = new JGitTool(Collections.emptyList());
        ((GitTool.DescriptorImpl)this.jenkins.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{jGitTool});
        this.buildAProject(this.sampleRepo, false);
        List list = this.jenkins.jenkins.getItems();
        String gitExe = jGitTool.getGitExe();
        GitToolChooser sizeEstimator = new GitToolChooser(remote, (Item)list.get(0), "github", (GitTool)jGitTool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)sizeEstimator.getGitTool(), (Matcher)Matchers.is((Object)"jgit"));
    }

    @Test
    public void testGitToolChooserWithCustomGitTool_2() throws Exception {
        String remote = "https://gitlab.com/rishabhBudhouliya/git-plugin.git";
        this.sampleRepo.init();
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.GLOBAL, "github"));
        this.store.save();
        GitTool tool = new GitTool("my-git", this.isWindows() ? "git.exe" : "git", Collections.emptyList());
        ((GitTool.DescriptorImpl)this.jenkins.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{tool});
        this.buildAProject(this.sampleRepo, false);
        List list = this.jenkins.jenkins.getItems();
        String gitExe = tool.getGitExe();
        GitToolChooser sizeEstimator = new GitToolChooser(remote, (Item)list.get(0), "github", tool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)sizeEstimator.getGitTool(), (Matcher)Matchers.is((Object)(this.isWindows() ? "git.exe" : "git")));
    }

    @Test
    public void testGitToolChooserWithAllTools_2() throws Exception {
        String remote = "https://gitlab.com/rishabhBudhouliya/git-plugin.git";
        this.sampleRepo.init();
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.GLOBAL, "github"));
        this.store.save();
        GitTool tool = new GitTool("my-git", this.isWindows() ? "git.exe" : "git", Collections.emptyList());
        JGitTool jgitTool = new JGitTool(Collections.emptyList());
        JGitApacheTool jGitApacheTool = new JGitApacheTool(Collections.emptyList());
        ((GitTool.DescriptorImpl)this.jenkins.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{tool, jgitTool, jGitApacheTool});
        this.buildAProject(this.sampleRepo, false);
        List list = this.jenkins.jenkins.getItems();
        String gitExe = tool.getGitExe();
        GitToolChooser sizeEstimator = new GitToolChooser(remote, (Item)list.get(0), "github", tool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)sizeEstimator.getGitTool(), (Matcher)Matchers.is((Object)(this.isWindows() ? "git.exe" : "git")));
    }

    @Test
    public void getCacheDirCreatesNoDirectory() throws Exception {
        String remoteName = "https://github.com/jenkinsci/git-plugin-" + UUID.randomUUID().toString() + ".git";
        String cacheEntry = AbstractGitSCMSource.getCacheEntry((String)remoteName);
        File expectedCacheDir = new File(new File(this.jenkins.jenkins.getRootDir(), "caches"), cacheEntry);
        MatcherAssert.assertThat((Object)expectedCacheDir, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)FileMatchers.anExistingFileOrDirectory())));
        File nullCacheDir = AbstractGitSCMSource.getCacheDir((String)cacheEntry, (boolean)false);
        MatcherAssert.assertThat((Object)nullCacheDir, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)expectedCacheDir, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)FileMatchers.anExistingFileOrDirectory())));
        File cacheDir = AbstractGitSCMSource.getCacheDir((String)cacheEntry, (boolean)true);
        MatcherAssert.assertThat((Object)cacheDir, (Matcher)Matchers.is((Matcher)FileMatchers.anExistingDirectory()));
        MatcherAssert.assertThat((Object)expectedCacheDir, (Matcher)Matchers.is((Matcher)FileMatchers.anExistingDirectory()));
    }

    @Test
    public void testSizeEstimationWithNoRemoteConfig() throws Exception {
        this.sampleRepo.init();
        this.failAProject(this.sampleRepo);
        List list = this.jenkins.jenkins.getItems();
        JGitTool jgitTool = new JGitTool(Collections.emptyList());
        GitToolChooser sizeEstimator = new GitToolChooser(this.sampleRepo.toString(), (Item)list.get(0), null, (GitTool)jgitTool, null, TaskListener.NULL, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)sizeEstimator.getGitTool(), (Matcher)Matchers.is((Object)"NONE"));
    }

    private void buildAProject(GitSampleRepoRule sampleRepo, boolean noCredentials) throws Exception {
        WorkflowJob p = (WorkflowJob)this.jenkins.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  checkout(\n    [$class: 'GitSCM', \n      userRemoteConfigs: [[credentialsId: 'github', url: $/" + (Object)((Object)sampleRepo) + "/$]]]\n  )}", true));
        WorkflowRun b = (WorkflowRun)this.jenkins.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        if (!noCredentials) {
            this.jenkins.waitForMessage("using credential github", (Run)b);
        }
    }

    private void failAProject(GitSampleRepoRule sampleRepo) throws Exception {
        WorkflowJob p = (WorkflowJob)this.jenkins.jenkins.createProject(WorkflowJob.class, "intentionally-failing-job-without-remote-config");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  checkout(\n    [$class: 'GitSCM']\n  )\n}", true));
        WorkflowRun b = (WorkflowRun)this.jenkins.assertBuildStatus(Result.FAILURE, (Future)p.scheduleBuild2(0, new Action[0]));
        this.jenkins.waitForMessage("Couldn't find any revision to build", (Run)b);
    }

    private StandardCredentials createCredential(CredentialsScope scope, String id) {
        return new UsernamePasswordCredentialsImpl(scope, id, "desc: " + id, "username", "password");
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    private static class TestToolInstaller
    extends CommandInstaller {
        private boolean invoked;

        public TestToolInstaller(String label, String command, String toolHome) {
            super(label, command, toolHome);
        }

        public boolean isInvoked() {
            return this.invoked;
        }

        public FilePath performInstallation(ToolInstallation toolInstallation, Node node, TaskListener taskListener) throws IOException, InterruptedException {
            taskListener.error("Hello, world!");
            this.invoked = true;
            return super.performInstallation(toolInstallation, node, taskListener);
        }
    }

    @TestExtension
    public static class TestExtensionBit
    extends GitToolChooser.RepositorySizeAPI {
        public boolean isApplicableTo(String remote, Item context, String credentialsId) {
            return remote.contains("bit");
        }

        public Long getSizeOfRepository(String remote, Item context, String credentialsId) throws IOException {
            throw new IOException();
        }
    }

    @TestExtension
    public static class TestExtensionGitlab
    extends GitToolChooser.RepositorySizeAPI {
        public boolean isApplicableTo(String remote, Item context, String credentialsId) {
            return remote.contains("gitlab");
        }

        public Long getSizeOfRepository(String remote, Item context, String credentialsId) {
            return 10000L;
        }
    }

    @TestExtension
    public static class TestExtensionGithub
    extends GitToolChooser.RepositorySizeAPI {
        public boolean isApplicableTo(String remote, Item context, String credentialsId) {
            return remote.contains("github");
        }

        public Long getSizeOfRepository(String remote, Item context, String credentialsId) {
            return 500L;
        }
    }
}

