/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.plugins.git.AbstractGitRepository;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.extensions.impl.BuildChooserSetting;
import hudson.plugins.git.util.AncestryBuildChooser;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildData;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class AncestryBuildChooserTest
extends AbstractGitRepository {
    private String rootCommit = null;
    private String ancestorCommit = null;
    private String fiveDaysAgoCommit = null;
    private String tenDaysAgoCommit = null;
    private String twentyDaysAgoCommit = null;
    private final LocalDateTime fiveDaysAgo = LocalDate.now().atStartOfDay().minusDays(5L);
    private final LocalDateTime tenDaysAgo = LocalDate.now().atStartOfDay().minusDays(10L);
    private final LocalDateTime twentyDaysAgo = LocalDate.now().atStartOfDay().minusDays(20L);
    private final PersonIdent johnDoe = new PersonIdent("John Doe", "john@example.com");

    @Before
    public void setUp() throws Exception {
        Set<String> prevBranches = this.stringifyBranches(this.testGitClient.getBranches());
        this.testGitClient.commit("Root Commit");
        this.rootCommit = this.getLastCommitSha1(prevBranches);
        this.testGitClient.commit("Ancestor Commit");
        this.ancestorCommit = this.getLastCommitSha1(prevBranches);
        this.testGitClient.branch("20-days-old-branch");
        this.testGitClient.checkoutBranch("20-days-old-branch", this.ancestorCommit);
        Date twentyDaysAgoDate = Date.from(this.twentyDaysAgo.atZone(ZoneId.systemDefault()).toInstant());
        PersonIdent johnDoeTwentyDaysAgo = new PersonIdent(this.johnDoe, twentyDaysAgoDate);
        this.commit("20 days ago commit message", johnDoeTwentyDaysAgo, johnDoeTwentyDaysAgo);
        this.twentyDaysAgoCommit = this.getLastCommitSha1(prevBranches);
        this.testGitClient.checkout().ref(this.ancestorCommit).execute();
        this.testGitClient.checkoutBranch("10-days-old-branch", this.ancestorCommit);
        Date tenDaysAgoDate = Date.from(this.tenDaysAgo.atZone(ZoneId.systemDefault()).toInstant());
        PersonIdent johnDoeTenDaysAgo = new PersonIdent(this.johnDoe, tenDaysAgoDate);
        this.commit("10 days ago commit message", johnDoeTenDaysAgo, johnDoeTenDaysAgo);
        this.tenDaysAgoCommit = this.getLastCommitSha1(prevBranches);
        this.testGitClient.checkout().ref(this.rootCommit).execute();
        this.testGitClient.checkoutBranch("5-days-old-branch", this.rootCommit);
        Date fiveDaysAgoDate = Date.from(this.fiveDaysAgo.atZone(ZoneId.systemDefault()).toInstant());
        PersonIdent johnDoeFiveDaysAgo = new PersonIdent(this.johnDoe, fiveDaysAgoDate);
        this.commit("5 days ago commit message", johnDoeFiveDaysAgo, johnDoeFiveDaysAgo);
        this.fiveDaysAgoCommit = this.getLastCommitSha1(prevBranches);
    }

    private Set<String> stringifyBranches(Set<Branch> original) {
        TreeSet<String> result = new TreeSet<String>();
        Iterator<Branch> iter = original.iterator();
        while (iter.hasNext()) {
            result.add(iter.next().getSHA1String());
        }
        return result;
    }

    private String getLastCommitSha1(Set<String> prevBranches) throws Exception {
        Set<String> newBranches = this.stringifyBranches(this.testGitClient.getBranches());
        Sets.SetView difference = Sets.difference(newBranches, prevBranches);
        Assert.assertEquals((long)1L, (long)difference.size());
        String result = (String)difference.iterator().next();
        prevBranches.clear();
        prevBranches.addAll(newBranches);
        return result;
    }

    private void commit(String message, PersonIdent author, PersonIdent committer) {
        try (Repository repo = this.testGitClient.getRepository();){
            CommitCommand cmd = Git.wrap((Repository)repo).commit().setMessage(message);
            if (author != null) {
                cmd.setAuthor(author);
            }
            if (committer != null) {
                cmd.setCommitter(committer);
            }
            cmd.call();
        }
        catch (GitAPIException e) {
            throw new GitException((Throwable)e);
        }
    }

    private List<String> getFilteredTestCandidates(Integer maxAgeInDays, String ancestorCommitSha1) throws Exception {
        GitSCM gitSCM = new GitSCM("foo");
        AncestryBuildChooser chooser = new AncestryBuildChooser(maxAgeInDays, ancestorCommitSha1);
        gitSCM.getExtensions().add((Object)new BuildChooserSetting((BuildChooser)chooser));
        Assert.assertEquals((Object)maxAgeInDays, (Object)chooser.getMaximumAgeInDays());
        Assert.assertEquals((Object)ancestorCommitSha1, (Object)chooser.getAncestorCommitSha1());
        GitClient git = (GitClient)Mockito.spy((Object)this.testGitClient);
        Mockito.when((Object)git.getRemoteBranches()).thenReturn((Object)this.testGitClient.getBranches());
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Mockito.when((Object)buildData.hasBeenBuilt(git.revParse(this.rootCommit))).thenReturn((Object)false);
        BuildChooserContext context = (BuildChooserContext)Mockito.mock(BuildChooserContext.class);
        Mockito.when((Object)context.getEnvironment()).thenReturn((Object)new EnvVars());
        TaskListener listener = TaskListener.NULL;
        Collection candidateRevisions = gitSCM.getBuildChooser().getCandidateRevisions(true, "**-days-old-branch", git, listener, buildData, context);
        ArrayList candidateSha1s = Lists.newArrayList((Iterable)Iterables.transform((Iterable)candidateRevisions, (Function)new Function<Revision, String>(){

            public String apply(Revision rev) {
                return rev.getSha1String();
            }
        }));
        return candidateSha1s;
    }

    @Test
    public void testFilterRevisionsNoRestriction() throws Exception {
        Integer maxAgeInDays = null;
        String ancestorCommitSha1 = null;
        List<String> candidateSha1s = this.getFilteredTestCandidates(maxAgeInDays, ancestorCommitSha1);
        Assert.assertEquals((long)3L, (long)candidateSha1s.size());
        Assert.assertTrue((boolean)candidateSha1s.contains(this.fiveDaysAgoCommit));
        Assert.assertTrue((boolean)candidateSha1s.contains(this.tenDaysAgoCommit));
        Assert.assertTrue((boolean)candidateSha1s.contains(this.twentyDaysAgoCommit));
    }

    @Test
    public void testFilterRevisionsZeroDate() throws Exception {
        Integer maxAgeInDays = 0;
        String ancestorCommitSha1 = null;
        List<String> candidateSha1s = this.getFilteredTestCandidates(maxAgeInDays, ancestorCommitSha1);
        Assert.assertEquals((long)0L, (long)candidateSha1s.size());
    }

    @Test
    public void testFilterRevisionsTenDays() throws Exception {
        Integer maxAgeInDays = 10;
        String ancestorCommitSha1 = null;
        List<String> candidateSha1s = this.getFilteredTestCandidates(maxAgeInDays, ancestorCommitSha1);
        Assert.assertEquals((long)1L, (long)candidateSha1s.size());
        Assert.assertTrue((boolean)candidateSha1s.contains(this.fiveDaysAgoCommit));
    }

    @Test
    public void testFilterRevisionsThirtyDays() throws Exception {
        Integer maxAgeInDays = 30;
        String ancestorCommitSha1 = null;
        List<String> candidateSha1s = this.getFilteredTestCandidates(maxAgeInDays, ancestorCommitSha1);
        Assert.assertEquals((long)3L, (long)candidateSha1s.size());
        Assert.assertTrue((boolean)candidateSha1s.contains(this.fiveDaysAgoCommit));
        Assert.assertTrue((boolean)candidateSha1s.contains(this.tenDaysAgoCommit));
        Assert.assertTrue((boolean)candidateSha1s.contains(this.twentyDaysAgoCommit));
    }

    @Test
    public void testFilterRevisionsBlankAncestor() throws Exception {
        Integer maxAgeInDays = null;
        String ancestorCommitSha1 = "";
        List<String> candidateSha1s = this.getFilteredTestCandidates(maxAgeInDays, "");
        Assert.assertEquals((long)3L, (long)candidateSha1s.size());
        Assert.assertTrue((boolean)candidateSha1s.contains(this.fiveDaysAgoCommit));
        Assert.assertTrue((boolean)candidateSha1s.contains(this.tenDaysAgoCommit));
        Assert.assertTrue((boolean)candidateSha1s.contains(this.twentyDaysAgoCommit));
    }

    @Test
    public void testFilterRevisionsNonExistingAncestor() throws Exception {
        Integer maxAgeInDays = null;
        String ancestorCommitSha1 = "This commit sha1 does not exist.";
        try {
            List<String> candidateSha1s = this.getFilteredTestCandidates(maxAgeInDays, "This commit sha1 does not exist.");
            Assert.fail((String)"Invalid sha1 should throw GitException.");
        }
        catch (GitException e) {
            return;
        }
    }

    @Test
    public void testFilterRevisionsExistingAncestor() throws Exception {
        Integer maxAgeInDays = null;
        String ancestorCommitSha1 = this.ancestorCommit;
        List<String> candidateSha1s = this.getFilteredTestCandidates(maxAgeInDays, ancestorCommitSha1);
        Assert.assertEquals((long)2L, (long)candidateSha1s.size());
        Assert.assertTrue((boolean)candidateSha1s.contains(this.tenDaysAgoCommit));
        Assert.assertTrue((boolean)candidateSha1s.contains(this.twentyDaysAgoCommit));
    }
}

