/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitChangeSetSample;
import hudson.plugins.git.browser.Phabricator;
import java.io.IOException;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;

public class PhabricatorTest {
    private final String repoName = "phabricatorRepo";
    private final String repoUrl = "http://phabricator.example.com/";
    private final Phabricator phabricator = new Phabricator("http://phabricator.example.com/", "phabricatorRepo");
    private final GitChangeSetSample sample = new GitChangeSetSample(true);

    @Test
    public void testGetRepo() throws IOException {
        Assert.assertEquals((Object)"phabricatorRepo", (Object)this.phabricator.getRepo());
    }

    @Test
    public void testGetChangeSetLink() throws Exception {
        URL result = this.phabricator.getChangeSetLink(this.sample.changeSet);
        Assert.assertEquals((Object)new URL("http://phabricator.example.com/rphabricatorRepo" + this.sample.id), (Object)result);
    }

    @Test
    public void testGetDiffLink() throws Exception {
        for (GitChangeSet.Path path : this.sample.changeSet.getPaths()) {
            URL diffLink = this.phabricator.getDiffLink(path);
            URL expectedDiffLink = new URL("http://phabricator.example.com/diffusion/phabricatorRepo/change/master/" + path.getPath() + ";" + this.sample.id);
            String msg = "Wrong link for path: " + path.getPath();
            Assert.assertEquals((String)msg, (Object)expectedDiffLink, (Object)diffLink);
        }
    }

    @Test
    public void testGetFileLink() throws Exception {
        for (GitChangeSet.Path path : this.sample.changeSet.getPaths()) {
            URL fileLink = this.phabricator.getDiffLink(path);
            URL expectedFileLink = new URL("http://phabricator.example.com/diffusion/phabricatorRepo/change/master/" + path.getPath() + ";" + this.sample.id);
            String msg = "Wrong link for path: " + path.getPath();
            Assert.assertEquals((String)msg, (Object)expectedFileLink, (Object)fileLink);
        }
    }
}

