/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.User;
import hudson.plugins.git.UserRemoteConfig;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.util.ListBoxModel;
import java.util.Arrays;
import java.util.TreeSet;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.MockAuthorizationStrategy;

public class UserRemoteConfigTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();

    @Test
    public void credentialsDropdown() throws Exception {
        SystemCredentialsProvider.getInstance().getCredentials().add(new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "mycreds", null, "jenkins", "s3cr3t"));
        SystemCredentialsProvider.getInstance().save();
        FreeStyleProject p1 = this.r.createFreeStyleProject("p1");
        FreeStyleProject p2 = this.r.createFreeStyleProject("p2");
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new MockAuthorizationStrategy().grant(new Permission[]{Jenkins.ADMINISTER}).everywhere().to(new String[]{"admin"}).grant(new Permission[]{Jenkins.READ, Item.READ}).everywhere().to(new String[]{"dev"}).grant(new Permission[]{Item.EXTENDED_READ}).onItems(new Item[]{p1}).to(new String[]{"dev"}));
        this.assertCredentials((Item)p1, null, "dev", "", "mycreds");
        this.assertCredentials((Item)p2, null, "dev", "");
        this.assertCredentials((Item)p1, null, "admin", "", "mycreds");
        this.assertCredentials((Item)p2, null, "admin", "", "mycreds");
        this.assertCredentials((Item)p1, "othercreds", "dev", "", "mycreds", "othercreds");
        this.assertCredentials(null, null, "dev", "");
        this.assertCredentials(null, null, "admin", "", "mycreds");
        this.assertCredentials(null, "othercreds", "admin", "", "mycreds", "othercreds");
    }

    @Deprecated
    private void assertCredentials(@CheckForNull Item project, @CheckForNull String currentCredentialsId, @NonNull String user, String ... expectedCredentialsIds) {
        TreeSet actual = new TreeSet();
        ACL.impersonate((Authentication)User.get((String)user).impersonate(), () -> {
            for (ListBoxModel.Option option : ((UserRemoteConfig.DescriptorImpl)this.r.jenkins.getDescriptorByType(UserRemoteConfig.DescriptorImpl.class)).doFillCredentialsIdItems(project, "http://wherever.jenkins.io/", currentCredentialsId)) {
                actual.add(option.value);
            }
        });
        Assert.assertEquals((String)("expected completions on " + project + " as " + user + " starting with " + currentCredentialsId), (Object)Sets.newTreeSet(Arrays.asList(expectedCredentialsIds)), actual);
    }
}

