/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.UserMergeOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.jvnet.hudson.test.JenkinsRule;

@RunWith(value=Parameterized.class)
public class UserMergeOptionsTest {
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();
    private final UserMergeOptions options;
    private final UserMergeOptions deprecatedOptions;
    private final String expectedMergeRemote;
    private final String expectedMergeTarget;
    private final MergeCommand.Strategy expectedMergeStrategy;
    private final MergeCommand.GitPluginFastForwardMode expectedFastForwardMode;

    @Deprecated
    private UserMergeOptions defineDeprecatedOptions(String mergeRemote, String mergeTarget, MergeCommand.Strategy mergeStrategy) {
        return new UserMergeOptions(mergeRemote, mergeTarget, mergeStrategy == null ? null : mergeStrategy.toString());
    }

    public UserMergeOptionsTest(String mergeRemote, String mergeTarget, MergeCommand.Strategy mergeStrategy, MergeCommand.GitPluginFastForwardMode fastForwardMode) {
        this.expectedMergeRemote = mergeRemote;
        this.expectedMergeTarget = mergeTarget;
        this.expectedMergeStrategy = mergeStrategy;
        this.expectedFastForwardMode = fastForwardMode;
        this.options = new UserMergeOptions(mergeRemote, mergeTarget, mergeStrategy == null ? null : mergeStrategy.toString(), fastForwardMode);
        this.deprecatedOptions = this.defineDeprecatedOptions(mergeRemote, mergeTarget, mergeStrategy);
    }

    @Parameterized.Parameters(name="{0}+{1}+{2}+{3}")
    public static Collection mergeOptionVariants() {
        ArrayList<Object[]> mergeOptions = new ArrayList<Object[]>();
        String[] remotes = new String[]{null, "src_remote"};
        String[] targets = new String[]{null, "dst_remote"};
        MergeCommand.Strategy[] mergeStrategies = new MergeCommand.Strategy[]{null, MergeCommand.Strategy.DEFAULT, MergeCommand.Strategy.OCTOPUS, MergeCommand.Strategy.OURS, MergeCommand.Strategy.RECURSIVE, MergeCommand.Strategy.RESOLVE, MergeCommand.Strategy.SUBTREE};
        MergeCommand.GitPluginFastForwardMode[] fastForwardModes = new MergeCommand.GitPluginFastForwardMode[]{null, MergeCommand.GitPluginFastForwardMode.FF, MergeCommand.GitPluginFastForwardMode.FF_ONLY, MergeCommand.GitPluginFastForwardMode.NO_FF};
        for (String remote : remotes) {
            for (String target : targets) {
                for (MergeCommand.Strategy strategy : mergeStrategies) {
                    for (MergeCommand.GitPluginFastForwardMode mode : fastForwardModes) {
                        Object[] mergeOption = new Object[]{remote, target, strategy, mode};
                        mergeOptions.add(mergeOption);
                    }
                }
            }
        }
        return mergeOptions;
    }

    @Test
    public void testGetMergeRemote() {
        Assert.assertEquals((Object)this.expectedMergeRemote, (Object)this.options.getMergeRemote());
    }

    @Test
    public void testGetMergeTarget() {
        Assert.assertEquals((Object)this.expectedMergeTarget, (Object)this.options.getMergeTarget());
    }

    @Test
    public void testGetRef() {
        Assert.assertEquals((Object)(this.expectedMergeRemote + "/" + this.expectedMergeTarget), (Object)this.options.getRef());
    }

    @Test
    public void testGetMergeStrategy() {
        Assert.assertEquals((Object)(this.expectedMergeStrategy == null ? MergeCommand.Strategy.DEFAULT : this.expectedMergeStrategy), (Object)this.options.getMergeStrategy());
    }

    @Test
    public void testGetFastForwardMode() {
        Assert.assertEquals((Object)(this.expectedFastForwardMode == null ? MergeCommand.GitPluginFastForwardMode.FF : this.expectedFastForwardMode), (Object)this.options.getFastForwardMode());
    }

    @Test
    public void testToString() {
        String expected = "UserMergeOptions{mergeRemote='" + this.expectedMergeRemote + "', mergeTarget='" + this.expectedMergeTarget + "', mergeStrategy='" + (this.expectedMergeStrategy == null ? MergeCommand.Strategy.DEFAULT : this.expectedMergeStrategy).name() + "', fastForwardMode='" + (this.expectedFastForwardMode == null ? MergeCommand.GitPluginFastForwardMode.FF : this.expectedFastForwardMode).name() + "'" + '}';
        Assert.assertEquals((Object)expected, (Object)this.options.toString());
    }

    @Test
    public void testEqualsSymmetric() {
        UserMergeOptions expected = new UserMergeOptions(this.expectedMergeRemote, this.expectedMergeTarget, this.expectedMergeStrategy == null ? null : this.expectedMergeStrategy.toString(), this.expectedFastForwardMode);
        Assert.assertEquals((Object)expected, (Object)this.options);
        Assert.assertEquals((Object)this.options, (Object)expected);
    }

    @Test
    public void testEqualsReflexive() {
        UserMergeOptions expected = new UserMergeOptions(this.expectedMergeRemote, this.expectedMergeTarget, this.expectedMergeStrategy == null ? null : this.expectedMergeStrategy.toString(), this.expectedFastForwardMode);
        Assert.assertEquals((Object)this.options, (Object)this.options);
        Assert.assertEquals((Object)expected, (Object)expected);
    }

    @Test
    public void testEqualsTransitive() {
        UserMergeOptions expected = new UserMergeOptions(this.expectedMergeRemote, this.expectedMergeTarget, this.expectedMergeStrategy == null ? null : this.expectedMergeStrategy.toString(), this.expectedFastForwardMode);
        UserMergeOptions expected1 = new UserMergeOptions(this.expectedMergeRemote, this.expectedMergeTarget, this.expectedMergeStrategy == null ? null : this.expectedMergeStrategy.toString(), this.expectedFastForwardMode);
        Assert.assertEquals((Object)expected, (Object)expected1);
        Assert.assertEquals((Object)expected1, (Object)this.options);
        Assert.assertEquals((Object)expected, (Object)this.options);
    }

    @Test
    public void testEqualsDeprecatedConstructor() {
        if (this.expectedFastForwardMode == MergeCommand.GitPluginFastForwardMode.FF) {
            Assert.assertEquals((Object)this.options, (Object)this.deprecatedOptions);
        } else {
            Assert.assertNotEquals((Object)this.options, (Object)this.deprecatedOptions);
        }
    }

    @Test
    public void testNotEquals() {
        UserMergeOptions notExpected1 = new UserMergeOptions("x" + this.expectedMergeRemote, this.expectedMergeTarget, this.expectedMergeStrategy == null ? null : this.expectedMergeStrategy.toString(), this.expectedFastForwardMode);
        Assert.assertNotEquals((Object)notExpected1, (Object)this.options);
        UserMergeOptions notExpected2 = new UserMergeOptions(this.expectedMergeRemote, "y" + this.expectedMergeTarget, this.expectedMergeStrategy == null ? null : this.expectedMergeStrategy.toString(), this.expectedFastForwardMode);
        Assert.assertNotEquals((Object)notExpected2, (Object)this.options);
        Assert.assertNotEquals((Object)this.options, (Object)"A different data type");
    }

    @Test
    public void testHashCode() {
        UserMergeOptions expected = new UserMergeOptions(this.expectedMergeRemote, this.expectedMergeTarget, this.expectedMergeStrategy == null ? null : this.expectedMergeStrategy.toString(), this.expectedFastForwardMode);
        Assert.assertEquals((Object)expected, (Object)this.options);
        Assert.assertEquals((long)expected.hashCode(), (long)this.options.hashCode());
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(UserMergeOptions.class).usingGetClass().suppress(new Warning[]{Warning.NONFINAL_FIELDS}).verify();
    }

    @Test
    @Deprecated
    public void mergeStrategyCase() throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        if (this.expectedMergeTarget != null) {
            args.put("mergeTarget", this.expectedMergeTarget);
        }
        if (this.expectedMergeRemote != null) {
            args.put("mergeRemote", this.expectedMergeRemote);
        }
        if (this.expectedMergeStrategy != null) {
            args.put("mergeStrategy", this.expectedMergeStrategy.name());
        }
        if (this.expectedFastForwardMode != null) {
            args.put("fastForwardMode", this.expectedFastForwardMode.name());
        }
        Assert.assertEquals((Object)this.options, (Object)new DescribableModel(UserMergeOptions.class).instantiate(args));
        if (this.expectedMergeStrategy != null) {
            args.put("mergeStrategy", this.expectedMergeStrategy.toString());
            Assert.assertEquals((Object)this.options, (Object)new DescribableModel(UserMergeOptions.class).instantiate(args));
        }
    }
}

