/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitChangeSetUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class GitChangeSetBasicTest {
    private GitChangeSet genChangeSet(boolean authorOrCommitter, boolean useLegacyFormat) {
        return GitChangeSetUtil.genChangeSet(authorOrCommitter, useLegacyFormat, true);
    }

    private GitChangeSet genChangeSet(boolean authorOrCommitter, boolean useLegacyFormat, boolean hasParent) {
        return GitChangeSetUtil.genChangeSet(authorOrCommitter, useLegacyFormat, hasParent);
    }

    @Test
    public void testLegacyChangeSet() {
        GitChangeSet gitChangeSet = GitChangeSetUtil.genChangeSet(false, true, false, "Commit title.", false);
        GitChangeSetUtil.assertChangeSet(gitChangeSet);
    }

    @Test
    public void testChangeSet() {
        GitChangeSetUtil.assertChangeSet(this.genChangeSet(false, false));
    }

    @Test
    public void testChangeSetNoParent() {
        GitChangeSet changeSet = this.genChangeSet(false, false, false);
        GitChangeSetUtil.assertChangeSet(changeSet);
        Assert.assertNull((Object)changeSet.getParentCommit());
    }

    @Test
    public void testCommitter() {
        Assert.assertEquals((Object)"John Committer", (Object)this.genChangeSet(false, false).getAuthorName());
        Assert.assertEquals((Object)"jcommitter@nospam.com", (Object)this.genChangeSet(false, false).getAuthorEmail());
    }

    @Test
    public void testAuthor() {
        Assert.assertEquals((Object)"John Author", (Object)this.genChangeSet(true, false).getAuthorName());
        Assert.assertEquals((Object)"jauthor@nospam.com", (Object)this.genChangeSet(true, false).getAuthorEmail());
    }

    @Test
    public void testGetDate() {
        Assert.assertEquals((Object)"1970-01-15T06:56:08-0600", (Object)this.genChangeSet(true, false).getDate());
    }

    @Test
    public void testGetTimestamp() {
        Assert.assertEquals((long)1256168000L, (long)this.genChangeSet(true, false).getTimestamp());
    }

    @Test
    public void testInvalidDate() {
        String badDateString = "2015-03-03x09:22:42 -0700";
        GitChangeSet c = new GitChangeSet(Arrays.asList("author John Doe <john.doe@jenkins-ci.org> 2015-03-03x09:22:42 -0700"), true);
        Assert.assertEquals((Object)"2015-03-03x09:22:42 -0700", (Object)c.getDate());
        Assert.assertEquals((long)-1L, (long)c.getTimestamp());
    }

    @Test
    public void testIsoDate() {
        GitChangeSet c = new GitChangeSet(Arrays.asList("author John Doe <john.doe@jenkins-ci.org> 2015-03-03T09:22:42-0700"), true);
        Assert.assertEquals((Object)"2015-03-03T09:22:42-0700", (Object)c.getDate());
        Assert.assertEquals((long)1425399762000L, (long)c.getTimestamp());
        c = new GitChangeSet(Arrays.asList("author John Doe <john.doe@jenkins-ci.org> 2015-03-03T09:22:42-07:00"), true);
        Assert.assertEquals((Object)"2015-03-03T09:22:42-07:00", (Object)c.getDate());
        Assert.assertEquals((long)1425399762000L, (long)c.getTimestamp());
        c = new GitChangeSet(Arrays.asList("author John Doe <john.doe@jenkins-ci.org> 2015-03-03T16:22:42Z"), true);
        Assert.assertEquals((Object)"2015-03-03T16:22:42Z", (Object)c.getDate());
        Assert.assertEquals((long)1425399762000L, (long)c.getTimestamp());
        c = new GitChangeSet(Arrays.asList("author John Doe <john.doe@jenkins-ci.org> 1425399762"), true);
        Assert.assertEquals((Object)"2015-03-03T16:22:42Z", (Object)c.getDate());
        Assert.assertEquals((long)1425399762000L, (long)c.getTimestamp());
        c = new GitChangeSet(Arrays.asList("author John Doe <john.doe@jenkins-ci.org> 1425374562 -0700"), true);
        Assert.assertEquals((Object)"2015-03-03T09:22:42-0700", (Object)c.getDate());
        Assert.assertEquals((long)1425399762000L, (long)c.getTimestamp());
    }

    private GitChangeSet genChangeSetForSwedCase(boolean authorOrCommitter) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("commit 1567861636cd854f4dd6fa40bf94c0c657681dd5");
        lines.add("tree 66236cf9a1ac0c589172b450ed01f019a5697c49");
        lines.add("parent e74a24e995305bd67a180f0ebc57927e2b8783ce");
        lines.add("author mister\u00c5 <mister.ahlander@ericsson.com> 1363879004 +0100");
        lines.add("committer Mister \u00c5hlander <mister.ahlander@ericsson.com> 1364199539 -0400");
        lines.add("");
        lines.add("    [task] Updated version.");
        lines.add("    ");
        lines.add("    Including earlier updates.");
        lines.add("    ");
        lines.add("    Changes in this version:");
        lines.add("    - Changed to take the gerrit url from gerrit query command.");
        lines.add("    - Aligned reason information with our new commit hooks");
        lines.add("    ");
        lines.add("    Change-Id: Ife96d2abed5b066d9620034bec5f04cf74b8c66d");
        lines.add("    Reviewed-on: https://gerrit.e.se/12345");
        lines.add("    Tested-by: Jenkins <jenkins@no-mail.com>");
        lines.add("    Reviewed-by: Mister Another <mister.another@ericsson.com>");
        lines.add("");
        return new GitChangeSet(lines, authorOrCommitter);
    }

    @Test
    public void testSwedishCommitterName() {
        Assert.assertEquals((Object)"Mister \u00c5hlander", (Object)this.genChangeSetForSwedCase(false).getAuthorName());
    }

    @Test
    public void testSwedishAuthorName() {
        Assert.assertEquals((Object)"mister\u00c5", (Object)this.genChangeSetForSwedCase(true).getAuthorName());
    }

    @Test
    public void testSwedishDate() {
        Assert.assertEquals((Object)"2013-03-21T15:16:44+0100", (Object)this.genChangeSetForSwedCase(true).getDate());
    }

    @Test
    public void testSwedishTimestamp() {
        Assert.assertEquals((long)1363875404000L, (long)this.genChangeSetForSwedCase(true).getTimestamp());
    }

    @Test
    public void testChangeLogTruncationWithShortMessage() {
        GitChangeSet changeSet = GitChangeSetUtil.genChangeSet(true, false, true, "Lorem ipsum dolor sit amet.", false);
        String msg = changeSet.getMsg();
        MatcherAssert.assertThat((String)"Title is correct ", (Object)msg, (Matcher)Matchers.containsString((String)"Lorem ipsum dolor sit amet."));
        MatcherAssert.assertThat((String)"Title length is correct ", (Object)msg.length(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(72)));
    }

    @Test
    public void testChangeLogTruncationWithNewLine() {
        GitChangeSet changeSet = GitChangeSetUtil.genChangeSet(true, false, true, "Lorem ipsum dolor sit amet, " + System.lineSeparator() + "consectetur adipiscing elit.", false);
        String msg = changeSet.getMsg();
        MatcherAssert.assertThat((Object)msg, (Matcher)Matchers.is((Object)"Lorem ipsum dolor sit amet,"));
        MatcherAssert.assertThat((String)"Title length is correct ", (Object)msg.length(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(72)));
    }

    @Test
    public void testChangeLogRetainSummaryWithoutNewLine() {
        String originalCommitMessage = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus pellentesque ipsum non aliquam interdum. Integer metus orci, vulputate id turpis in, pharetra pretium magna. Fusce sollicitudin vehicula lectus. Nam ut eros purus. Mauris aliquam mi et nunc porta, non consectetur mauris pretium. Fusce a venenatis dolor. Sed commodo, dui ac posuere dignissim, dolor tortor semper eros, varius consequat nulla purus a lacus. Vestibulum egestas, orci vitae pellentesque laoreet, dolor lorem molestie tellus, nec luctus lorem ex quis orci. Phasellus interdum elementum luctus. Nam commodo, turpis in sollicitudin auctor, ipsum lectus finibus erat, in iaculis sapien neque ultrices sapien. In congue diam semper tortor laoreet aliquet. Mauris lacinia quis nunc vel accumsan. Nullam sed nisl eget orci porttitor venenatis. Lorem ipsum dolor sit amet, consectetur adipiscing elit";
        GitChangeSet changeSet = GitChangeSetUtil.genChangeSet(true, false, true, originalCommitMessage, true);
        MatcherAssert.assertThat((Object)changeSet.getMsg(), (Matcher)Matchers.is((Object)originalCommitMessage));
    }

    @Test
    public void testChangeLogDoNotRetainSummaryWithoutNewLine() {
        String msg = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus pellentesque ipsum non aliquam interdum. Integer metus orci, vulputate id turpis in, pharetra pretium magna. Fusce sollicitudin vehicula lectus. Nam ut eros purus. Mauris aliquam mi et nunc porta, non consectetur mauris pretium. Fusce a venenatis dolor. Sed commodo, dui ac posuere dignissim, dolor tortor semper eros, varius consequat nulla purus a lacus. Vestibulum egestas, orci vitae pellentesque laoreet, dolor lorem molestie tellus, nec luctus lorem ex quis orci. Phasellus interdum elementum luctus. Nam commodo, turpis in sollicitudin auctor, ipsum lectus finibus erat, in iaculis sapien neque ultrices sapien. In congue diam semper tortor laoreet aliquet. Mauris lacinia quis nunc vel accumsan. Nullam sed nisl eget orci porttitor venenatis. Lorem ipsum dolor sit amet, consectetur adipiscing elit";
        GitChangeSet changeSet = GitChangeSetUtil.genChangeSet(true, false, true, msg, false);
        MatcherAssert.assertThat((Object)changeSet.getMsg(), (Matcher)Matchers.is((Object)"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus"));
    }

    @Test
    public void testChangeLogNoTruncationWithNewLine() {
        GitChangeSet changeSet = GitChangeSetUtil.genChangeSet(true, false, true, "Lorem ipsum dolor sit amet, consectetur " + System.lineSeparator() + " adipiscing elit. Phasellus pellentesque ipsum non aliquam interdum. Integer metus orci, vulputate id turpis in, pharetra pretium magna. Fusce sollicitudin vehicula lectus. Nam ut eros purus. Mauris aliquam mi et nunc porta, non consectetur mauris pretium. Fusce a venenatis dolor. Sed commodo, dui ac posuere dignissim, dolor tortor semper eros, varius consequat nulla purus a lacus. Vestibulum egestas, orci vitae pellentesque laoreet, dolor lorem molestie tellus, nec luctus lorem ex quis orci. Phasellus interdum elementum luctus. Nam commodo, turpis in sollicitudin auctor, ipsum lectus finibus erat, in iaculis sapien neque ultrices sapien. In congue diam semper tortor laoreet aliquet. Mauris lacinia quis nunc vel accumsan. Nullam sed nisl eget orci porttitor venenatis. Lorem ipsum dolor sit amet, consectetur adipiscing elit", true);
        String msg = changeSet.getMsg();
        MatcherAssert.assertThat((String)"Title is correct ", (Object)msg, (Matcher)Matchers.is((Object)"Lorem ipsum dolor sit amet, consectetur"));
    }

    @Test
    public void testChangeLogEdgeCaseNotTruncating() {
        GitChangeSet changeSet = GitChangeSetUtil.genChangeSet(true, false, true, "[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0 2 4 5", false);
        String msg = changeSet.getMsg();
        MatcherAssert.assertThat((Object)msg.length(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(72)));
        MatcherAssert.assertThat((Object)msg, (Matcher)Matchers.is((Object)"[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0 2"));
    }

    @Test
    public void testChangeLogEdgeCaseTruncating() {
        GitChangeSet changeSet = GitChangeSetUtil.genChangeSet(true, false, true, "[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0 2 4 5", true);
        String msg = changeSet.getMsg();
        MatcherAssert.assertThat((Object)msg, (Matcher)Matchers.is((Object)"[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0 2 4 5"));
    }

    @Test
    public void testChangeLogEdgeCaseTruncatingAndNewLine() {
        GitChangeSet changeSet = GitChangeSetUtil.genChangeSet(true, false, true, "[JENKINS-012345] 8901 34567 " + System.lineSeparator() + "90 23456 8901 34567 9012 4567890 2345678 0 2 4 5", true);
        String msg = changeSet.getMsg();
        MatcherAssert.assertThat((Object)msg, (Matcher)Matchers.is((Object)"[JENKINS-012345] 8901 34567"));
    }

    @Test
    public void testLongString() {
        GitChangeSet changeSet = GitChangeSetUtil.genChangeSet(true, false, true, "12345678901234567890123456789012345678901234567890123456789012345678901234567890", false);
        String msg = changeSet.getMsg();
        MatcherAssert.assertThat((Object)msg, (Matcher)Matchers.is((Object)"12345678901234567890123456789012345678901234567890123456789012345678901234567890"));
    }

    @Test
    public void stringSplitter() {
        String msg = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus pellentesque ipsum non aliquam interdum. Integer metus orci, vulputate id turpis in, pharetra pretium magna. Fusce sollicitudin vehicula lectus. Nam ut eros purus. Mauris aliquam mi et nunc porta, non consectetur mauris pretium. Fusce a venenatis dolor. Sed commodo, dui ac posuere dignissim, dolor tortor semper eros, varius consequat nulla purus a lacus. Vestibulum egestas, orci vitae pellentesque laoreet, dolor lorem molestie tellus, nec luctus lorem ex quis orci. Phasellus interdum elementum luctus. Nam commodo, turpis in sollicitudin auctor, ipsum lectus finibus erat, in iaculis sapien neque ultrices sapien. In congue diam semper tortor laoreet aliquet. Mauris lacinia quis nunc vel accumsan. Nullam sed nisl eget orci porttitor venenatis. Lorem ipsum dolor sit amet, consectetur adipiscing elit";
        MatcherAssert.assertThat((Object)GitChangeSet.splitString((String)msg, (int)15), (Matcher)Matchers.is((Object)"Lorem ipsum"));
        MatcherAssert.assertThat((Object)GitChangeSet.splitString((String)msg, (int)16), (Matcher)Matchers.is((Object)"Lorem ipsum"));
        MatcherAssert.assertThat((Object)GitChangeSet.splitString((String)msg, (int)17), (Matcher)Matchers.is((Object)"Lorem ipsum dolor"));
        MatcherAssert.assertThat((Object)GitChangeSet.splitString((String)msg, (int)18), (Matcher)Matchers.is((Object)"Lorem ipsum dolor"));
        MatcherAssert.assertThat((Object)GitChangeSet.splitString((String)msg, (int)19), (Matcher)Matchers.is((Object)"Lorem ipsum dolor"));
        MatcherAssert.assertThat((Object)GitChangeSet.splitString((String)msg, (int)20), (Matcher)Matchers.is((Object)"Lorem ipsum dolor"));
        MatcherAssert.assertThat((Object)GitChangeSet.splitString((String)msg, (int)21), (Matcher)Matchers.is((Object)"Lorem ipsum dolor sit"));
        MatcherAssert.assertThat((Object)GitChangeSet.splitString((String)msg, (int)22), (Matcher)Matchers.is((Object)"Lorem ipsum dolor sit"));
        msg = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus pellentesque ipsum non aliquam interdum.";
        MatcherAssert.assertThat((Object)GitChangeSet.splitString((String)msg, (int)72), (Matcher)Matchers.is((Object)"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus"));
    }

    @Test
    public void splitingWithBrackets() {
        MatcherAssert.assertThat((Object)GitChangeSet.splitString((String)"[task] Lorem ipsum dolor sit amet, consectetur adipiscing elit.", (int)25), (Matcher)Matchers.is((Object)"[task] Lorem ipsum dolor"));
    }

    @Test
    public void splitingEmptyString() {
        MatcherAssert.assertThat((Object)GitChangeSet.splitString((String)"", (int)25), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void splitingNullString() {
        MatcherAssert.assertThat((Object)GitChangeSet.splitString(null, (int)25), (Matcher)Matchers.is((Object)""));
    }
}

