/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.Item;
import hudson.plugins.git.GitBranchSpecifierColumn;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class GitBranchSpecifierColumnTest {
    @Test
    public void testGetBranchSpecifierNull() {
        Item item = null;
        GitBranchSpecifierColumn branchSpecifierColumn = new GitBranchSpecifierColumn();
        List result = branchSpecifierColumn.getBranchSpecifier(item);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.emptyCollectionOf(String.class)));
    }

    @Test
    public void testBreakOutString() {
        ArrayList<String> branches = new ArrayList<String>();
        String MASTER_BRANCH = "master";
        branches.add("master");
        String DEVELOP_BRANCH = "develop";
        branches.add(DEVELOP_BRANCH);
        GitBranchSpecifierColumn branchSpecifier = new GitBranchSpecifierColumn();
        String result = branchSpecifier.breakOutString(branches);
        Assert.assertEquals((Object)("master, " + DEVELOP_BRANCH), (Object)result);
    }

    @Test
    public void testBreakOutStringEmpty() {
        ArrayList branches = new ArrayList();
        GitBranchSpecifierColumn branchSpecifier = new GitBranchSpecifierColumn();
        String result = branchSpecifier.breakOutString(branches);
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testBreakOutStringNull() {
        List branches = null;
        GitBranchSpecifierColumn branchSpecifier = new GitBranchSpecifierColumn();
        String result = branchSpecifier.breakOutString(branches);
        Assert.assertEquals(null, (Object)result);
    }
}

