/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.EnvVars;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeSet;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.IDN;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.UrlValidator;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class GitRepositoryBrowser
extends RepositoryBrowser<GitChangeSet> {
    private String url;
    private static final long serialVersionUID = 1L;

    @Deprecated
    protected GitRepositoryBrowser() {
    }

    protected GitRepositoryBrowser(String repourl) {
        this.url = repourl;
    }

    public final String getRepoUrl() {
        return this.url;
    }

    public final URL getUrl() throws IOException {
        Job job;
        String u = this.url;
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null && (job = (Job)req.findAncestorObject(Job.class)) != null) {
            EnvVars env;
            try {
                env = job.getEnvironment(null, TaskListener.NULL);
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to retrieve job environment", e);
            }
            u = env.expand(this.url);
        }
        if (this.getNormalizeUrl()) {
            return GitRepositoryBrowser.normalizeToEndWithSlash((URL)new URL(u));
        }
        return new URL(u);
    }

    public abstract URL getDiffLink(GitChangeSet.Path var1) throws IOException;

    public abstract URL getFileLink(GitChangeSet.Path var1) throws IOException, URISyntaxException;

    protected boolean getNormalizeUrl() {
        return true;
    }

    protected int getIndexOfPath(GitChangeSet.Path path) throws IOException {
        String pathAsString = path.getPath();
        GitChangeSet changeSet = path.getChangeSet();
        int i = 0;
        for (String affected : changeSet.getAffectedPaths()) {
            if (affected.compareTo(pathAsString) >= 0) continue;
            ++i;
        }
        return i;
    }

    public static URL encodeURL(URL url) throws IOException {
        try {
            return new URI(url.getProtocol(), url.getUserInfo(), IDN.toASCII(url.getHost()), url.getPort(), url.getPath(), url.getQuery(), url.getRef()).toURL();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    protected static boolean initialChecksAndReturnOk(Item project, String cleanUrl) {
        if (cleanUrl == null) {
            return true;
        }
        if (project == null || !project.hasPermission(Item.CONFIGURE)) {
            return true;
        }
        return cleanUrl.contains("$");
    }

    protected static boolean validateUrl(String url) throws URISyntaxException {
        DomainValidator.Item item = new DomainValidator.Item(DomainValidator.ArrayType.GENERIC_PLUS, new String[]{"corp", "home", "local", "localnet"});
        ArrayList<DomainValidator.Item> itemList = new ArrayList<DomainValidator.Item>();
        itemList.add(item);
        DomainValidator domainValidator = DomainValidator.getInstance((boolean)true, itemList);
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes, null, 8L, domainValidator);
        return urlValidator.isValid(url);
    }
}

