/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Messages;
import hudson.plugins.git.extensions.impl.PerBuildTag;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.PushCommand;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class GitPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long configVersion;
    private boolean pushMerge;
    private boolean pushOnlyIfSuccess;
    private boolean forcePush;
    private List<TagToPush> tagsToPush;
    private List<BranchToPush> branchesToPush;
    private List<NoteToPush> notesToPush;

    @DataBoundConstructor
    public GitPublisher(List<TagToPush> tagsToPush, List<BranchToPush> branchesToPush, List<NoteToPush> notesToPush, boolean pushOnlyIfSuccess, boolean pushMerge, boolean forcePush) {
        this.tagsToPush = tagsToPush;
        this.branchesToPush = branchesToPush;
        this.notesToPush = notesToPush;
        this.pushMerge = pushMerge;
        this.pushOnlyIfSuccess = pushOnlyIfSuccess;
        this.forcePush = forcePush;
        this.configVersion = 2L;
    }

    public boolean isPushOnlyIfSuccess() {
        return this.pushOnlyIfSuccess;
    }

    public boolean isPushMerge() {
        return this.pushMerge;
    }

    public boolean isForcePush() {
        return this.forcePush;
    }

    public boolean isPushTags() {
        if (this.tagsToPush == null) {
            return false;
        }
        return !this.tagsToPush.isEmpty();
    }

    public boolean isPushBranches() {
        if (this.branchesToPush == null) {
            return false;
        }
        return !this.branchesToPush.isEmpty();
    }

    public boolean isPushNotes() {
        if (this.notesToPush == null) {
            return false;
        }
        return !this.notesToPush.isEmpty();
    }

    public List<TagToPush> getTagsToPush() {
        if (this.tagsToPush == null) {
            this.tagsToPush = new ArrayList<TagToPush>();
        }
        return this.tagsToPush;
    }

    public List<BranchToPush> getBranchesToPush() {
        if (this.branchesToPush == null) {
            this.branchesToPush = new ArrayList<BranchToPush>();
        }
        return this.branchesToPush;
    }

    public List<NoteToPush> getNotesToPush() {
        if (this.notesToPush == null) {
            this.notesToPush = new ArrayList<NoteToPush>();
        }
        return this.notesToPush;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private String replaceAdditionalEnvironmentalVariables(String input, AbstractBuild<?, ?> build) {
        if (build == null) {
            return input;
        }
        String buildResult = "";
        Result result = build.getResult();
        if (result != null) {
            buildResult = result.toString();
        }
        String buildDuration = build.getDurationString().replaceAll("and counting", "");
        input = input.replaceAll("\\$BUILDRESULT", buildResult);
        input = input.replaceAll("\\$BUILDDURATION", buildDuration);
        return input;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        URIish remoteURI;
        if (build.getClass().getName().equals("hudson.matrix.MatrixRun")) {
            return true;
        }
        SCM scm = build.getProject().getScm();
        if (!(scm instanceof GitSCM)) {
            return false;
        }
        GitSCM gitSCM = (GitSCM)scm;
        String projectName = build.getProject().getName();
        int buildNumber = build.getNumber();
        Result buildResult = build.getResult();
        if (this.pushOnlyIfSuccess && buildResult.isWorseThan(Result.SUCCESS)) {
            listener.getLogger().println("Build did not succeed and the project is configured to only push after a successful build, so no pushing will occur.");
            return true;
        }
        EnvVars environment = build.getEnvironment((TaskListener)listener);
        GitClient git = gitSCM.createClient((TaskListener)listener, environment, (Run<?, ?>)build, build.getWorkspace());
        if (this.pushMerge) {
            try {
                if (gitSCM.getExtensions().get(PerBuildTag.class) != null) {
                    String buildnumber = "jenkins-" + projectName.replace(" ", "_") + "-" + buildNumber;
                    if (git.tagExists(buildnumber)) {
                        git.deleteTag(buildnumber);
                    }
                    buildnumber = buildnumber + "-" + buildResult.toString();
                    git.tag(buildnumber, "Jenkins Build #" + buildNumber);
                }
                PreBuildMergeOptions mergeOptions = gitSCM.getMergeOptions();
                String string = environment.expand(mergeOptions.getMergeTarget());
                if (mergeOptions.doMerge() && buildResult.isBetterOrEqualTo(Result.SUCCESS)) {
                    RemoteConfig remote = mergeOptions.getMergeRemote();
                    remote = gitSCM.getParamExpandedRepo(environment, remote);
                    listener.getLogger().println("Pushing HEAD to branch " + string + " of " + remote.getName() + " repository");
                    remoteURI = (URIish)remote.getURIs().get(0);
                    PushCommand push = git.push().to(remoteURI).ref("HEAD:" + string).force(this.forcePush);
                    push.execute();
                }
            }
            catch (Descriptor.FormException | GitException e) {
                e.printStackTrace(listener.error("Failed to push merge to origin repository"));
                return false;
            }
        }
        if (this.isPushTags()) {
            for (TagToPush tagToPush : this.tagsToPush) {
                if (tagToPush.getTagName() == null) {
                    throw new AbortException("No tag to push defined");
                }
                if (tagToPush.getTargetRepoName() == null) {
                    throw new AbortException("No target repo to push to defined");
                }
                String tagName = environment.expand(tagToPush.getTagName());
                String tagMessage = Util.fixNull((String)environment.expand(tagToPush.getTagMessage()));
                String targetRepo = environment.expand(tagToPush.getTargetRepoName());
                try {
                    RemoteConfig remote = gitSCM.getRepositoryByName(tagToPush.getTargetRepoName());
                    if (remote == null) {
                        throw new AbortException("No repository found for target repo name " + targetRepo);
                    }
                    remote = gitSCM.getParamExpandedRepo(environment, remote);
                    boolean tagExists = git.tagExists(tagName.replace(' ', '_'));
                    if (tagToPush.isCreateTag() || tagToPush.isUpdateTag()) {
                        if (tagExists && !tagToPush.isUpdateTag()) {
                            throw new AbortException("Tag " + tagName + " already exists and Create Tag is specified, so failing.");
                        }
                        if (tagMessage.length() == 0) {
                            git.tag(tagName, "Jenkins Git plugin tagging with " + tagName);
                        } else {
                            git.tag(tagName, tagMessage);
                        }
                    } else if (!tagExists) {
                        throw new AbortException("Tag " + tagName + " does not exist and Create Tag is not specified, so failing.");
                    }
                    listener.getLogger().println("Pushing tag " + tagName + " to repo " + targetRepo);
                    remoteURI = (URIish)remote.getURIs().get(0);
                    PushCommand push = git.push().to(remoteURI).ref(tagName).force(this.forcePush);
                    push.execute();
                }
                catch (GitException e) {
                    e.printStackTrace(listener.error("Failed to push tag " + tagName + " to " + targetRepo));
                    return false;
                }
            }
        }
        if (this.isPushBranches()) {
            for (BranchToPush branchToPush : this.branchesToPush) {
                if (branchToPush.getBranchName() == null) {
                    throw new AbortException("No branch to push defined");
                }
                if (branchToPush.getTargetRepoName() == null) {
                    throw new AbortException("No branch repo to push to defined");
                }
                String branchName = environment.expand(branchToPush.getBranchName());
                String targetRepo = environment.expand(branchToPush.getTargetRepoName());
                try {
                    RemoteConfig remote = gitSCM.getRepositoryByName(branchToPush.getTargetRepoName());
                    if (remote == null) {
                        throw new AbortException("No repository found for target repo name " + targetRepo);
                    }
                    remote = gitSCM.getParamExpandedRepo(environment, remote);
                    remoteURI = (URIish)remote.getURIs().get(0);
                    if (branchToPush.getRebaseBeforePush()) {
                        listener.getLogger().println("Fetch and rebase with " + branchName + " of " + targetRepo);
                        git.fetch_().from(remoteURI, remote.getFetchRefSpecs()).execute();
                        if (!git.revParse("HEAD").equals((AnyObjectId)git.revParse(targetRepo + "/" + branchName))) {
                            git.rebase().setUpstream(targetRepo + "/" + branchName).execute();
                        } else {
                            listener.getLogger().println("No rebase required. HEAD equals " + targetRepo + "/" + branchName);
                        }
                    }
                    listener.getLogger().println("Pushing HEAD to branch " + branchName + " at repo " + targetRepo);
                    PushCommand push = git.push().to(remoteURI).ref("HEAD:" + branchName).force(this.forcePush);
                    push.execute();
                }
                catch (GitException e) {
                    e.printStackTrace(listener.error("Failed to push branch " + branchName + " to " + targetRepo));
                    return false;
                }
            }
        }
        if (this.isPushNotes()) {
            for (NoteToPush noteToPush : this.notesToPush) {
                if (noteToPush.getnoteMsg() == null) {
                    throw new AbortException("No note to push defined");
                }
                noteToPush.setEmptyTargetRepoToOrigin();
                String noteMsgTmp = environment.expand(noteToPush.getnoteMsg());
                String noteMsg = this.replaceAdditionalEnvironmentalVariables(noteMsgTmp, build);
                String noteNamespace = environment.expand(noteToPush.getnoteNamespace());
                String targetRepo = environment.expand(noteToPush.getTargetRepoName());
                boolean noteReplace = noteToPush.getnoteReplace();
                try {
                    RemoteConfig remote = gitSCM.getRepositoryByName(noteToPush.getTargetRepoName());
                    if (remote == null) {
                        listener.getLogger().println("No repository found for target repo name " + targetRepo);
                        return false;
                    }
                    remote = gitSCM.getParamExpandedRepo(environment, remote);
                    listener.getLogger().println("Adding note to namespace \"" + noteNamespace + "\":\n" + noteMsg + "\n******");
                    if (noteReplace) {
                        git.addNote(noteMsg, noteNamespace);
                    } else {
                        git.appendNote(noteMsg, noteNamespace);
                    }
                    remoteURI = (URIish)remote.getURIs().get(0);
                    PushCommand push = git.push().to(remoteURI).ref("refs/notes/*").force(this.forcePush);
                    push.execute();
                }
                catch (GitException e) {
                    e.printStackTrace(listener.error("Failed to add note: \n" + noteMsg + "\n******"));
                    return false;
                }
            }
        }
        return true;
    }

    private Object readResolve() {
        if (this.configVersion == null) {
            this.configVersion = 0L;
        }
        if (this.configVersion < 1L && this.tagsToPush == null) {
            this.pushMerge = true;
        }
        return this;
    }

    public static final class NoteToPush
    extends PushConfig {
        private String noteMsg;
        private String noteNamespace;
        private boolean noteReplace;

        public String getnoteMsg() {
            return this.noteMsg;
        }

        public String getnoteNamespace() {
            return this.noteNamespace;
        }

        public boolean getnoteReplace() {
            return this.noteReplace;
        }

        @DataBoundConstructor
        public NoteToPush(String targetRepoName, String noteMsg, String noteNamespace, boolean noteReplace) {
            super(targetRepoName);
            this.noteMsg = Util.fixEmptyAndTrim((String)noteMsg);
            this.noteReplace = noteReplace;
            this.noteNamespace = noteNamespace != null && noteNamespace.trim().length() != 0 ? Util.fixEmptyAndTrim((String)noteNamespace) : "master";
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<PushConfig> {
            public String getDisplayName() {
                return "";
            }
        }
    }

    public static final class TagToPush
    extends PushConfig {
        private String tagName;
        private String tagMessage;
        private boolean createTag;
        private boolean updateTag;

        public String getTagName() {
            return this.tagName;
        }

        public String getTagMessage() {
            return this.tagMessage;
        }

        public boolean isCreateTag() {
            return this.createTag;
        }

        public boolean isUpdateTag() {
            return this.updateTag;
        }

        @DataBoundConstructor
        public TagToPush(String targetRepoName, String tagName, String tagMessage, boolean createTag, boolean updateTag) {
            super(targetRepoName);
            this.tagName = Util.fixEmptyAndTrim((String)tagName);
            this.tagMessage = tagMessage;
            this.createTag = createTag;
            this.updateTag = updateTag;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<PushConfig> {
            public String getDisplayName() {
                return "";
            }
        }
    }

    public static final class BranchToPush
    extends PushConfig {
        private String branchName;
        private boolean rebaseBeforePush;

        public String getBranchName() {
            return this.branchName;
        }

        @DataBoundConstructor
        public BranchToPush(String targetRepoName, String branchName) {
            super(targetRepoName);
            this.branchName = Util.fixEmptyAndTrim((String)branchName);
        }

        @DataBoundSetter
        public void setRebaseBeforePush(boolean shouldRebase) {
            this.rebaseBeforePush = shouldRebase;
        }

        public boolean getRebaseBeforePush() {
            return this.rebaseBeforePush;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<PushConfig> {
            public String getDisplayName() {
                return "";
            }
        }
    }

    public static abstract class PushConfig
    extends AbstractDescribableImpl<PushConfig>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String targetRepoName;

        public PushConfig(String targetRepoName) {
            this.targetRepoName = Util.fixEmptyAndTrim((String)targetRepoName);
        }

        public String getTargetRepoName() {
            return this.targetRepoName;
        }

        public void setTargetRepoName(String targetRepoName) {
            this.targetRepoName = targetRepoName;
        }

        public void setEmptyTargetRepoToOrigin() {
            if (this.targetRepoName == null || this.targetRepoName.trim().length() == 0) {
                this.targetRepoName = "origin";
            }
        }
    }

    @Extension(ordinal=-1.0)
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Git Publisher";
        }

        public String getHelpFile() {
            return "/plugin/git/gitPublisher.html";
        }

        public FormValidation doCheck(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }

        public FormValidation doCheckTagName(@QueryParameter String value) {
            return this.checkFieldNotEmpty(value, Messages.GitPublisher_Check_TagName());
        }

        public FormValidation doCheckBranchName(@QueryParameter String value) {
            return this.checkFieldNotEmpty(value, Messages.GitPublisher_Check_BranchName());
        }

        public FormValidation doCheckNoteMsg(@QueryParameter String value) {
            return this.checkFieldNotEmpty(value, Messages.GitPublisher_Check_Note());
        }

        public FormValidation doCheckRemote(@AncestorInPath AbstractProject project, StaplerRequest req) throws IOException, ServletException {
            boolean isMerge;
            String remote = req.getParameter("value");
            boolean bl = isMerge = req.getParameter("isMerge") != null;
            if (remote.length() == 0 && isMerge) {
                return FormValidation.ok();
            }
            FormValidation validation = this.checkFieldNotEmpty(remote, Messages.GitPublisher_Check_RemoteName());
            if (validation.kind != FormValidation.Kind.OK) {
                return validation;
            }
            if (!(project.getScm() instanceof GitSCM)) {
                return FormValidation.warning((String)"Project not currently configured to use Git; cannot check remote repository");
            }
            GitSCM scm = (GitSCM)project.getScm();
            if (scm.getRepositoryByName(remote) == null) {
                return FormValidation.error((String)("No remote repository configured with name '" + remote + "'"));
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        private FormValidation checkFieldNotEmpty(String value, String field) {
            if ((value = StringUtils.strip((String)value)) == null || value.equals("")) {
                return FormValidation.error((String)Messages.GitPublisher_Check_Required(field));
            }
            return FormValidation.ok();
        }
    }
}

