/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class FisheyeGitRepositoryBrowser
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 2881872624557203410L;

    @DataBoundConstructor
    public FisheyeGitRepositoryBrowser(String repoUrl) {
        super(repoUrl);
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        String r1 = path.getChangeSet().getParentCommit();
        String r2 = path.getChangeSet().getId();
        return new URL(this.getUrl(), this.getPath(path) + String.format("?r1=%s&r2=%s", r1, r2));
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        return FisheyeGitRepositoryBrowser.encodeURL(new URL(this.getUrl(), this.getPath(path)));
    }

    private String getPath(GitChangeSet.Path path) {
        return FisheyeGitRepositoryBrowser.trimHeadSlash((String)path.getPath());
    }

    private String getProjectName() throws IOException {
        String p = this.getUrl().getPath();
        if (p.endsWith("/")) {
            p = p.substring(0, p.length() - 1);
        }
        int idx = p.lastIndexOf(47);
        return p.substring(idx + 1);
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        return new URL(this.getUrl(), "../../changelog/" + this.getProjectName() + "?cs=" + changeSet.getId());
    }

    @Extension
    public static class FisheyeGitRepositoryBrowserDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        private static final Pattern URL_PATTERN = Pattern.compile(".+/browse/[^/]+/");

        @NonNull
        public String getDisplayName() {
            return "FishEye";
        }

        public FisheyeGitRepositoryBrowser newInstance(StaplerRequest req, @NonNull JSONObject jsonObject) throws Descriptor.FormException {
            assert (req != null);
            return (FisheyeGitRepositoryBrowser)((Object)req.bindJSON(FisheyeGitRepositoryBrowser.class, jsonObject));
        }

        @RequirePOST
        public FormValidation doCheckRepoUrl(@QueryParameter(fixEmpty=true) String value) throws IOException, ServletException {
            if (value == null) {
                return FormValidation.ok();
            }
            if (!value.endsWith("/")) {
                value = value + '/';
            }
            if (!URL_PATTERN.matcher(value).matches()) {
                return FormValidation.errorWithMarkup((String)"The URL should end like <code>.../browse/foobar/</code>");
            }
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            final String finalValue = value;
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    try {
                        if (this.findText(this.open(new URL(finalValue)), "FishEye")) {
                            return FormValidation.ok();
                        }
                        return FormValidation.error((String)"This is a valid URL but it doesn't look like FishEye");
                    }
                    catch (IOException e) {
                        return this.handleIOException(finalValue, e);
                    }
                }
            }.check();
        }
    }
}

