/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.model.PersistentDescriptor;
import hudson.remoting.Channel;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Symbol(value={"gitHooks"})
@Restricted(value={NoExternalUse.class})
public class GitHooksConfiguration
extends GlobalConfiguration
implements PersistentDescriptor {
    public static final String DISABLED_WIN = "NUL:";
    public static final String DISABLED_NIX = "/dev/null";
    static final Logger LOGGER = Logger.getLogger(GitHooksConfiguration.class.getName());
    private boolean allowedOnController = false;
    private boolean allowedOnAgents = false;

    @NonNull
    public static GitHooksConfiguration get() {
        GitHooksConfiguration configuration = (GitHooksConfiguration)((Object)GlobalConfiguration.all().get(GitHooksConfiguration.class));
        if (configuration == null) {
            throw new IllegalStateException("[BUG] No configuration registered, make sure not running on an agent or that Jenkins has started properly.");
        }
        return configuration;
    }

    public boolean isAllowedOnController() {
        return this.allowedOnController;
    }

    public void setAllowedOnController(boolean allowedOnController) {
        this.allowedOnController = allowedOnController;
        this.save();
    }

    public boolean isAllowedOnAgents() {
        return this.allowedOnAgents;
    }

    public void setAllowedOnAgents(boolean allowedOnAgents) {
        this.allowedOnAgents = allowedOnAgents;
        this.save();
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    public static void configure(GitClient client) throws IOException, InterruptedException {
        GitHooksConfiguration configuration = GitHooksConfiguration.get();
        GitHooksConfiguration.configure(client, configuration.isAllowedOnController(), configuration.isAllowedOnAgents());
    }

    public static void configure(GitClient client, boolean allowedOnController, boolean allowedOnAgents) throws IOException, InterruptedException {
        if (Channel.current() == null) {
            try (Repository ignored = client.getRepository();){
                GitHooksConfiguration.configure(client, allowedOnController);
            }
            catch (UnsupportedOperationException e) {
                GitHooksConfiguration.configure(client, allowedOnAgents);
            }
        } else {
            GitHooksConfiguration.configure(client, allowedOnAgents);
        }
    }

    public static void configure(GitClient client, boolean allowed) throws IOException, InterruptedException {
        if (!allowed) {
            client.withRepository((RepositoryCallback & Serializable)(repo, channel) -> {
                GitHooksConfiguration.disable(repo);
                return null;
            });
        } else {
            client.withRepository((RepositoryCallback & Serializable)(repo, channel) -> {
                GitHooksConfiguration.unset(repo);
                return null;
            });
        }
    }

    private static void unset(Repository repo) throws IOException {
        StoredConfig repoConfig = repo.getConfig();
        String val = repoConfig.getString("core", null, "hooksPath");
        if (!(StringUtils.isEmpty((String)val) || DISABLED_NIX.equals(val) || DISABLED_WIN.equals(val))) {
            LOGGER.warning(() -> String.format("core.hooksPath explicitly set to %s and will be left intact on %s.", val, repo.getDirectory()));
        } else {
            repoConfig.unset("core", null, "hooksPath");
            repoConfig.save();
        }
    }

    private static void disable(Repository repo) throws IOException {
        String VAL = Functions.isWindows() ? DISABLED_WIN : DISABLED_NIX;
        StoredConfig repoConfig = repo.getConfig();
        repoConfig.setString("core", null, "hooksPath", VAL);
        repoConfig.save();
    }
}

