/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.converters.Converter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitLockFailedException;
import hudson.plugins.git.GitSCMBackwardCompatibility;
import hudson.plugins.git.GitTagAction;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.ObjectIdConverter;
import hudson.plugins.git.RemoteConfigConverter;
import hudson.plugins.git.Revision;
import hudson.plugins.git.RevisionParameterAction;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.UserMergeOptions;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.BitbucketWeb;
import hudson.plugins.git.browser.GitLab;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.browser.GithubWeb;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.plugins.git.extensions.impl.AuthorInChangelog;
import hudson.plugins.git.extensions.impl.BuildChooserSetting;
import hudson.plugins.git.extensions.impl.BuildSingleRevisionOnly;
import hudson.plugins.git.extensions.impl.ChangelogToBranch;
import hudson.plugins.git.extensions.impl.CloneOption;
import hudson.plugins.git.extensions.impl.LocalBranch;
import hudson.plugins.git.extensions.impl.PathRestriction;
import hudson.plugins.git.extensions.impl.RelativeTargetDirectory;
import hudson.plugins.git.extensions.impl.ScmName;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.DefaultBuildChooser;
import hudson.plugins.git.util.GitUtils;
import hudson.plugins.git.util.RevCommitRepositoryCallback;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.scm.AbstractScmTagAction;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.security.Permission;
import hudson.triggers.SCMTrigger;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.LogTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMMatrixUtil;
import jenkins.plugins.git.GitToolChooser;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.ChangelogCommand;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.CliGitAPIImpl;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;
import org.jenkinsci.plugins.gitclient.UnsupportedCommand;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class GitSCM
extends GitSCMBackwardCompatibility {
    static final String ALLOW_LOCAL_CHECKOUT_PROPERTY = GitSCM.class.getName() + ".ALLOW_LOCAL_CHECKOUT";
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean ALLOW_LOCAL_CHECKOUT = SystemProperties.getBoolean((String)ALLOW_LOCAL_CHECKOUT_PROPERTY);
    private Long configVersion;
    private List<UserRemoteConfig> userRemoteConfigs;
    private transient List<RemoteConfig> remoteRepositories;
    private List<BranchSpec> branches;
    private boolean doGenerateSubmoduleConfigurations = false;
    @CheckForNull
    public String gitTool;
    @CheckForNull
    private GitRepositoryBrowser browser;
    private Collection<SubmoduleConfig> submoduleCfg = Collections.emptyList();
    public static final String GIT_BRANCH = "GIT_BRANCH";
    public static final String GIT_LOCAL_BRANCH = "GIT_LOCAL_BRANCH";
    public static final String GIT_CHECKOUT_DIR = "GIT_CHECKOUT_DIR";
    public static final String GIT_COMMIT = "GIT_COMMIT";
    public static final String GIT_PREVIOUS_COMMIT = "GIT_PREVIOUS_COMMIT";
    public static final String GIT_PREVIOUS_SUCCESSFUL_COMMIT = "GIT_PREVIOUS_SUCCESSFUL_COMMIT";
    public static final String GIT_URL = "GIT_URL";
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Known non-serializable field")
    private DescribableList<GitSCMExtension, GitSCMExtensionDescriptor> extensions;
    private static final String HOSTNAME_MATCH = "([\\w\\d[-.]]+)";
    private static final String REPOSITORY_PATH_MATCH = "/*(.+?)(?:[.]git)?/*";
    private static final Pattern[] URL_PATTERNS = new Pattern[]{Pattern.compile("(?:\\w+://)(?:.+@)?([\\w\\d[-.]]+)(?:[:][\\d]+)?//*(.+?)(?:[.]git)?/*"), Pattern.compile("(?:git@)([\\w\\d[-.]]+):/*(.+?)(?:[.]git)?/*")};
    public static final Pattern GIT_REF = Pattern.compile("^(refs/[^/]+)/(.+)");
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(GitSCM.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Not final so users can adjust log verbosity")
    public static boolean VERBOSE = Boolean.getBoolean(GitSCM.class.getName() + ".verbose");
    public static final int MAX_CHANGELOG = Integer.getInteger(GitSCM.class.getName() + ".maxChangelog", 1024);

    @Whitelisted
    @Deprecated
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Unread deprecated collection")
    public Collection<SubmoduleConfig> getSubmoduleCfg() {
        return this.submoduleCfg;
    }

    @DataBoundSetter
    public void setSubmoduleCfg(Collection<SubmoduleConfig> submoduleCfg) {
    }

    public static List<UserRemoteConfig> createRepoList(String url, String credentialsId) {
        ArrayList<UserRemoteConfig> repoList = new ArrayList<UserRemoteConfig>();
        repoList.add(new UserRemoteConfig(url, null, null, credentialsId));
        return repoList;
    }

    public GitSCM(String repositoryUrl) {
        this(GitSCM.createRepoList(repositoryUrl, null), Collections.singletonList(new BranchSpec("")), null, null, Collections.emptyList());
    }

    @Deprecated
    public GitSCM(List<UserRemoteConfig> userRemoteConfigs, List<BranchSpec> branches, Boolean doGenerateSubmoduleConfigurations, Collection<SubmoduleConfig> submoduleCfg, @CheckForNull GitRepositoryBrowser browser, @CheckForNull String gitTool, List<GitSCMExtension> extensions) {
        this(userRemoteConfigs, branches, browser, gitTool, extensions);
    }

    @DataBoundConstructor
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Modify access is assumed for userRemoteConfigs")
    public GitSCM(List<UserRemoteConfig> userRemoteConfigs, List<BranchSpec> branches, @CheckForNull GitRepositoryBrowser browser, @CheckForNull String gitTool, List<GitSCMExtension> extensions) {
        this.branches = CollectionUtils.isEmpty(branches) ? Lists.newArrayList((Object[])new BranchSpec[]{new BranchSpec("*/master")}) : branches;
        this.userRemoteConfigs = userRemoteConfigs;
        this.updateFromUserData();
        this.browser = browser;
        this.configVersion = 2L;
        this.gitTool = gitTool;
        this.extensions = new DescribableList(Saveable.NOOP, (Collection)Util.fixNull(extensions));
        this.getBuildChooser();
    }

    @Override
    @Whitelisted
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Low risk")
    public DescribableList<GitSCMExtension, GitSCMExtensionDescriptor> getExtensions() {
        return this.extensions;
    }

    private void updateFromUserData() throws GitException {
        if (this.userRemoteConfigs == null) {
            return;
        }
        try {
            String[] pUrls = new String[this.userRemoteConfigs.size()];
            String[] repoNames = new String[this.userRemoteConfigs.size()];
            String[] refSpecs = new String[this.userRemoteConfigs.size()];
            for (int i = 0; i < this.userRemoteConfigs.size(); ++i) {
                pUrls[i] = this.userRemoteConfigs.get(i).getUrl();
                repoNames[i] = this.userRemoteConfigs.get(i).getName();
                refSpecs[i] = this.userRemoteConfigs.get(i).getRefspec();
            }
            this.remoteRepositories = DescriptorImpl.createRepositoryConfigurations(pUrls, repoNames, refSpecs);
        }
        catch (IOException e1) {
            throw new GitException("Error creating repositories", (Throwable)e1);
        }
    }

    public Object readResolve() throws IOException {
        if (this.configVersion == null) {
            this.configVersion = 0L;
        }
        if (this.source != null) {
            this.remoteRepositories = new ArrayList<RemoteConfig>();
            this.branches = new ArrayList<BranchSpec>();
            Iterator<RemoteConfig> rs = new ArrayList();
            rs.add((RemoteConfig)new RefSpec("+refs/heads/*:refs/remotes/origin/*"));
            this.remoteRepositories.add(this.newRemoteConfig("origin", this.source, rs.toArray((RefSpec[])new RefSpec[0])));
            if (this.branch != null) {
                this.branches.add(new BranchSpec(this.branch));
            } else {
                this.branches.add(new BranchSpec("*/master"));
            }
        }
        if (this.configVersion < 1L && this.branches != null) {
            for (BranchSpec branchSpec : this.branches) {
                String name = branchSpec.getName();
                name = name.replace("*", "**");
                branchSpec.setName(name);
            }
        }
        if (this.remoteRepositories != null && this.userRemoteConfigs == null) {
            this.userRemoteConfigs = new ArrayList<UserRemoteConfig>();
            for (RemoteConfig cfg : this.remoteRepositories) {
                String url = "";
                if (cfg.getURIs().size() > 0 && cfg.getURIs().get(0) != null) {
                    url = ((URIish)cfg.getURIs().get(0)).toPrivateString();
                }
                String refspec = "";
                if (cfg.getFetchRefSpecs().size() > 0 && cfg.getFetchRefSpecs().get(0) != null) {
                    refspec = ((RefSpec)cfg.getFetchRefSpecs().get(0)).toString();
                }
                this.userRemoteConfigs.add(new UserRemoteConfig(url, cfg.getName(), refspec, null));
            }
        }
        if (this.remoteRepositories == null) {
            try {
                this.updateFromUserData();
            }
            catch (GitException e) {
                LOGGER.log(Level.WARNING, "Failed to load SCM data", e);
            }
        }
        if (this.extensions == null) {
            this.extensions = new DescribableList(Saveable.NOOP);
        }
        this.readBackExtensionsFromLegacy();
        if (this.choosingStrategy != null && this.getBuildChooser().getClass() == DefaultBuildChooser.class) {
            for (BuildChooserDescriptor d : BuildChooser.all()) {
                if (!this.choosingStrategy.equals(d.getLegacyId())) continue;
                try {
                    this.setBuildChooser((BuildChooser)d.clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate the build chooser", e);
                }
            }
        }
        this.getBuildChooser();
        return this;
    }

    @Whitelisted
    public GitRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public void setBrowser(GitRepositoryBrowser browser) {
        this.browser = browser;
    }

    public RepositoryBrowser<?> guessBrowser() {
        HashSet<String> webUrls = new HashSet<String>();
        if (this.remoteRepositories != null) {
            for (RemoteConfig config : this.remoteRepositories) {
                for (URIish uriIsh : config.getURIs()) {
                    String uri = uriIsh.toString();
                    for (Pattern p : URL_PATTERNS) {
                        Matcher m = p.matcher(uri);
                        if (!m.matches()) continue;
                        webUrls.add("https://" + m.group(1) + "/" + m.group(2) + "/");
                    }
                }
            }
        }
        if (webUrls.isEmpty()) {
            return null;
        }
        if (webUrls.size() == 1) {
            String url = (String)webUrls.iterator().next();
            if (url.startsWith("https://bitbucket.org/")) {
                return new BitbucketWeb(url);
            }
            if (url.startsWith("https://gitlab.com/")) {
                return new GitLab(url);
            }
            if (url.startsWith("https://github.com/")) {
                return new GithubWeb(url);
            }
            return null;
        }
        LOGGER.log(Level.INFO, "Multiple browser guess matches for {0}", this.remoteRepositories);
        return null;
    }

    public boolean isCreateAccountBasedOnEmail() {
        DescriptorImpl gitDescriptor = this.getDescriptor();
        return gitDescriptor != null && gitDescriptor.isCreateAccountBasedOnEmail();
    }

    public boolean isUseExistingAccountWithSameEmail() {
        DescriptorImpl gitDescriptor = this.getDescriptor();
        return gitDescriptor != null && gitDescriptor.isUseExistingAccountWithSameEmail();
    }

    public boolean isHideCredentials() {
        DescriptorImpl gitDescriptor = this.getDescriptor();
        return gitDescriptor != null && gitDescriptor.isHideCredentials();
    }

    public boolean isAllowSecondFetch() {
        DescriptorImpl gitDescriptor = this.getDescriptor();
        return gitDescriptor != null && gitDescriptor.isAllowSecondFetch();
    }

    public boolean isDisableGitToolChooser() {
        DescriptorImpl gitDescriptor = this.getDescriptor();
        return gitDescriptor != null && gitDescriptor.isDisableGitToolChooser();
    }

    public boolean isAddGitTagAction() {
        DescriptorImpl gitDescriptor = this.getDescriptor();
        return gitDescriptor != null && gitDescriptor.isAddGitTagAction();
    }

    @Whitelisted
    public BuildChooser getBuildChooser() {
        BuildChooserSetting bcs = (BuildChooserSetting)this.getExtensions().get(BuildChooserSetting.class);
        BuildChooser bc = bcs != null ? bcs.getBuildChooser() : new DefaultBuildChooser();
        bc.gitSCM = this;
        return bc;
    }

    public void setBuildChooser(BuildChooser buildChooser) throws IOException {
        if (buildChooser.getClass() == DefaultBuildChooser.class) {
            this.getExtensions().remove(BuildChooserSetting.class);
        } else {
            this.getExtensions().replace((Describable)new BuildChooserSetting(buildChooser));
        }
    }

    @Deprecated
    public String getParamLocalBranch(Run<?, ?> build) throws IOException, InterruptedException {
        return this.getParamLocalBranch(build, (TaskListener)new LogTaskListener(LOGGER, Level.INFO));
    }

    public String getParamLocalBranch(Run<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        LocalBranch localBranch = (LocalBranch)this.getExtensions().get(LocalBranch.class);
        return GitSCM.getParameterString(localBranch == null ? null : localBranch.getLocalBranch(), build.getEnvironment(listener));
    }

    @Deprecated
    public List<RemoteConfig> getParamExpandedRepos(Run<?, ?> build) throws IOException, InterruptedException {
        return this.getParamExpandedRepos(build, (TaskListener)new LogTaskListener(LOGGER, Level.INFO));
    }

    public List<RemoteConfig> getParamExpandedRepos(Run<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        ArrayList<RemoteConfig> expandedRepos = new ArrayList<RemoteConfig>();
        EnvVars env = build.getEnvironment(listener);
        for (RemoteConfig oldRepo : Util.fixNull(this.remoteRepositories)) {
            expandedRepos.add(this.getParamExpandedRepo(env, oldRepo));
        }
        return expandedRepos;
    }

    public RemoteConfig getParamExpandedRepo(EnvVars env, RemoteConfig remoteRepository) {
        List<RefSpec> refSpecs = this.getRefSpecs(remoteRepository, env);
        return this.newRemoteConfig(GitSCM.getParameterString(remoteRepository.getName(), env), GitSCM.getParameterString(((URIish)remoteRepository.getURIs().get(0)).toPrivateString(), env), refSpecs.toArray(new RefSpec[0]));
    }

    public RemoteConfig getRepositoryByName(String repoName) {
        for (RemoteConfig r : this.getRepositories()) {
            if (!r.getName().equals(repoName)) continue;
            return r;
        }
        return null;
    }

    @Exported
    @Whitelisted
    public List<UserRemoteConfig> getUserRemoteConfigs() {
        if (this.userRemoteConfigs == null) {
            this.userRemoteConfigs = new ArrayList<UserRemoteConfig>();
        }
        return Collections.unmodifiableList(this.userRemoteConfigs);
    }

    @Whitelisted
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Low risk")
    public List<RemoteConfig> getRepositories() {
        if (this.remoteRepositories == null) {
            return new ArrayList<RemoteConfig>();
        }
        return this.remoteRepositories;
    }

    public String deriveLocalBranchName(String remoteBranchName) {
        String remoteName = "origin";
        for (UserRemoteConfig remote : this.getUserRemoteConfigs()) {
            remoteName = remote.getName();
            if (remoteName == null || remoteName.isEmpty()) {
                remoteName = "origin";
            }
            if (!remoteBranchName.startsWith(remoteName + "/")) continue;
            break;
        }
        String localBranchName = remoteBranchName.replaceFirst("^" + remoteName + "/", "");
        return localBranchName;
    }

    @Whitelisted
    @CheckForNull
    public String getGitTool() {
        return this.gitTool;
    }

    @NonNull
    public static String getParameterString(@CheckForNull String original, @NonNull EnvVars env) {
        return env.expand(original);
    }

    private List<RefSpec> getRefSpecs(RemoteConfig repo, EnvVars env) {
        ArrayList<RefSpec> refSpecs = new ArrayList<RefSpec>();
        for (RefSpec refSpec : repo.getFetchRefSpecs()) {
            refSpecs.add(new RefSpec(GitSCM.getParameterString(refSpec.toString(), env)));
        }
        return refSpecs;
    }

    @CheckForNull
    private String getSingleBranch(EnvVars env) {
        if (this.getBranches().size() != 1) {
            return null;
        }
        String branch = this.getBranches().get(0).getName();
        String repository = null;
        if (this.getRepositories().size() != 1) {
            for (RemoteConfig repo : this.getRepositories()) {
                if (!branch.startsWith(repo.getName() + "/")) continue;
                repository = repo.getName();
                break;
            }
        } else {
            repository = this.getRepositories().get(0).getName();
        }
        if (branch.startsWith("*/") && repository != null) {
            branch = repository + branch.substring(1);
        }
        if (branch.contains("*")) {
            return null;
        }
        if ((branch = GitSCM.getParameterString(branch, env)).equals("")) {
            branch = "**";
        }
        return branch;
    }

    public SCMRevisionState calcRevisionsFromBuild(Run<?, ?> abstractBuild, FilePath workspace, Launcher launcher, TaskListener taskListener) throws IOException, InterruptedException {
        return SCMRevisionState.NONE;
    }

    public boolean requiresWorkspaceForPolling() {
        return this.requiresWorkspaceForPolling(new EnvVars());
    }

    boolean requiresWorkspaceForPolling(EnvVars environment) {
        for (GitSCMExtension ext : this.getExtensions()) {
            if (!ext.requiresWorkspaceForPolling()) continue;
            return true;
        }
        return this.getSingleBranch(environment) == null;
    }

    public PollingResult compareRemoteRevisionWith(Job<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        try {
            return this.compareRemoteRevisionWithImpl(project, launcher, workspace, listener);
        }
        catch (GitException e) {
            throw new IOException(e);
        }
    }

    private PollingResult compareRemoteRevisionWithImpl(Job<?, ?> project, Launcher launcher, FilePath workspace, @NonNull TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Using strategy: " + this.getBuildChooser().getDisplayName());
        Run lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            listener.getLogger().println("[poll] No previous build, so forcing an initial build.");
            return PollingResult.BUILD_NOW;
        }
        BuildData buildData = this.fixNull(this.getBuildData(lastBuild));
        if (buildData.lastBuild != null) {
            listener.getLogger().println("[poll] Last Built Revision: " + buildData.lastBuild.revision);
        }
        EnvVars pollEnv = project instanceof AbstractProject ? GitUtils.getPollEnvironment((AbstractProject)project, workspace, launcher, listener, false) : lastBuild.getEnvironment(listener);
        String singleBranch = this.getSingleBranch(pollEnv);
        if (!this.requiresWorkspaceForPolling(pollEnv)) {
            EnvVars environment = project instanceof AbstractProject ? GitUtils.getPollEnvironment((AbstractProject)project, workspace, launcher, listener, false) : new EnvVars();
            GitClient git = this.createClient(listener, environment, lastBuild, (Node)Jenkins.get(), null);
            for (RemoteConfig remoteConfig : this.getParamExpandedRepos(lastBuild, listener)) {
                String remote = remoteConfig.getName();
                List<RefSpec> refSpecs = this.getRefSpecs(remoteConfig, environment);
                for (URIish urIish : remoteConfig.getURIs()) {
                    String gitRepo = urIish.toString();
                    Map heads = git.getHeadRev(gitRepo);
                    if (heads == null || heads.isEmpty()) {
                        listener.getLogger().println("[poll] Couldn't get remote head revision");
                        return PollingResult.BUILD_NOW;
                    }
                    listener.getLogger().println("Found " + heads.size() + " remote heads on " + urIish);
                    Iterator it = heads.entrySet().iterator();
                    while (it.hasNext()) {
                        String head = (String)it.next().getKey();
                        boolean match = false;
                        for (RefSpec refSpec : refSpecs) {
                            if (!refSpec.matchSource(head)) continue;
                            match = true;
                            break;
                        }
                        if (match) continue;
                        listener.getLogger().println("Ignoring " + head + " as it doesn't match any of the configured refspecs");
                        it.remove();
                    }
                    for (BranchSpec branchSpec : this.getBranches()) {
                        for (Map.Entry entry : heads.entrySet()) {
                            Matcher matcher;
                            String name;
                            String head = (String)entry.getKey();
                            if (!branchSpec.matches(head, environment) && !branchSpec.matches(name = (matcher = GIT_REF.matcher(head)).matches() ? remote + head.substring(matcher.group(1).length()) : remote + "/" + head, environment)) continue;
                            ObjectId sha1 = (ObjectId)entry.getValue();
                            Build built = buildData.getLastBuild(sha1);
                            if (built != null) {
                                listener.getLogger().println("[poll] Latest remote head revision on " + head + " is: " + sha1.getName() + " - already built by " + built.getBuildNumber());
                                continue;
                            }
                            listener.getLogger().println("[poll] Latest remote head revision on " + head + " is: " + sha1.getName());
                            return PollingResult.BUILD_NOW;
                        }
                    }
                }
            }
            return PollingResult.NO_CHANGES;
        }
        Node node = GitUtils.workspaceToNode(workspace);
        EnvVars environment = project instanceof AbstractProject ? GitUtils.getPollEnvironment((AbstractProject)project, workspace, launcher, listener) : project.getEnvironment(node, listener);
        FilePath workingDirectory = this.workingDirectory(project, workspace, environment, listener);
        if (workingDirectory == null || !workingDirectory.exists()) {
            listener.getLogger().println("[poll] Working Directory does not exist");
            return PollingResult.BUILD_NOW;
        }
        GitClient git = this.createClient(listener, environment, lastBuild, node, workingDirectory);
        if (git.hasGitRepo(false)) {
            listener.getLogger().println("Fetching changes from the remote Git repositories");
            for (RemoteConfig remoteRepository : this.getParamExpandedRepos(lastBuild, listener)) {
                this.fetchFrom(git, null, listener, remoteRepository);
            }
            listener.getLogger().println("Polling for changes in");
            Collection<Revision> candidates = this.getBuildChooser().getCandidateRevisions(true, singleBranch, git, listener, buildData, (BuildChooserContext)new BuildChooserContextImpl(project, null, environment));
            for (Revision c : candidates) {
                if (this.isRevExcluded(git, c, listener, buildData)) continue;
                return PollingResult.SIGNIFICANT;
            }
            return PollingResult.NO_CHANGES;
        }
        listener.getLogger().println("No Git repository yet, an initial checkout is required");
        return PollingResult.SIGNIFICANT;
    }

    @NonNull
    public GitClient createClient(TaskListener listener, EnvVars environment, @NonNull Run<?, ?> build, FilePath workspace) throws IOException, InterruptedException {
        FilePath ws = this.workingDirectory(build.getParent(), workspace, environment, listener);
        if (ws != null) {
            ws.mkdirs();
        }
        return this.createClient(listener, environment, build, GitUtils.workspaceToNode(workspace), ws, null);
    }

    @NonNull
    public GitClient createClient(TaskListener listener, EnvVars environment, @NonNull Run<?, ?> build, FilePath workspace, UnsupportedCommand postBuildUnsupportedCommand) throws IOException, InterruptedException {
        FilePath ws = this.workingDirectory(build.getParent(), workspace, environment, listener);
        if (ws != null) {
            ws.mkdirs();
        }
        return this.createClient(listener, environment, build, GitUtils.workspaceToNode(workspace), ws, postBuildUnsupportedCommand);
    }

    @NonNull
    private GitClient createClient(TaskListener listener, EnvVars environment, @NonNull Run<?, ?> build, Node n, FilePath ws) throws IOException, InterruptedException {
        return this.createClient(listener, environment, build, n, ws, null);
    }

    @NonNull
    private GitClient createClient(TaskListener listener, EnvVars environment, @NonNull Run<?, ?> build, Node n, FilePath ws, UnsupportedCommand postBuildUnsupportedCommand) throws IOException, InterruptedException {
        String url;
        String ucCredentialsId;
        if (postBuildUnsupportedCommand == null) {
            postBuildUnsupportedCommand = new UnsupportedCommand();
        }
        String gitExe = this.getGitExe(n, listener);
        GitTool gitTool = this.getGitTool(n, null, listener);
        if (!this.isDisableGitToolChooser()) {
            UnsupportedCommand unsupportedCommand = new UnsupportedCommand();
            for (Object ext : this.extensions) {
                ((GitSCMExtension)((Object)ext)).determineSupportForJGit(this, unsupportedCommand);
            }
            GitToolChooser chooser = null;
            for (UserRemoteConfig uc : this.getUserRemoteConfigs()) {
                ucCredentialsId = uc.getCredentialsId();
                url = GitSCM.getParameterString(uc.getUrl(), environment);
                chooser = new GitToolChooser(url, (Item)build.getParent(), ucCredentialsId, gitTool, n, listener, unsupportedCommand.determineSupportForJGit() && postBuildUnsupportedCommand.determineSupportForJGit());
            }
            if (chooser != null) {
                listener.getLogger().println("The recommended git tool is: " + chooser.getGitTool());
                String updatedGitExe = chooser.getGitTool();
                if (!updatedGitExe.equals("NONE")) {
                    gitExe = updatedGitExe;
                }
            }
        }
        Git git = Git.with((TaskListener)listener, (EnvVars)environment).in(ws).using(gitExe);
        GitClient c = git.getClient();
        for (GitSCMExtension ext : this.extensions) {
            c = ext.decorate(this, c);
        }
        for (UserRemoteConfig uc : this.getUserRemoteConfigs()) {
            ucCredentialsId = uc.getCredentialsId();
            if (ucCredentialsId == null) {
                listener.getLogger().println("No credentials specified");
                continue;
            }
            url = GitSCM.getParameterString(uc.getUrl(), environment);
            StandardUsernameCredentials credentials = GitSCM.lookupScanCredentials(build, url, ucCredentialsId);
            if (credentials != null) {
                c.addCredentials(url, (StandardCredentials)credentials);
                if (!this.isHideCredentials()) {
                    listener.getLogger().printf("using credential %s%n", credentials.getId());
                }
                CredentialsProvider.track(build, (Credentials)credentials);
                continue;
            }
            if (this.isHideCredentials()) continue;
            listener.getLogger().printf("Warning: CredentialId \"%s\" could not be found.%n", ucCredentialsId);
        }
        return c;
    }

    private static StandardUsernameCredentials lookupScanCredentials(@NonNull Run<?, ?> build, @CheckForNull String url, @CheckForNull String ucCredentialsId) {
        if (Util.fixEmpty((String)ucCredentialsId) == null) {
            return null;
        }
        StandardUsernameCredentials c = (StandardUsernameCredentials)CredentialsProvider.findCredentialById((String)ucCredentialsId, StandardUsernameCredentials.class, build, (List)URIRequirementBuilder.fromUri((String)url).build());
        return c != null && GitClient.CREDENTIALS_MATCHER.matches((Credentials)c) ? c : null;
    }

    private static CredentialsMatcher gitScanCredentialsMatcher() {
        return CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)});
    }

    @NonNull
    private BuildData fixNull(BuildData bd) {
        ScmName sn = (ScmName)this.getExtensions().get(ScmName.class);
        String scmName = sn == null ? null : sn.getName();
        return bd != null ? bd : new BuildData(scmName, this.getUserRemoteConfigs());
    }

    private void fetchFrom(GitClient git, @CheckForNull Run<?, ?> run, TaskListener listener, RemoteConfig remoteRepository) throws InterruptedException, IOException {
        boolean first = true;
        for (URIish url : remoteRepository.getURIs()) {
            try {
                if (first) {
                    git.setRemoteUrl(remoteRepository.getName(), url.toPrivateASCIIString());
                    first = false;
                } else {
                    git.addRemoteUrl(remoteRepository.getName(), url.toPrivateASCIIString());
                }
                FetchCommand fetch = git.fetch_().from(url, remoteRepository.getFetchRefSpecs());
                for (GitSCMExtension extension : this.extensions) {
                    extension.decorateFetchCommand(this, run, git, listener, fetch);
                }
                fetch.execute();
            }
            catch (GitException ex) {
                throw new GitException("Failed to fetch from " + url.toString(), (Throwable)ex);
            }
        }
    }

    private RemoteConfig newRemoteConfig(String name, String refUrl, RefSpec ... refSpec) {
        try {
            Config repoConfig = new Config();
            repoConfig.setString("remote", name, "url", refUrl);
            ArrayList<String> str = new ArrayList<String>();
            if (refSpec != null && refSpec.length > 0) {
                for (RefSpec rs : refSpec) {
                    str.add(rs.toString());
                }
            }
            repoConfig.setStringList("remote", name, "fetch", str);
            return (RemoteConfig)RemoteConfig.getAllRemoteConfigs((Config)repoConfig).get(0);
        }
        catch (Exception ex) {
            throw new GitException("Error trying to create JGit configuration", (Throwable)ex);
        }
    }

    @CheckForNull
    public GitTool resolveGitTool(TaskListener listener) {
        return GitUtils.resolveGitTool(this.gitTool, listener);
    }

    public String getGitExe(Node builtOn, TaskListener listener) {
        return this.getGitExe(builtOn, null, listener);
    }

    public String getGitExe(Node builtOn, EnvVars env, TaskListener listener) {
        GitTool tool = GitUtils.resolveGitTool(this.gitTool, builtOn, env, listener);
        if (tool == null) {
            return null;
        }
        return tool.getGitExe();
    }

    public GitTool getGitTool(Node builtOn, EnvVars env, TaskListener listener) {
        GitTool tool = GitUtils.resolveGitTool(this.gitTool, builtOn, env, listener);
        return tool;
    }

    @NonNull
    private Build determineRevisionToBuild(Run build, @NonNull BuildData buildData, EnvVars environment, @NonNull GitClient git, @NonNull TaskListener listener) throws IOException, InterruptedException {
        Revision marked;
        RevisionParameterAction rpa;
        PrintStream log = listener.getLogger();
        Collection<Object> candidates = Collections.emptyList();
        BuildChooserContextImpl context = new BuildChooserContextImpl(build.getParent(), build, environment);
        this.getBuildChooser().prepareWorkingTree(git, listener, context);
        if (build.getClass().getName().equals("hudson.matrix.MatrixRun")) {
            candidates = GitSCMMatrixUtil.populateCandidatesFromRootBuild((AbstractBuild)build, this);
        }
        if (candidates.isEmpty() && (rpa = (RevisionParameterAction)build.getAction(RevisionParameterAction.class)) != null) {
            if (rpa.canOriginateFrom(this.getRepositories())) {
                candidates = Collections.singleton(rpa.toRevision(git));
            } else {
                log.println("skipping resolution of commit " + rpa.commit + ", since it originates from another repository");
            }
        }
        if (candidates.isEmpty()) {
            String singleBranch = environment.expand(this.getSingleBranch(environment));
            candidates = this.getBuildChooser().getCandidateRevisions(false, singleBranch, git, listener, buildData, (BuildChooserContext)context);
        }
        if (candidates.isEmpty()) {
            throw new AbortException("Couldn't find any revision to build. Verify the repository and branch configuration for this job.");
        }
        Revision rev = marked = (Revision)candidates.iterator().next();
        for (GitSCMExtension ext : this.extensions) {
            rev = ext.decorateRevisionToBuild(this, build, git, listener, marked, rev);
        }
        Build revToBuild = new Build(marked, rev, build.getNumber(), null);
        buildData.saveBuild(revToBuild);
        if (buildData.getBuildsByBranchName().size() >= 100) {
            log.println("JENKINS-19022: warning: possible memory leak due to Git plugin usage; see: https://plugins.jenkins.io/git/#remove-git-plugin-buildsbybranch-builddata-script");
        }
        boolean checkForMultipleRevisions = true;
        BuildSingleRevisionOnly ext = (BuildSingleRevisionOnly)this.extensions.get(BuildSingleRevisionOnly.class);
        if (ext != null) {
            checkForMultipleRevisions = ext.enableMultipleRevisionDetection();
        }
        if (candidates.size() > 1) {
            AbstractProject project;
            Job job;
            log.println("Multiple candidate revisions");
            if (checkForMultipleRevisions && (job = build.getParent()) instanceof AbstractProject && !(project = (AbstractProject)job).isDisabled()) {
                log.println("Scheduling another build to catch up with " + project.getFullDisplayName());
                if (!project.scheduleBuild(0, (Cause)new SCMTrigger.SCMTriggerCause("This build was triggered by build " + build.getNumber() + " because more than one build candidate was found."))) {
                    log.println("WARNING: multiple candidate revisions, but unable to schedule build of " + project.getFullDisplayName());
                }
            }
        }
        return revToBuild;
    }

    private void retrieveChanges(Run build, GitClient git, TaskListener listener) throws IOException, InterruptedException {
        PrintStream log = listener.getLogger();
        boolean removeSecondFetch = false;
        List<RemoteConfig> repos = this.getParamExpandedRepos(build, listener);
        if (repos.isEmpty()) {
            return;
        }
        if (git.hasGitRepo(false)) {
            if (repos.size() == 1) {
                log.println("Fetching changes from the remote Git repository");
            } else {
                log.println(MessageFormat.format("Fetching changes from {0} remote Git repositories", repos.size()));
            }
        } else {
            log.println("Cloning the remote Git repository");
            RemoteConfig rc = repos.get(0);
            try {
                CloneCommand cmd = git.clone_().url(((URIish)rc.getURIs().get(0)).toPrivateString()).repositoryName(rc.getName());
                for (GitSCMExtension ext : this.extensions) {
                    ext.decorateCloneCommand(this, build, git, listener, cmd);
                }
                cmd.execute();
                CloneOption option = (CloneOption)this.extensions.get(CloneOption.class);
                if (!this.isAllowSecondFetch()) {
                    removeSecondFetch = this.determineSecondFetch(option, rc);
                }
            }
            catch (GitException ex) {
                ex.printStackTrace(listener.error("Error cloning remote repo '" + rc.getName() + "'"));
                throw new AbortException("Error cloning remote repo '" + rc.getName() + "'");
            }
        }
        for (RemoteConfig remoteRepository : repos) {
            if (remoteRepository.equals(repos.get(0)) && removeSecondFetch) {
                log.println("Avoid second fetch");
                continue;
            }
            try {
                this.fetchFrom(git, build, listener, remoteRepository);
            }
            catch (GitException ex) {
                ex.printStackTrace(listener.error("Error fetching remote repo '" + remoteRepository.getName() + "'"));
                throw new AbortException("Error fetching remote repo '" + remoteRepository.getName() + "'");
            }
        }
    }

    private boolean determineSecondFetch(CloneOption option, @NonNull RemoteConfig rc) {
        List initialFetchRefSpecs = rc.getFetchRefSpecs();
        boolean isDefaultRefspec = true;
        boolean removeSecondFetch = true;
        if (initialFetchRefSpecs != null) {
            for (RefSpec ref : initialFetchRefSpecs) {
                if (ref.toString().contains("refs/heads")) continue;
                isDefaultRefspec = false;
            }
            removeSecondFetch = option == null ? isDefaultRefspec : (option.isHonorRefspec() ? true : isDefaultRefspec);
        }
        return removeSecondFetch;
    }

    public void checkout(Run<?, ?> build, Launcher launcher, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState baseline) throws IOException, InterruptedException {
        if (!ALLOW_LOCAL_CHECKOUT && !workspace.isRemote()) {
            this.abortIfSourceIsLocal();
        }
        if (VERBOSE) {
            listener.getLogger().println("Using checkout strategy: " + this.getBuildChooser().getDisplayName());
        }
        BuildData previousBuildData = this.getBuildData(build.getPreviousBuild());
        BuildData buildData = this.copyBuildData(build.getPreviousBuild());
        if (VERBOSE && buildData.lastBuild != null) {
            listener.getLogger().println("Last Built Revision: " + buildData.lastBuild.revision);
        }
        EnvVars environment = build.getEnvironment(listener);
        GitClient git = this.createClient(listener, environment, build, workspace);
        if (launcher instanceof Launcher.DecoratedLauncher) {
            listener.getLogger().println("Warning: JENKINS-30600: special launcher " + launcher + " will be ignored (a typical symptom is the Git executable not being run inside a designated container)");
        }
        for (GitSCMExtension ext : this.extensions) {
            ext.beforeCheckout(this, build, git, listener);
        }
        this.retrieveChanges(build, git, listener);
        Build revToBuild = this.determineRevisionToBuild(build, buildData, environment, git, listener);
        boolean buildDataAlreadyPresent = false;
        List actions = build.getActions(BuildData.class);
        for (BuildData d : actions) {
            if (!d.similarTo(buildData)) continue;
            buildDataAlreadyPresent = true;
            break;
        }
        if (!actions.isEmpty()) {
            buildData.setIndex(actions.size() + 1);
        }
        if (!buildDataAlreadyPresent) {
            build.addAction((Action)buildData);
        }
        environment.put(GIT_COMMIT, revToBuild.revision.getSha1String());
        Branch localBranch = (Branch)Iterables.getFirst((Iterable)revToBuild.revision.getBranches(), null);
        String localBranchName = this.getParamLocalBranch(build, listener);
        if (localBranch != null && localBranch.getName() != null) {
            String remoteBranchName = this.getBranchName(localBranch);
            environment.put(GIT_BRANCH, remoteBranchName);
            LocalBranch lb = (LocalBranch)this.getExtensions().get(LocalBranch.class);
            if (lb != null) {
                String lbn = lb.getLocalBranch();
                if (lbn == null || lbn.equals("**")) {
                    localBranchName = this.deriveLocalBranchName(remoteBranchName);
                }
                environment.put(GIT_LOCAL_BRANCH, localBranchName);
            }
        }
        listener.getLogger().println("Checking out " + revToBuild.revision);
        CheckoutCommand checkoutCommand = git.checkout().branch(localBranchName).ref(revToBuild.revision.getSha1String()).deleteBranchIfExist(true);
        for (GitSCMExtension ext : this.getExtensions()) {
            ext.decorateCheckoutCommand(this, build, git, listener, checkoutCommand);
        }
        try {
            checkoutCommand.execute();
        }
        catch (GitLockFailedException e) {
            throw new IOException("Could not checkout " + revToBuild.revision.getSha1String(), e);
        }
        try {
            this.printCommitMessageToLog(listener, git, revToBuild);
        }
        catch (GitException | IOException | ArithmeticException ge) {
            listener.getLogger().println("Exception logging commit message for " + revToBuild + ": " + ge.getMessage());
        }
        if (!buildDataAlreadyPresent) {
            if (build.getActions(AbstractScmTagAction.class).isEmpty() && this.isAddGitTagAction()) {
                LOGGER.log(Level.FINE, "Adding GitTagAction to build " + build.number);
                build.addAction((Action)new GitTagAction(build, workspace, revToBuild.revision));
            } else {
                LOGGER.log(Level.FINE, "Not adding GitTagAction to build " + build.number);
            }
            if (changelogFile != null) {
                this.computeChangeLog(git, revToBuild.revision, listener, previousBuildData, new FilePath(changelogFile), new BuildChooserContextImpl(build.getParent(), build, environment));
            }
        }
        for (GitSCMExtension ext : this.extensions) {
            ext.onCheckoutCompleted(this, build, git, listener);
        }
    }

    private void abortIfSourceIsLocal() throws AbortException {
        for (UserRemoteConfig userRemoteConfig : this.getUserRemoteConfigs()) {
            String remoteUrl = userRemoteConfig.getUrl();
            if (remoteUrl == null || !remoteUrl.toLowerCase(Locale.ENGLISH).startsWith("file://") && !Files.exists(Paths.get(remoteUrl, new String[0]), new LinkOption[0])) continue;
            throw new AbortException("Checkout of Git remote '" + remoteUrl + "' aborted because it references a local directory, which may be insecure. You can allow local checkouts anyway by setting the system property '" + ALLOW_LOCAL_CHECKOUT_PROPERTY + "' to true.");
        }
    }

    private void printCommitMessageToLog(TaskListener listener, GitClient git, Build revToBuild) throws IOException {
        try {
            RevCommit commit = (RevCommit)git.withRepository((RepositoryCallback)new RevCommitRepositoryCallback(revToBuild));
            listener.getLogger().println("Commit message: \"" + commit.getShortMessage() + "\"");
        }
        catch (InterruptedException | MissingObjectException e) {
            e.printStackTrace(listener.error("Unable to retrieve commit message"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeChangeLog(GitClient git, Revision revToBuild, TaskListener listener, BuildData previousBuildData, FilePath changelogFile, BuildChooserContext context) throws IOException, InterruptedException {
        boolean executed = false;
        ChangelogCommand changelog = git.changelog();
        changelog.includes(revToBuild.getSha1());
        try (OutputStreamWriter out = new OutputStreamWriter(changelogFile.write(), "UTF-8");){
            boolean exclusion = false;
            ChangelogToBranch changelogToBranch = (ChangelogToBranch)this.getExtensions().get(ChangelogToBranch.class);
            if (changelogToBranch != null) {
                listener.getLogger().println("Using 'Changelog to branch' strategy.");
                changelog.excludes(changelogToBranch.getOptions().getRef());
                exclusion = true;
            } else {
                for (Branch b : revToBuild.getBranches()) {
                    Build lastRevWas = this.getBuildChooser().prevBuildForChangelog(b.getName(), previousBuildData, git, context);
                    if (lastRevWas == null || lastRevWas.revision == null || !git.isCommitInRepo(lastRevWas.getSHA1())) continue;
                    changelog.excludes(lastRevWas.getSHA1());
                    exclusion = true;
                }
            }
            if (!exclusion) {
                listener.getLogger().println("First time build. Skipping changelog.");
            } else {
                changelog.to((Writer)out).max(MAX_CHANGELOG).execute();
                executed = true;
            }
        }
        catch (GitException ge) {
            ge.printStackTrace(listener.error("Unable to retrieve changeset"));
        }
        finally {
            if (!executed) {
                changelog.abort();
            }
        }
    }

    @Deprecated
    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        this.buildEnvironment((Run<?, ?>)build, env);
    }

    public void buildEnvironment(Run<?, ?> build, Map<String, String> env) {
        Revision rev = this.fixNull(this.getBuildData(build)).getLastBuiltRevision();
        if (rev != null) {
            Object sha1;
            Branch branch = (Branch)Iterables.getFirst((Iterable)rev.getBranches(), null);
            if (branch != null && branch.getName() != null) {
                String prevSuccessfulCommit;
                String prevCommit;
                RelativeTargetDirectory rtd;
                String remoteBranchName = this.getBranchName(branch);
                env.put(GIT_BRANCH, remoteBranchName);
                LocalBranch localBranch = (LocalBranch)this.getExtensions().get(LocalBranch.class);
                if (localBranch != null) {
                    String localBranchName = localBranch.getLocalBranch();
                    if (localBranchName == null || localBranchName.equals("**")) {
                        localBranchName = this.deriveLocalBranchName(remoteBranchName);
                    }
                    env.put(GIT_LOCAL_BRANCH, localBranchName);
                }
                if ((rtd = (RelativeTargetDirectory)this.getExtensions().get(RelativeTargetDirectory.class)) != null) {
                    String localRelativeTargetDir = rtd.getRelativeTargetDir();
                    if (localRelativeTargetDir == null) {
                        localRelativeTargetDir = "";
                    }
                    env.put(GIT_CHECKOUT_DIR, localRelativeTargetDir);
                }
                if ((prevCommit = this.getLastBuiltCommitOfBranch(build, branch)) != null) {
                    env.put(GIT_PREVIOUS_COMMIT, prevCommit);
                }
                if ((prevSuccessfulCommit = this.getLastSuccessfulBuiltCommitOfBranch(build, branch)) != null) {
                    env.put(GIT_PREVIOUS_SUCCESSFUL_COMMIT, prevSuccessfulCommit);
                }
            }
            if ((sha1 = Util.fixEmpty((String)rev.getSha1String())) != null && !((String)sha1).isEmpty()) {
                env.put(GIT_COMMIT, (String)sha1);
            }
        }
        int repoCount = 1;
        for (UserRemoteConfig userRemoteConfig : this.userRemoteConfigs) {
            if (userRemoteConfig.getUrl() == null) {
                throw new IllegalArgumentException("Git repository URL " + repoCount + " is an empty string in job definition. Checkout requires a valid repository URL");
            }
            ++repoCount;
        }
        if (this.userRemoteConfigs.size() > 0) {
            env.put(GIT_URL, this.userRemoteConfigs.get(0).getUrl());
        }
        if (this.userRemoteConfigs.size() > 1) {
            int count = 1;
            for (UserRemoteConfig config : this.userRemoteConfigs) {
                env.put("GIT_URL_" + count, config.getUrl());
                ++count;
            }
        }
        this.getDescriptor().populateEnvironmentVariables(env);
        for (GitSCMExtension gitSCMExtension : this.extensions) {
            gitSCMExtension.populateEnvironmentVariables(this, env);
        }
    }

    private String getBranchName(Branch branch) {
        String name = branch.getName();
        if (name.startsWith("refs/remotes/")) {
            name = name.substring("refs/remotes/".length());
        }
        return name;
    }

    private String getLastBuiltCommitOfBranch(Run<?, ?> build, Branch branch) {
        Revision previousRev;
        Build lastBuildOfBranch;
        String prevCommit = null;
        if (build.getPreviousBuiltBuild() != null && (lastBuildOfBranch = this.fixNull(this.getBuildData(build.getPreviousBuiltBuild())).getLastBuildOfBranch(branch.getName())) != null && (previousRev = lastBuildOfBranch.getRevision()) != null) {
            prevCommit = previousRev.getSha1String();
        }
        return prevCommit;
    }

    private String getLastSuccessfulBuiltCommitOfBranch(Run<?, ?> build, Branch branch) {
        Revision previousRev;
        Build lastSuccessfulBuildOfBranch;
        String prevCommit = null;
        if (build.getPreviousSuccessfulBuild() != null && (lastSuccessfulBuildOfBranch = this.fixNull(this.getBuildData(build.getPreviousSuccessfulBuild())).getLastBuildOfBranch(branch.getName())) != null && (previousRev = lastSuccessfulBuildOfBranch.getRevision()) != null) {
            prevCommit = previousRev.getSha1String();
        }
        return prevCommit;
    }

    public ChangeLogParser createChangeLogParser() {
        try {
            GitClient gitClient = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).in(new File(".")).using(this.gitTool).getClient();
            return new GitChangeLogParser(gitClient, this.getExtensions().get(AuthorInChangelog.class) != null);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.WARNING, "Git client using '" + this.gitTool + "' changelog parser failed, using deprecated changelog parser", e);
            return new GitChangeLogParser(null, this.getExtensions().get(AuthorInChangelog.class) != null);
        }
    }

    @Whitelisted
    @Deprecated
    public boolean isDoGenerateSubmoduleConfigurations() {
        return false;
    }

    @Exported
    @Whitelisted
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Low risk")
    public List<BranchSpec> getBranches() {
        return this.branches;
    }

    public String getKey() {
        ScmName scmName = (ScmName)this.getExtensions().get(ScmName.class);
        if (scmName != null) {
            return scmName.getName();
        }
        StringBuilder b = new StringBuilder("git");
        for (RemoteConfig cfg : this.getRepositories()) {
            for (URIish uri : cfg.getURIs()) {
                b.append(' ').append(uri.toString());
            }
        }
        return b.toString();
    }

    @Exported
    @Deprecated
    public PreBuildMergeOptions getMergeOptions() throws Descriptor.FormException {
        return DescriptorImpl.createMergeOptions(this.getUserMergeOptions(), this.remoteRepositories);
    }

    private boolean isRelevantBuildData(BuildData bd) {
        for (UserRemoteConfig c : this.getUserRemoteConfigs()) {
            if (!bd.hasBeenReferenced(c.getUrl())) continue;
            return true;
        }
        return false;
    }

    public BuildData getBuildData(Run build, boolean clone) {
        return clone ? this.copyBuildData(build) : this.getBuildData(build);
    }

    public BuildData copyBuildData(Run build) {
        String scmName;
        BuildData base = this.getBuildData(build);
        ScmName sn = (ScmName)this.getExtensions().get(ScmName.class);
        String string = scmName = sn == null ? null : sn.getName();
        if (base == null) {
            return new BuildData(scmName, this.getUserRemoteConfigs());
        }
        BuildData buildData = base.clone();
        buildData.setScmName(scmName);
        return buildData;
    }

    @CheckForNull
    public BuildData getBuildData(Run build) {
        BuildData buildData = null;
        while (build != null) {
            List buildDataList = build.getActions(BuildData.class);
            List buildDataListReverted = this.reversedView(buildDataList);
            for (BuildData bd : buildDataListReverted) {
                if (bd == null || !this.isRelevantBuildData(bd)) continue;
                buildData = bd;
                break;
            }
            if (buildData != null) break;
            build = build.getPreviousBuild();
        }
        return buildData;
    }

    private <T> List<T> reversedView(final List<T> list) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return list.get(list.size() - 1 - index);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    protected FilePath workingDirectory(Job<?, ?> context, FilePath workspace, EnvVars environment, TaskListener listener) throws IOException, InterruptedException {
        if (workspace == null) {
            return null;
        }
        for (GitSCMExtension ext : this.extensions) {
            FilePath r = ext.getWorkingDirectory(this, context, workspace, environment, listener);
            if (r == null) continue;
            return r;
        }
        return workspace;
    }

    private boolean isRevExcluded(GitClient git, Revision r, TaskListener listener, BuildData buildData) throws IOException, InterruptedException {
        try {
            List revShow = buildData != null && buildData.lastBuild != null ? (this.getExtensions().get(PathRestriction.class) != null ? git.showRevision(buildData.lastBuild.revision.getSha1(), r.getSha1()) : git.showRevision(buildData.lastBuild.revision.getSha1(), r.getSha1(), Boolean.valueOf(false))) : git.showRevision(r.getSha1());
            revShow.add("commit ");
            int start = 0;
            int idx = 0;
            for (String line : revShow) {
                if (line.startsWith("commit ") && idx != 0) {
                    GitSCMExtension ext;
                    boolean showEntireCommitSummary = GitChangeSet.isShowEntireCommitSummaryInChanges() || !(git instanceof CliGitAPIImpl);
                    GitChangeSet change = new GitChangeSet(revShow.subList(start, idx), this.getExtensions().get(AuthorInChangelog.class) != null, showEntireCommitSummary);
                    Boolean excludeThisCommit = null;
                    Iterator iterator = this.extensions.iterator();
                    while (iterator.hasNext() && (excludeThisCommit = (ext = (GitSCMExtension)((Object)iterator.next())).isRevExcluded(this, git, change, listener, buildData)) == null) {
                    }
                    if (excludeThisCommit == null || !excludeThisCommit.booleanValue()) {
                        return false;
                    }
                    start = idx;
                }
                ++idx;
            }
            assert (start == revShow.size() - 1);
            return true;
        }
        catch (GitException e) {
            e.printStackTrace(listener.error("Failed to determine if we want to exclude " + r.getSha1String()));
            return false;
        }
    }

    @DataBoundSetter
    public void setDoGenerateSubmoduleConfigurations(boolean ignoredValue) {
    }

    @Deprecated
    public boolean getDoGenerateSubmoduleConfigurations() {
        return this.doGenerateSubmoduleConfigurations;
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void onLoaded() {
        Jenkins jenkins = Jenkins.get();
        DescriptorImpl desc = (DescriptorImpl)jenkins.getDescriptorByType(DescriptorImpl.class);
        if (desc.getOldGitExe() != null) {
            String defaultGit;
            String exe = desc.getOldGitExe();
            if (exe.equals(defaultGit = GitTool.getDefaultInstallation().getGitExe())) {
                return;
            }
            System.err.println("[WARNING] you're using deprecated gitexe attribute to configure git plugin. Use Git installations");
        }
    }

    @Initializer(before=InitMilestone.JOB_LOADED)
    public static void configureXtream() {
        Run.XSTREAM.registerConverter((Converter)new ObjectIdConverter());
        Items.XSTREAM.registerConverter((Converter)new RemoteConfigConverter(Items.XSTREAM));
        Items.XSTREAM.alias("org.spearce.jgit.transport.RemoteConfig", RemoteConfig.class);
    }

    @Extension
    public static final class DescriptorImpl
    extends SCMDescriptor<GitSCM> {
        private String gitExe;
        private String globalConfigName;
        private String globalConfigEmail;
        private boolean createAccountBasedOnEmail;
        private boolean useExistingAccountWithSameEmail;
        private boolean showEntireCommitSummaryInChanges;
        private boolean hideCredentials;
        private boolean allowSecondFetch;
        private boolean disableGitToolChooser;
        private boolean addGitTagAction;

        public DescriptorImpl() {
            super(GitSCM.class, GitRepositoryBrowser.class);
            this.load();
        }

        @NonNull
        public Permission getRequiredGlobalConfigPagePermission() {
            return Jenkins.MANAGE;
        }

        Permission getJenkinsManageOrAdmin() {
            return Jenkins.MANAGE;
        }

        public boolean isShowEntireCommitSummaryInChanges() {
            return this.showEntireCommitSummaryInChanges;
        }

        public boolean isHideCredentials() {
            return this.hideCredentials;
        }

        public void setHideCredentials(boolean hideCredentials) {
            this.hideCredentials = hideCredentials;
        }

        public void setShowEntireCommitSummaryInChanges(boolean showEntireCommitSummaryInChanges) {
            this.showEntireCommitSummaryInChanges = showEntireCommitSummaryInChanges;
        }

        public String getDisplayName() {
            return "Git";
        }

        public boolean isApplicable(Job project) {
            return true;
        }

        public List<GitSCMExtensionDescriptor> getExtensionDescriptors() {
            return GitSCMExtensionDescriptor.all();
        }

        public boolean showGitToolOptions() {
            return ((GitTool[])((GitTool.DescriptorImpl)Jenkins.get().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallations()).length > 1;
        }

        public List<GitTool> getGitTools() {
            GitTool[] gitToolInstallations = (GitTool[])((GitTool.DescriptorImpl)Jenkins.get().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallations();
            return Arrays.asList(gitToolInstallations);
        }

        public ListBoxModel doFillGitToolItems() {
            ListBoxModel r = new ListBoxModel();
            for (GitTool git : this.getGitTools()) {
                r.add(git.getName());
            }
            return r;
        }

        @Deprecated
        public String getGitExe() {
            return this.gitExe;
        }

        public String getGlobalConfigName() {
            return Util.fixEmptyAndTrim((String)this.globalConfigName);
        }

        public void setGlobalConfigName(String globalConfigName) {
            this.globalConfigName = globalConfigName;
        }

        public String getGlobalConfigEmail() {
            return Util.fixEmptyAndTrim((String)this.globalConfigEmail);
        }

        public void setGlobalConfigEmail(String globalConfigEmail) {
            this.globalConfigEmail = globalConfigEmail;
        }

        public boolean isCreateAccountBasedOnEmail() {
            return this.createAccountBasedOnEmail;
        }

        public void setCreateAccountBasedOnEmail(boolean createAccountBasedOnEmail) {
            this.createAccountBasedOnEmail = createAccountBasedOnEmail;
        }

        public boolean isUseExistingAccountWithSameEmail() {
            return this.useExistingAccountWithSameEmail;
        }

        public void setUseExistingAccountWithSameEmail(boolean useExistingAccountWithSameEmail) {
            this.useExistingAccountWithSameEmail = useExistingAccountWithSameEmail;
        }

        public boolean isAllowSecondFetch() {
            return this.allowSecondFetch;
        }

        public void setAllowSecondFetch(boolean allowSecondFetch) {
            this.allowSecondFetch = allowSecondFetch;
        }

        public boolean isDisableGitToolChooser() {
            return this.disableGitToolChooser;
        }

        public void setDisableGitToolChooser(boolean disableGitToolChooser) {
            this.disableGitToolChooser = disableGitToolChooser;
        }

        public boolean isAddGitTagAction() {
            return this.addGitTagAction;
        }

        public void setAddGitTagAction(boolean addGitTagAction) {
            this.addGitTagAction = addGitTagAction;
        }

        public String getOldGitExe() {
            return this.gitExe;
        }

        public static List<RemoteConfig> createRepositoryConfigurations(String[] urls, String[] repoNames, String[] refs) throws IOException {
            List remoteRepositories;
            Config repoConfig = new Config();
            String[] names = repoNames;
            names = GitUtils.fixupNames(names, urls);
            for (int i = 0; i < names.length; ++i) {
                String url = urls[i];
                if (url == null) continue;
                String name = names[i];
                name = name.replace(' ', '_');
                if (StringUtils.isBlank((String)refs[i])) {
                    refs[i] = "+refs/heads/*:refs/remotes/" + name + "/*";
                }
                repoConfig.setString("remote", name, "url", url);
                repoConfig.setStringList("remote", name, "fetch", new ArrayList<String>(Arrays.asList(refs[i].split("\\s+"))));
            }
            try {
                remoteRepositories = RemoteConfig.getAllRemoteConfigs((Config)repoConfig);
            }
            catch (Exception e) {
                throw new GitException("Error creating repositories", (Throwable)e);
            }
            return remoteRepositories;
        }

        public static PreBuildMergeOptions createMergeOptions(UserMergeOptions mergeOptionsBean, List<RemoteConfig> remoteRepositories) throws Descriptor.FormException {
            PreBuildMergeOptions mergeOptions = new PreBuildMergeOptions();
            if (mergeOptionsBean != null) {
                RemoteConfig mergeRemote = null;
                String mergeRemoteName = mergeOptionsBean.getMergeRemote().trim();
                if (mergeRemoteName.length() == 0) {
                    mergeRemote = remoteRepositories.get(0);
                } else {
                    for (RemoteConfig remote : remoteRepositories) {
                        if (!remote.getName().equals(mergeRemoteName)) continue;
                        mergeRemote = remote;
                        break;
                    }
                }
                if (mergeRemote == null) {
                    throw new Descriptor.FormException("No remote repository configured with name '" + mergeRemoteName + "'", "git.mergeRemote");
                }
                mergeOptions.setMergeRemote(mergeRemote);
                mergeOptions.setMergeTarget(mergeOptionsBean.getMergeTarget());
                mergeOptions.setMergeStrategy(mergeOptionsBean.getMergeStrategy());
                mergeOptions.setFastForwardMode(mergeOptionsBean.getFastForwardMode());
            }
            return mergeOptions;
        }

        public FormValidation doGitRemoteNameCheck(StaplerRequest req) throws IOException, ServletException {
            boolean isMerge;
            String mergeRemoteName = req.getParameter("value");
            boolean bl = isMerge = req.getParameter("isMerge") != null;
            if (mergeRemoteName.length() == 0 && isMerge) {
                return FormValidation.ok();
            }
            String[] urls = req.getParameterValues("repo.url");
            String[] names = req.getParameterValues("repo.name");
            if (urls != null && names != null) {
                for (String name : GitUtils.fixupNames(names, urls)) {
                    if (!name.equals(mergeRemoteName)) continue;
                    return FormValidation.ok();
                }
            }
            return FormValidation.error((String)("No remote repository configured with name '" + mergeRemoteName + "'"));
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }

        public void populateEnvironmentVariables(Map<String, String> env) {
            String email;
            String name = this.getGlobalConfigName();
            if (name != null) {
                env.put("GIT_COMMITTER_NAME", name);
                env.put("GIT_AUTHOR_NAME", name);
            }
            if ((email = this.getGlobalConfigEmail()) != null) {
                env.put("GIT_COMMITTER_EMAIL", email);
                env.put("GIT_AUTHOR_EMAIL", email);
            }
        }
    }

    static class BuildChooserContextImpl
    implements BuildChooserContext,
    Serializable {
        @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="known non-serializable field")
        final Job project;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="known non-serializable field")
        final Run build;
        final EnvVars environment;

        BuildChooserContextImpl(Job project, Run build, EnvVars environment) {
            this.project = project;
            this.build = build;
            this.environment = environment;
        }

        @Override
        public <T> T actOnBuild(@NonNull BuildChooserContext.ContextCallable<Run<?, ?>, T> callable) throws IOException, InterruptedException {
            return callable.invoke(this.build, (VirtualChannel)FilePath.localChannel);
        }

        @Override
        public <T> T actOnProject(@NonNull BuildChooserContext.ContextCallable<Job<?, ?>, T> callable) throws IOException, InterruptedException {
            return callable.invoke(this.project, (VirtualChannel)FilePath.localChannel);
        }

        @Override
        public Run<?, ?> getBuild() {
            return this.build;
        }

        @Override
        public EnvVars getEnvironment() {
            return this.environment;
        }

        private Object writeReplace() {
            Channel currentChannel = Channel.current();
            if (currentChannel == null) {
                return null;
            }
            return currentChannel.export(BuildChooserContext.class, (Object)new BuildChooserContext(){

                @Override
                public <T> T actOnBuild(@NonNull BuildChooserContext.ContextCallable<Run<?, ?>, T> callable) throws IOException, InterruptedException {
                    return callable.invoke(build, (VirtualChannel)Channel.current());
                }

                @Override
                public <T> T actOnProject(@NonNull BuildChooserContext.ContextCallable<Job<?, ?>, T> callable) throws IOException, InterruptedException {
                    return callable.invoke(project, (VirtualChannel)Channel.current());
                }

                @Override
                public Run<?, ?> getBuild() {
                    return build;
                }

                @Override
                public EnvVars getEnvironment() {
                    return environment;
                }
            });
        }
    }
}

