/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.Messages;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.GitURIRequirementsBuilder;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
public class UserRemoteConfig
extends AbstractDescribableImpl<UserRemoteConfig>
implements Serializable {
    private String name;
    private String refspec;
    private String url;
    private String credentialsId;
    private static final Pattern SCP_LIKE = Pattern.compile("(.*):(.*)");

    @DataBoundConstructor
    public UserRemoteConfig(String url, String name, String refspec, @CheckForNull String credentialsId) {
        this.url = Util.fixEmptyAndTrim((String)url);
        this.name = Util.fixEmpty((String)name);
        this.refspec = Util.fixEmpty((String)refspec);
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @Exported
    public String getRefspec() {
        return this.refspec;
    }

    @Exported
    @CheckForNull
    public String getUrl() {
        return this.url;
    }

    @Exported
    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String toString() {
        return this.getRefspec() + " => " + this.getUrl() + " (" + this.getName() + ")";
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<UserRemoteConfig> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String url, @QueryParameter String credentialsId) {
            if (project == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || project != null && !project.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            if (project == null) {
                project = new FreeStyleProject(Jenkins.get(), "fake-" + UUID.randomUUID().toString());
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM, project, StandardUsernameCredentials.class, GitURIRequirementsBuilder.fromUri((String)url).build(), GitClient.CREDENTIALS_MATCHER).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item project, @QueryParameter String url, @QueryParameter String value) {
            if (project == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || project != null && !project.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if ((value = Util.fixEmptyAndTrim((String)value)) == null) {
                return FormValidation.ok();
            }
            if ((url = Util.fixEmptyAndTrim((String)url)) == null) {
                return FormValidation.ok();
            }
            if (url.indexOf(36) >= 0) {
                return FormValidation.ok();
            }
            for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernameCredentials.class, (Item)project, (Authentication)(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM), (List)GitURIRequirementsBuilder.fromUri((String)url).build(), (CredentialsMatcher)GitClient.CREDENTIALS_MATCHER)) {
                if (!StringUtils.equals((String)value, (String)o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Cannot find any credentials with id " + value));
        }

        @RequirePOST
        public FormValidation doCheckUrl(@AncestorInPath Item item, @QueryParameter String credentialsId, @QueryParameter String value) throws IOException, InterruptedException {
            Computer computer;
            if (item == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || item != null && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            String url = Util.fixEmptyAndTrim((String)value);
            if (url == null) {
                return FormValidation.error((String)Messages.UserRemoteConfig_CheckUrl_UrlIsNull());
            }
            if (url.indexOf(36) >= 0) {
                return FormValidation.ok();
            }
            Jenkins jenkins = Jenkins.get();
            EnvVars environment = item instanceof Job ? ((Job)item).getEnvironment((Node)jenkins, TaskListener.NULL) : ((computer = jenkins.toComputer()) == null ? new EnvVars() : computer.buildEnvironment(TaskListener.NULL));
            GitClient git = Git.with((TaskListener)TaskListener.NULL, (EnvVars)environment).using(GitTool.getDefaultInstallation().getGitExe()).getClient();
            StandardCredentials credential = DescriptorImpl.lookupCredentials(item, credentialsId, url);
            git.addDefaultCredentials(credential);
            try {
                git.getHeadRev(url, "HEAD");
            }
            catch (GitException e) {
                return FormValidation.error((String)Messages.UserRemoteConfig_FailedToConnect(e.getMessage()));
            }
            return FormValidation.ok();
        }

        private static StandardCredentials lookupCredentials(@CheckForNull Item project, String credentialId, String uri) {
            return credentialId == null ? null : (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, (List)GitURIRequirementsBuilder.fromUri((String)uri).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
        }

        public String getDisplayName() {
            return "";
        }
    }
}

