/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class Gitiles
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public Gitiles(String repoUrl) {
        super(repoUrl);
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        URL url = this.getUrl();
        return new URL(url + "+/" + path.getChangeSet().getId() + "%5E%21");
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        URL url = this.getUrl();
        return Gitiles.encodeURL(new URL(url + "+blame/" + path.getChangeSet().getId() + "/" + path.getPath()));
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url + "+/" + changeSet.getId() + "%5E%21");
    }

    @Extension
    public static class ViewGitWebDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @Nonnull
        public String getDisplayName() {
            return "gitiles";
        }

        public Gitiles newInstance(StaplerRequest req, @Nonnull JSONObject jsonObject) throws Descriptor.FormException {
            assert (req != null);
            return (Gitiles)((Object)req.bindJSON(Gitiles.class, jsonObject));
        }

        @RequirePOST
        public FormValidation doCheckUrl(final @QueryParameter(fixEmpty=true) String url) throws IOException, ServletException {
            if (url == null) {
                return FormValidation.ok();
            }
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    String v = url;
                    if (!v.endsWith("/")) {
                        v = v + '/';
                    }
                    try {
                        if (this.findText(this.open(new URL(v)), "git clone")) {
                            return FormValidation.ok();
                        }
                        return FormValidation.error((String)"This is a valid URL but it doesn't look like Gitiles");
                    }
                    catch (IOException e) {
                        return this.handleIOException(v, e);
                    }
                }
            }.check();
        }
    }
}

