/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class CGit
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public CGit(String repoUrl) {
        super(repoUrl);
    }

    private QueryBuilder param(URL url) {
        return new QueryBuilder(url.getQuery());
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, url.getPath() + "commit/" + this.param(url).add("id=" + changeSet.getId()).toString());
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        URL url = this.getUrl();
        return new URL(url, url.getPath() + "diff/" + path.getPath() + this.param(url).add("id=" + changeSet.getId()).toString());
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        URL url = this.getUrl();
        if (path.getEditType() == EditType.DELETE) {
            return CGit.encodeURL(new URL(url, url.getPath() + "tree/" + path.getPath() + this.param(url).add("id=" + changeSet.getParentCommit()).toString()));
        }
        return CGit.encodeURL(new URL(url, url.getPath() + "tree/" + path.getPath() + this.param(url).add("id=" + changeSet.getId()).toString()));
    }

    @Extension
    public static class CGITDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @Nonnull
        public String getDisplayName() {
            return "cgit";
        }

        public CGit newInstance(StaplerRequest req, @Nonnull JSONObject jsonObject) throws Descriptor.FormException {
            assert (req != null);
            return (CGit)((Object)req.bindJSON(CGit.class, jsonObject));
        }
    }
}

