/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Messages;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.CommitTimeComparator;
import hudson.plugins.git.util.GitUtils;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;
import org.kohsuke.stapler.DataBoundConstructor;

public class DefaultBuildChooser
extends BuildChooser {
    private static final BranchSpec HEAD = new BranchSpec("*/HEAD");

    @DataBoundConstructor
    public DefaultBuildChooser() {
    }

    @Override
    public Collection<Revision> getCandidateRevisions(boolean isPollCall, String branchSpec, GitClient git, TaskListener listener, BuildData data, BuildChooserContext context) throws GitException, IOException, InterruptedException {
        this.verbose(listener, "getCandidateRevisions({0},{1},,,{2}) considering branches to build", isPollCall, branchSpec, data);
        if (this.isAdvancedSpec(branchSpec)) {
            return this.getAdvancedCandidateRevisions(isPollCall, listener, new GitUtils(listener, git), data, context);
        }
        if (!isPollCall && branchSpec.matches("[0-9a-f]{6,40}")) {
            try {
                ObjectId sha1 = git.revParse(branchSpec);
                Revision revision = new Revision(sha1);
                revision.getBranches().add(new Branch("detached", sha1));
                this.verbose(listener, "Will build the detached SHA1 {0}", sha1);
                return Collections.singletonList(revision);
            }
            catch (GitException e) {
                this.verbose(listener, "Not a valid SHA1 {0}", branchSpec);
            }
        }
        Collection<Revision> revisions = new HashSet<Revision>();
        if (!branchSpec.contains("/")) {
            for (RemoteConfig config : this.gitSCM.getRepositories()) {
                String repository = config.getName();
                String fqbn = repository + "/" + branchSpec;
                this.verbose(listener, "Qualifying {0} as a branch in repository {1} -> {2}", branchSpec, repository, fqbn);
                revisions.addAll(this.getHeadRevision(isPollCall, fqbn, git, listener, data));
            }
        } else {
            ArrayList<String> possibleQualifiedBranches = new ArrayList<String>();
            for (RemoteConfig config : this.gitSCM.getRepositories()) {
                String repository = config.getName();
                String fqbn = branchSpec.startsWith(repository + "/") ? "refs/remotes/" + branchSpec : (branchSpec.startsWith("remotes/" + repository + "/") ? "refs/" + branchSpec : (branchSpec.startsWith("refs/heads/") ? "refs/remotes/" + repository + "/" + branchSpec.substring("refs/heads/".length()) : branchSpec));
                this.verbose(listener, "Qualifying {0} as a branch in repository {1} -> {2}", branchSpec, repository, fqbn);
                possibleQualifiedBranches.add(fqbn);
                fqbn = "refs/remotes/" + repository + "/" + branchSpec;
                this.verbose(listener, "Qualifying {0} as a branch in repository {1} -> {2}", branchSpec, repository, fqbn);
                possibleQualifiedBranches.add(fqbn);
            }
            for (String fqbn : possibleQualifiedBranches) {
                revisions.addAll(this.getHeadRevision(isPollCall, fqbn, git, listener, data));
            }
        }
        if (revisions.isEmpty() && !(revisions = this.getHeadRevision(isPollCall, branchSpec, git, listener, data)).isEmpty()) {
            this.verbose(listener, "{0} seems to be a non-branch reference (tag?)", new Object[0]);
        }
        return revisions;
    }

    private Collection<Revision> getHeadRevision(boolean isPollCall, String singleBranch, GitClient git, TaskListener listener, BuildData data) throws InterruptedException {
        try {
            ObjectId sha1 = git.revParse(singleBranch);
            this.verbose(listener, "rev-parse {0} -> {1}", singleBranch, sha1);
            if (isPollCall && data.hasBeenBuilt(sha1)) {
                this.verbose(listener, "{0} has already been built", sha1);
                return Collections.emptyList();
            }
            this.verbose(listener, "Found a new commit {0} to be built on {1}", sha1, singleBranch);
            Revision revision = new Revision(sha1);
            revision.getBranches().add(new Branch(singleBranch, sha1));
            return Collections.singletonList(revision);
        }
        catch (GitException e) {
            this.verbose(listener, "Failed to rev-parse: {0}", singleBranch);
            return Collections.emptyList();
        }
    }

    private Revision objectId2Revision(String singleBranch, ObjectId sha1) {
        Revision revision = new Revision(sha1);
        revision.getBranches().add(new Branch(singleBranch, sha1));
        return revision;
    }

    private List<Revision> getAdvancedCandidateRevisions(boolean isPollCall, TaskListener listener, GitUtils utils, BuildData data, BuildChooserContext context) throws GitException, IOException, InterruptedException {
        EnvVars env = context.getEnvironment();
        Collection<Object> revs = new ArrayList<Revision>(utils.getAllBranchRevisions());
        this.verbose(listener, "Starting with all the branches: {0}", revs);
        Iterator i = revs.iterator();
        while (i.hasNext()) {
            Branch b;
            Revision r = (Revision)i.next();
            Iterator j = r.getBranches().iterator();
            while (j.hasNext()) {
                b = (Branch)j.next();
                boolean keep = false;
                for (BranchSpec bspec : this.gitSCM.getBranches()) {
                    if (!bspec.matches(b.getName(), env)) continue;
                    keep = true;
                    break;
                }
                if (keep) continue;
                this.verbose(listener, "Ignoring {0} because it doesn''t match branch specifier", b);
                j.remove();
            }
            if (r.getBranches().size() > 1) {
                j = r.getBranches().iterator();
                while (j.hasNext()) {
                    b = (Branch)j.next();
                    if (!HEAD.matches(b.getName(), env)) continue;
                    this.verbose(listener, "Ignoring {0} because there''s named branch for this revision", b.getName());
                    j.remove();
                }
            }
            if (!r.getBranches().isEmpty()) continue;
            this.verbose(listener, "Ignoring {0} because we don''t care about any of the branches that point to it", r);
            i.remove();
        }
        this.verbose(listener, "After branch filtering: {0}", revs);
        revs = utils.filterTipBranches(revs);
        this.verbose(listener, "After non-tip filtering: {0}", revs);
        this.verbose(listener, "Removing what''s already been built: {0}", data.getBuildsByBranchName());
        Revision lastBuiltRevision = data.getLastBuiltRevision();
        Iterator i2 = revs.iterator();
        while (i2.hasNext()) {
            Revision r = (Revision)i2.next();
            if (!data.hasBeenBuilt(r.getSha1())) continue;
            i2.remove();
            if (lastBuiltRevision == null || !lastBuiltRevision.getSha1().equals((AnyObjectId)r.getSha1())) continue;
            lastBuiltRevision = r;
        }
        this.verbose(listener, "After filtering out what''s already been built: {0}", revs);
        if (!isPollCall && revs.isEmpty() && lastBuiltRevision != null) {
            this.verbose(listener, "Nothing seems worth building, so falling back to the previously built revision: {0}", data.getLastBuiltRevision());
            return Collections.singletonList(utils.sortBranchesForRevision(lastBuiltRevision, this.gitSCM.getBranches(), env));
        }
        final Collection<Object> in = revs;
        return (List)utils.git.withRepository((RepositoryCallback)new RepositoryCallback<List<Revision>>(){

            public List<Revision> invoke(Repository repo, VirtualChannel channel) throws IOException, InterruptedException {
                Collections.sort(in, new CommitTimeComparator(repo));
                return in;
            }
        });
    }

    private void verbose(TaskListener listener, String format, Object ... args) {
        if (GitSCM.VERBOSE) {
            listener.getLogger().println(MessageFormat.format(format, args));
        }
    }

    boolean isAdvancedSpec(String branchSpec) {
        return branchSpec == null || branchSpec.contains("*") || branchSpec.startsWith(":");
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildChooserDescriptor {
        public String getDisplayName() {
            return Messages.BuildChooser_Default();
        }

        @Override
        public String getLegacyId() {
            return "Default";
        }
    }
}

