/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.Revision;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.scm.SCM;
import hudson.security.ACL;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitRemoteHeadRefAction;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.GitSCMSourceContext;
import jenkins.plugins.git.GitSCMSourceRequest;
import jenkins.plugins.git.MethodUtils;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.plugins.git.traits.GitSCMExtensionTrait;
import jenkins.plugins.git.traits.GitToolSCMSourceTrait;
import jenkins.plugins.git.traits.RemoteNameSCMSourceTrait;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.impl.trait.WildcardSCMHeadFilterTrait;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class AbstractGitSCMSource
extends SCMSource {
    public static final String DEFAULT_REMOTE_NAME = "origin";
    public static final String REF_SPEC_REMOTE_NAME_PLACEHOLDER_STR = "@{remote}";
    public static final String REF_SPEC_REMOTE_NAME_PLACEHOLDER = "(?i)" + Pattern.quote("@{remote}");
    public static final String REF_SPEC_DEFAULT = "+refs/heads/*:refs/remotes/@{remote}/*";
    private static final ConcurrentMap<String, Lock> cacheLocks = new ConcurrentHashMap<String, Lock>();
    private static final Logger LOGGER = Logger.getLogger(AbstractGitSCMSource.class.getName());

    public AbstractGitSCMSource() {
    }

    @Deprecated
    public AbstractGitSCMSource(String id) {
        this.setId(id);
    }

    @CheckForNull
    public abstract String getCredentialsId();

    public abstract String getRemote();

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="3.4.0")
    public String getIncludes() {
        for (SCMSourceTrait trait : this.getTraits()) {
            if (!(trait instanceof WildcardSCMHeadFilterTrait)) continue;
            return ((WildcardSCMHeadFilterTrait)trait).getIncludes();
        }
        return "*";
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="3.4.0")
    public String getExcludes() {
        for (SCMSourceTrait trait : this.getTraits()) {
            if (!(trait instanceof WildcardSCMHeadFilterTrait)) continue;
            return ((WildcardSCMHeadFilterTrait)trait).getExcludes();
        }
        return "";
    }

    @Deprecated
    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="3.4.0")
    public GitRepositoryBrowser getBrowser() {
        for (SCMSourceTrait trait : this.getTraits()) {
            if (!(trait instanceof GitBrowserSCMSourceTrait)) continue;
            return ((GitBrowserSCMSourceTrait)trait).getBrowser();
        }
        return null;
    }

    @Deprecated
    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="3.4.0")
    public String getGitTool() {
        for (SCMSourceTrait trait : this.getTraits()) {
            if (!(trait instanceof GitToolSCMSourceTrait)) continue;
            return ((GitToolSCMSourceTrait)trait).getGitTool();
        }
        return null;
    }

    @Deprecated
    @NonNull
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="3.4.0")
    public List<GitSCMExtension> getExtensions() {
        ArrayList extensions = new ArrayList();
        for (SCMSourceTrait t : this.getTraits()) {
            if (!(t instanceof GitSCMExtensionTrait)) continue;
            extensions.add(((GitSCMExtensionTrait)t).getExtension());
        }
        return Collections.unmodifiableList(extensions);
    }

    @NonNull
    public List<SCMSourceTrait> getTraits() {
        return Collections.emptyList();
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="3.4.0")
    public String getRemoteName() {
        for (SCMSourceTrait t : this.getTraits()) {
            if (!(t instanceof RemoteNameSCMSourceTrait)) continue;
            return ((RemoteNameSCMSourceTrait)t).getRemoteName();
        }
        return DEFAULT_REMOTE_NAME;
    }

    @Deprecated
    @CheckForNull
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="3.4.0")
    protected GitTool resolveGitTool() {
        return this.resolveGitTool(this.getGitTool());
    }

    @CheckForNull
    protected GitTool resolveGitTool(String gitTool) {
        return StringUtils.isBlank((String)gitTool) ? GitTool.getDefaultInstallation() : ((GitTool.DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallation(gitTool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private <T, C extends GitSCMSourceContext<C, R>, R extends GitSCMSourceRequest> T doRetrieve(Retriever<T> retriever, @NonNull C context, @NonNull TaskListener listener, boolean prune) throws IOException, InterruptedException {
        String cacheEntry = this.getCacheEntry();
        Lock cacheLock = AbstractGitSCMSource.getCacheLock(cacheEntry);
        cacheLock.lock();
        try {
            File cacheDir = AbstractGitSCMSource.getCacheDir(cacheEntry);
            Git git = Git.with((TaskListener)listener, (EnvVars)new EnvVars(EnvVars.masterEnvVars)).in(cacheDir);
            GitTool tool = this.resolveGitTool(context.gitTool());
            if (tool != null) {
                git.using(tool.getGitExe());
            }
            GitClient client = git.getClient();
            client.addDefaultCredentials((StandardCredentials)this.getCredentials());
            if (!client.hasGitRepo()) {
                listener.getLogger().println("Creating git repository in " + cacheDir);
                client.init();
            }
            String remoteName = context.remoteName();
            listener.getLogger().println("Setting " + remoteName + " to " + this.getRemote());
            client.setRemoteUrl(remoteName, this.getRemote());
            listener.getLogger().println((prune ? "Fetching & pruning " : "Fetching ") + remoteName + "...");
            FetchCommand fetch = client.fetch_();
            if (prune) {
                fetch = fetch.prune();
            }
            URIish remoteURI = null;
            try {
                remoteURI = new URIish(remoteName);
            }
            catch (URISyntaxException ex) {
                listener.getLogger().println("URI syntax exception for '" + remoteName + "' " + ex);
            }
            fetch.from(remoteURI, context.asRefSpecs()).execute();
            T t = retriever.run(client, remoteName);
            return t;
        }
        finally {
            cacheLock.unlock();
        }
    }

    @CheckForNull
    protected SCMRevision retrieve(final @NonNull SCMHead head, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return this.doRetrieve(new Retriever<SCMRevision>(){

            @Override
            public SCMRevision run(GitClient client, String remoteName) throws IOException, InterruptedException {
                for (Branch b : client.getRemoteBranches()) {
                    String branchName = StringUtils.removeStart((String)b.getName(), (String)(remoteName + "/"));
                    if (!branchName.equals(head.getName())) continue;
                    return new SCMRevisionImpl(head, b.getSHA1String());
                }
                return null;
            }
        }, (GitSCMSourceContext)new GitSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.getTraits()), listener, false);
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Known non-serializable this")
    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, final @NonNull TaskListener listener) throws IOException, InterruptedException {
        final GitSCMSourceContext context = (GitSCMSourceContext)new GitSCMSourceContext(criteria, observer).withTraits(this.getTraits());
        this.doRetrieve(new Retriever<Void>(){

            /*
             * Exception decompiling
             */
            @Override
            public Void run(GitClient client, String remoteName) throws IOException, InterruptedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, context, listener, true);
    }

    @CheckForNull
    protected SCMRevision retrieve(final @NonNull String revision, final @NonNull TaskListener listener) throws IOException, InterruptedException {
        final GitSCMSourceContext context = (GitSCMSourceContext)new GitSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.getTraits());
        return this.doRetrieve(new Retriever<SCMRevision>(){

            @Override
            public SCMRevision run(GitClient client, String remoteName) throws IOException, InterruptedException {
                String hash;
                try {
                    hash = client.revParse(revision).name();
                }
                catch (GitException x) {
                    try {
                        hash = client.revParse(context.remoteName() + "/" + revision).name();
                    }
                    catch (GitException x2) {
                        listener.getLogger().println(x.getMessage());
                        listener.getLogger().println(x2.getMessage());
                        return null;
                    }
                }
                return new SCMRevisionImpl(new SCMHead(revision), hash);
            }
        }, context, listener, false);
    }

    @NonNull
    protected Set<String> retrieveRevisions(@NonNull TaskListener listener) throws IOException, InterruptedException {
        final GitSCMSourceContext context = (GitSCMSourceContext)new GitSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.getTraits());
        return this.doRetrieve(new Retriever<Set<String>>(){

            @Override
            public Set<String> run(GitClient client, String remoteName) throws IOException, InterruptedException {
                HashSet<String> revisions = new HashSet<String>();
                for (Branch branch : client.getRemoteBranches()) {
                    revisions.add(branch.getName().replaceFirst("^" + Pattern.quote(context.remoteName()) + "/", ""));
                }
                revisions.addAll(client.getTagNames("*"));
                return revisions;
            }
        }, context, listener, false);
    }

    @NonNull
    protected List<Action> retrieveActions(@CheckForNull SCMSourceEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return this.doRetrieve(new Retriever<List<Action>>(){

            @Override
            public List<Action> run(GitClient client, String remoteName) throws IOException, InterruptedException {
                Map symrefs = client.getRemoteSymbolicReferences(AbstractGitSCMSource.this.getRemote(), null);
                if (symrefs.containsKey("HEAD")) {
                    String target = (String)symrefs.get("HEAD");
                    if (target.startsWith("refs/heads/")) {
                        target = target.substring("refs/heads/".length());
                    }
                    ArrayList<Action> result = new ArrayList<Action>();
                    if (StringUtils.isNotBlank((String)target)) {
                        result.add((Action)new GitRemoteHeadRefAction(AbstractGitSCMSource.this.getRemote(), target));
                    }
                    return result;
                }
                Map remoteReferences = client.getRemoteReferences(AbstractGitSCMSource.this.getRemote(), null, false, false);
                if (remoteReferences.containsKey("HEAD")) {
                    ObjectId head = (ObjectId)remoteReferences.get("HEAD");
                    TreeSet names = new TreeSet();
                    for (Map.Entry entry : remoteReferences.entrySet()) {
                        if (((String)entry.getKey()).equals("HEAD") || !head.equals((AnyObjectId)entry.getValue())) continue;
                        names.add(entry.getKey());
                    }
                    if (names.size() == 1) {
                        String target = (String)names.iterator().next();
                        if (target.startsWith("refs/heads/")) {
                            target = target.substring("refs/heads/".length());
                        }
                        ArrayList<Action> result = new ArrayList<Action>();
                        if (StringUtils.isNotBlank((String)target)) {
                            result.add((Action)new GitRemoteHeadRefAction(AbstractGitSCMSource.this.getRemote(), target));
                        }
                        return result;
                    }
                    if (names.contains("refs/heads/master")) {
                        ArrayList<Action> result = new ArrayList<Action>();
                        result.add((Action)new GitRemoteHeadRefAction(AbstractGitSCMSource.this.getRemote(), "master"));
                        return result;
                    }
                }
                return new ArrayList<Action>();
            }
        }, (GitSCMSourceContext)new GitSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.getTraits()), listener, false);
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMHead head, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        SCMSourceOwner owner = this.getOwner();
        if (owner instanceof Actionable) {
            for (GitRemoteHeadRefAction a : ((Actionable)owner).getActions(GitRemoteHeadRefAction.class)) {
                if (!this.getRemote().equals(a.getRemote()) || !head.getName().equals(a.getName())) continue;
                return Collections.singletonList(new PrimaryInstanceMetadataAction());
            }
        }
        return Collections.emptyList();
    }

    protected String getCacheEntry() {
        return AbstractGitSCMSource.getCacheEntry(this.getRemote());
    }

    protected static File getCacheDir(String cacheEntry) {
        boolean ok;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            LOGGER.severe("Jenkins instance is null in AbstractGitSCMSource.getCacheDir");
            return null;
        }
        File cacheDir = new File(new File(jenkins.getRootDir(), "caches"), cacheEntry);
        if (!cacheDir.isDirectory() && !(ok = cacheDir.mkdirs())) {
            LOGGER.log(Level.WARNING, "Failed mkdirs of {0}", cacheDir);
        }
        return cacheDir;
    }

    protected static Lock getCacheLock(String cacheEntry) {
        Lock cacheLock;
        while (null == (cacheLock = (Lock)cacheLocks.get(cacheEntry))) {
            cacheLocks.putIfAbsent(cacheEntry, new ReentrantLock());
        }
        return cacheLock;
    }

    @CheckForNull
    protected StandardUsernameCredentials getCredentials() {
        String credentialsId = this.getCredentialsId();
        if (credentialsId == null) {
            return null;
        }
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)this.getOwner(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)this.getRemote()).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), GitClient.CREDENTIALS_MATCHER}));
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="3.4.0")
    protected List<RefSpec> getRefSpecs() {
        return Collections.emptyList();
    }

    protected GitSCMBuilder<?> newBuilder(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        return new GitSCMBuilder(head, revision, this.getRemote(), this.getCredentialsId());
    }

    protected void decorate(GitSCMBuilder<?> builder) {
    }

    @NonNull
    public SCM build(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        GitSCMBuilder<?> builder = this.newBuilder(head, revision);
        if (MethodUtils.isOverridden(AbstractGitSCMSource.class, ((Object)((Object)this)).getClass(), "getExtensions", new Class[0])) {
            builder.withExtensions(this.getExtensions());
        }
        if (MethodUtils.isOverridden(AbstractGitSCMSource.class, ((Object)((Object)this)).getClass(), "getBrowser", new Class[0])) {
            builder.withBrowser(this.getBrowser());
        }
        if (MethodUtils.isOverridden(AbstractGitSCMSource.class, ((Object)((Object)this)).getClass(), "getGitTool", new Class[0])) {
            builder.withGitTool(this.getGitTool());
        }
        if (MethodUtils.isOverridden(AbstractGitSCMSource.class, ((Object)((Object)this)).getClass(), "getRefSpecs", new Class[0])) {
            ArrayList<String> specs = new ArrayList<String>();
            for (RefSpec spec : this.getRefSpecs()) {
                specs.add(spec.toString());
            }
            ((GitSCMBuilder)((Object)builder.withoutRefSpecs())).withRefSpecs(specs);
        }
        builder.withTraits(this.getTraits());
        this.decorate(builder);
        return builder.build();
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="3.4.0")
    protected List<UserRemoteConfig> getRemoteConfigs() {
        List<RefSpec> refSpecs = this.getRefSpecs();
        ArrayList<UserRemoteConfig> result = new ArrayList<UserRemoteConfig>(refSpecs.size());
        String remote = this.getRemote();
        for (RefSpec refSpec : refSpecs) {
            result.add(new UserRemoteConfig(remote, this.getRemoteName(), refSpec.toString(), this.getCredentialsId()));
        }
        return result;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="3.4.0")
    protected boolean isExcluded(String branchName) {
        return !Pattern.matches(this.getPattern(this.getIncludes()), branchName) || Pattern.matches(this.getPattern(this.getExcludes()), branchName);
    }

    private String getPattern(String branches) {
        StringBuilder quotedBranches = new StringBuilder();
        for (String wildcard : branches.split(" ")) {
            StringBuilder quotedBranch = new StringBuilder();
            for (String branch : wildcard.split("(?=[*])|(?<=[*])")) {
                if (branch.equals("*")) {
                    quotedBranch.append(".*");
                    continue;
                }
                if (branch.isEmpty()) continue;
                quotedBranch.append(Pattern.quote(branch));
            }
            if (quotedBranches.length() > 0) {
                quotedBranches.append("|");
            }
            quotedBranches.append((CharSequence)quotedBranch);
        }
        return quotedBranches.toString();
    }

    static String getCacheEntry(String remote) {
        return "git-" + Util.getDigestOf((String)remote);
    }

    public static class SpecificRevisionBuildChooser
    extends BuildChooser {
        private final Revision revision;

        public SpecificRevisionBuildChooser(SCMRevisionImpl revision) {
            ObjectId sha1 = ObjectId.fromString((String)revision.getHash());
            String name = revision.getHead().getName();
            this.revision = new Revision(sha1, Collections.singleton(new Branch(name, sha1)));
        }

        @Override
        public Collection<Revision> getCandidateRevisions(boolean isPollCall, String singleBranch, GitClient git, TaskListener listener, BuildData buildData, BuildChooserContext context) throws GitException, IOException, InterruptedException {
            return Collections.singleton(this.revision);
        }

        @Override
        public Build prevBuildForChangelog(String branch, @Nullable BuildData data, GitClient git, BuildChooserContext context) throws IOException, InterruptedException {
            return data == null ? null : data.lastBuild;
        }

        @Extension
        public static class DescriptorImpl
        extends BuildChooserDescriptor {
            public String getDisplayName() {
                return "Specific revision";
            }

            @Override
            public boolean isApplicable(Class<? extends Item> job) {
                return SCMSourceOwner.class.isAssignableFrom(job);
            }
        }
    }

    public static class SCMRevisionImpl
    extends SCMRevision {
        private String hash;

        public SCMRevisionImpl(SCMHead head, String hash) {
            super(head);
            this.hash = hash;
        }

        public String getHash() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            SCMRevisionImpl that = (SCMRevisionImpl)((Object)o);
            return StringUtils.equals((String)this.hash, (String)that.hash) && this.getHead().equals((Object)that.getHead());
        }

        public int hashCode() {
            return this.hash != null ? this.hash.hashCode() : 0;
        }

        public String toString() {
            return this.hash;
        }
    }

    private static interface Retriever<T> {
        public T run(GitClient var1, String var2) throws IOException, InterruptedException;
    }
}

