/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.plugins.git.GitStatus;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import jenkins.plugins.git.GitSCMSource;
import jenkins.scm.api.SCMEventListener;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TestExtension;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GitSCMSourceTest {
    public static final String REMOTE = "git@remote:test/project.git";
    @Rule
    public JenkinsRule jenkins = new JenkinsRule();
    private GitStatus gitStatus;

    @Before
    public void setup() {
        this.gitStatus = new GitStatus();
    }

    @Test
    public void testSourceOwnerTriggeredByDoNotifyCommit() throws Exception {
        GitSCMSource gitSCMSource = new GitSCMSource("id", REMOTE, "", "*", "", false);
        GitSCMSourceOwner scmSourceOwner = this.setupGitSCMSourceOwner(gitSCMSource);
        this.jenkins.getInstance().add((TopLevelItem)scmSourceOwner, "gitSourceOwner");
        this.gitStatus.doNotifyCommit((HttpServletRequest)Mockito.mock(HttpServletRequest.class), REMOTE, "master", "");
        SCMHeadEvent<?> event = ((SCMEventListenerImpl)((Object)this.jenkins.getInstance().getExtensionList(SCMEventListener.class).get(SCMEventListenerImpl.class))).waitSCMHeadEvent(1L, TimeUnit.SECONDS);
        Assert.assertThat(event, (Matcher)Matchers.notNullValue());
        Assert.assertThat(event.heads((SCMSource)gitSCMSource).keySet(), (Matcher)Matchers.hasItem((Matcher)Matchers.is((Object)new SCMHead("master"))));
        ((GitSCMSourceOwner)Mockito.verify((Object)scmSourceOwner, (VerificationMode)Mockito.times((int)0))).onSCMSourceUpdated((SCMSource)gitSCMSource);
    }

    private GitSCMSourceOwner setupGitSCMSourceOwner(GitSCMSource gitSCMSource) {
        GitSCMSourceOwner owner = (GitSCMSourceOwner)Mockito.mock(GitSCMSourceOwner.class);
        Mockito.when((Object)owner.hasPermission(Item.READ)).thenReturn((Object)true, (Object[])new Boolean[]{true, true});
        Mockito.when((Object)owner.getSCMSources()).thenReturn(Collections.singletonList(gitSCMSource));
        return owner;
    }

    @TestExtension
    public static class SCMEventListenerImpl
    extends SCMEventListener {
        SCMHeadEvent<?> head = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSCMHeadEvent(SCMHeadEvent<?> event) {
            SCMEventListenerImpl sCMEventListenerImpl = this;
            synchronized (sCMEventListenerImpl) {
                this.head = event;
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SCMHeadEvent<?> waitSCMHeadEvent(long timeout, TimeUnit units) throws TimeoutException, InterruptedException {
            long giveUp = System.currentTimeMillis() + units.toMillis(timeout);
            while (System.currentTimeMillis() < giveUp) {
                SCMEventListenerImpl sCMEventListenerImpl = this;
                synchronized (sCMEventListenerImpl) {
                    SCMHeadEvent<?> h = this.head;
                    if (h != null) {
                        this.head = null;
                        return h;
                    }
                    ((Object)((Object)this)).wait(Math.max(1L, giveUp - System.currentTimeMillis()));
                }
            }
            throw new TimeoutException();
        }
    }

    private static interface GitSCMSourceOwner
    extends TopLevelItem,
    SCMSourceOwner {
    }
}

