/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.git.GitTool;
import java.io.File;
import java.util.Collections;
import java.util.List;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import org.eclipse.jgit.transport.RefSpec;
import org.jenkinsci.plugins.gitclient.Git;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Git.class})
public class AbstractGitSCMSourceRetrieveHeadsTest {
    public static final String EXPECTED_GIT_EXE = "git-custom";
    private AbstractGitSCMSource gitSCMSource;

    @Before
    public void setup() throws Exception {
        GitTool mockedTool = (GitTool)PowerMockito.mock(GitTool.class, (Answer)Mockito.RETURNS_DEFAULTS);
        ((GitTool)PowerMockito.doReturn((Object)EXPECTED_GIT_EXE).when((Object)mockedTool)).getGitExe();
        Git git = (Git)Mockito.mock(Git.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ((Git)PowerMockito.doThrow((Throwable)new GitToolSpecified()).when((Object)git)).using(EXPECTED_GIT_EXE);
        ((Git)PowerMockito.doThrow((Throwable)new GitToolNotSpecified()).when((Object)git)).getClient();
        ((Git)PowerMockito.doReturn((Object)git).when((Object)git)).in((File)Mockito.any(File.class));
        ((Git)PowerMockito.doReturn((Object)git).when((Object)git)).in((FilePath)Mockito.any(FilePath.class));
        PowerMockito.mockStatic(Git.class, (Answer)Mockito.CALLS_REAL_METHODS);
        PowerMockito.doReturn((Object)git).when(Git.class, "with", new Object[]{Mockito.any(), Mockito.any()});
        this.gitSCMSource = (AbstractGitSCMSource)PowerMockito.spy((Object)((Object)new AbstractGitSCMSourceImpl()));
        ((AbstractGitSCMSource)PowerMockito.doReturn((Object)mockedTool).when((Object)this.gitSCMSource)).resolveGitTool();
    }

    @Test(expected=GitToolSpecified.class)
    public void correctGitToolIsUsed() throws Exception {
        try {
            this.gitSCMSource.retrieve(new SCMHead("master"), TaskListener.NULL);
        }
        catch (GitToolNotSpecified e) {
            Assert.fail((String)"Git client was constructed wirth arbitrary git tool");
        }
    }

    @Test(expected=GitToolSpecified.class)
    public void correctGitToolIsUsed2() throws Exception {
        try {
            this.gitSCMSource.retrieve(null, (SCMHeadObserver)PowerMockito.mock(SCMHeadObserver.class), null, TaskListener.NULL);
        }
        catch (GitToolNotSpecified e) {
            Assert.fail((String)"Git client was constructed with arbitrary git tool");
        }
    }

    public static class AbstractGitSCMSourceImpl
    extends AbstractGitSCMSource {
        public AbstractGitSCMSourceImpl() {
            super("AbstractGitSCMSourceImpl-id");
        }

        public String getGitTool() {
            return "EXPECTED_GIT_EXE";
        }

        public String getCredentialsId() {
            return "";
        }

        public String getRemote() {
            return "";
        }

        public String getIncludes() {
            return "";
        }

        public String getExcludes() {
            return "";
        }

        protected List<RefSpec> getRefSpecs() {
            return Collections.emptyList();
        }
    }

    public static class GitToolNotSpecified
    extends RuntimeException {
    }

    public static class GitToolSpecified
    extends RuntimeException {
    }
}

