/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.Cause;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.git.AbstractGitProject;
import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import hudson.plugins.git.RevisionParameterAction;
import hudson.plugins.git.util.BuildData;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class RevisionParameterActionTest
extends AbstractGitProject {
    @Test
    public void testCombiningScheduling() throws Exception {
        FreeStyleProject fs = this.jenkins.createFreeStyleProject("freestyle");
        QueueTaskFuture b1 = fs.scheduleBuild2(3, null, Collections.singletonList(new RevisionParameterAction("DEADBEEF")));
        QueueTaskFuture b2 = fs.scheduleBuild2(3, null, Collections.singletonList(new RevisionParameterAction("FREED456")));
        Assert.assertNotNull((Object)b1);
        Assert.assertNotNull((Object)b2);
        this.jenkins.waitUntilNoActivity();
        Assert.assertEquals((long)fs.getBuilds().size(), (long)2L);
    }

    @Test
    public void testCombiningScheduling2() throws Exception {
        FreeStyleProject fs = this.jenkins.createFreeStyleProject("freestyle");
        QueueTaskFuture b1 = fs.scheduleBuild2(3, null, Collections.singletonList(new RevisionParameterAction("DEADBEEF")));
        QueueTaskFuture b2 = fs.scheduleBuild2(3, null, Collections.singletonList(new RevisionParameterAction("DEADBEEF")));
        Assert.assertNotNull((Object)b1);
        this.jenkins.waitUntilNoActivity();
        Assert.assertEquals((long)fs.getBuilds().size(), (long)1L);
    }

    @Test
    public void testCombiningScheduling3() throws Exception {
        FreeStyleProject fs = this.jenkins.createFreeStyleProject("freestyle");
        QueueTaskFuture b1 = fs.scheduleBuild2(3);
        QueueTaskFuture b2 = fs.scheduleBuild2(3, null, Collections.singletonList(new RevisionParameterAction("DEADBEEF")));
        Assert.assertNotNull((Object)b1);
        Assert.assertNotNull((Object)b2);
        this.jenkins.waitUntilNoActivity();
        Assert.assertEquals((long)fs.getBuilds().size(), (long)2L);
    }

    @Test
    public void testCombiningScheduling4() throws Exception {
        FreeStyleProject fs = this.jenkins.createFreeStyleProject("freestyle");
        QueueTaskFuture b1 = fs.scheduleBuild2(3, null, Collections.singletonList(new RevisionParameterAction("DEADBEEF", true)));
        QueueTaskFuture b2 = fs.scheduleBuild2(3, null, Collections.singletonList(new RevisionParameterAction("FFEEFFEE", true)));
        Assert.assertNotNull((Object)b1);
        this.jenkins.waitUntilNoActivity();
        Assert.assertEquals((long)fs.getBuilds().size(), (long)1L);
        Assert.assertEquals((Object)((RevisionParameterAction)((FreeStyleBuild)fs.getBuilds().get((int)0)).getAction(RevisionParameterAction.class)).commit, (Object)"FFEEFFEE");
    }

    @Test
    public void testCombiningScheduling5() throws Exception {
        FreeStyleProject fs = this.jenkins.createFreeStyleProject("freestyle");
        QueueTaskFuture b1 = fs.scheduleBuild2(3, null, Collections.singletonList(new RevisionParameterAction("DEADBEEF", true)));
        QueueTaskFuture b2 = fs.scheduleBuild2(3, null, Collections.singletonList(new RevisionParameterAction("DEADBEEF", true)));
        Assert.assertNotNull((Object)b1);
        this.jenkins.waitUntilNoActivity();
        Assert.assertEquals((long)fs.getBuilds().size(), (long)1L);
        Assert.assertEquals((Object)((RevisionParameterAction)((FreeStyleBuild)fs.getBuilds().get((int)0)).getAction(RevisionParameterAction.class)).commit, (Object)"DEADBEEF");
    }

    @Test
    public void testCombiningScheduling6() throws Exception {
        FreeStyleProject fs = this.jenkins.createFreeStyleProject("freestyle");
        QueueTaskFuture b1 = fs.scheduleBuild2(3);
        QueueTaskFuture b2 = fs.scheduleBuild2(3, null, Collections.singletonList(new RevisionParameterAction("DEADBEEF", true)));
        Assert.assertNotNull((Object)b1);
        Assert.assertNotNull((Object)b2);
        this.jenkins.waitUntilNoActivity();
        Assert.assertEquals((long)fs.getBuilds().size(), (long)2L);
        Assert.assertEquals((Object)((RevisionParameterAction)((FreeStyleBuild)fs.getBuilds().get((int)0)).getAction(RevisionParameterAction.class)).commit, (Object)"DEADBEEF");
    }

    @Test
    public void testProvidingRevision() throws Exception {
        FreeStyleProject p1 = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commitNewFile("commitFile1");
        FreeStyleBuild b1 = this.build(p1, Result.SUCCESS, "commitFile1");
        Revision r1 = ((BuildData)b1.getAction(BuildData.class)).getLastBuiltRevision();
        String commitFile2 = "commitFile2";
        this.commitNewFile("commitFile2");
        FreeStyleBuild b2 = (FreeStyleBuild)p1.scheduleBuild2(0, (Cause)new Cause.UserIdCause(), Collections.singletonList(new RevisionParameterAction(r1))).get();
        Assert.assertEquals((Object)((BuildData)b2.getAction(BuildData.class)).getLastBuiltRevision().getSha1String(), (Object)r1.getSha1String());
        Assert.assertEquals((Object)((Branch)((BuildData)b2.getAction(BuildData.class)).getLastBuiltRevision().getBranches().iterator().next()).getName(), (Object)((Branch)r1.getBranches().iterator().next()).getName());
        FreeStyleBuild b3 = this.build(p1, Result.SUCCESS, "commitFile2");
        Assert.assertFalse((boolean)((BuildData)b3.getAction(BuildData.class)).getLastBuiltRevision().getSha1String().equals(r1.getSha1String()));
    }
}

