/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.UserRemoteConfig;
import hudson.remoting.VirtualChannel;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.security.ACL;
import hudson.util.LogTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.GitSCMFile;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;

public class GitSCMFileSystem
extends SCMFileSystem {
    private static final Logger LOGGER = Logger.getLogger(GitSCMFileSystem.class.getName());
    private final String cacheEntry;
    private final TaskListener listener;
    private final String remote;
    private final String head;
    private final GitClient client;
    private final ObjectId commitId;

    protected GitSCMFileSystem(GitClient client, String remote, String head, @CheckForNull AbstractGitSCMSource.SCMRevisionImpl rev) throws IOException, InterruptedException {
        super((SCMRevision)rev);
        this.remote = remote;
        this.head = head;
        this.cacheEntry = AbstractGitSCMSource.getCacheEntry(remote);
        this.listener = new LogTaskListener(LOGGER, Level.FINER);
        this.client = client;
        this.commitId = rev == null ? this.invoke(repository -> repository.findRef(head).getObjectId()) : ObjectId.fromString((String)rev.getHash());
    }

    public AbstractGitSCMSource.SCMRevisionImpl getRevision() {
        return (AbstractGitSCMSource.SCMRevisionImpl)super.getRevision();
    }

    public long lastModified() throws IOException, InterruptedException {
        return this.invoke(new FSFunction<Long>(){

            @Override
            public Long invoke(Repository repository) throws IOException {
                try (RevWalk walk = new RevWalk(repository);){
                    RevCommit commit = walk.parseCommit((AnyObjectId)GitSCMFileSystem.this.commitId);
                    Long l = TimeUnit.SECONDS.toMillis(commit.getCommitTime());
                    return l;
                }
            }
        });
    }

    @NonNull
    public SCMFile getRoot() {
        return new GitSCMFile(this);
    }

    ObjectId getCommitId() {
        return this.commitId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V invoke(final FSFunction<V> function) throws IOException, InterruptedException {
        Lock cacheLock = AbstractGitSCMSource.getCacheLock(this.cacheEntry);
        cacheLock.lock();
        try {
            File cacheDir = AbstractGitSCMSource.getCacheDir(this.cacheEntry);
            if (cacheDir == null || !cacheDir.isDirectory()) {
                throw new IOException("Closed");
            }
            Object object = this.client.withRepository(new RepositoryCallback<V>(){

                public V invoke(Repository repository, VirtualChannel virtualChannel) throws IOException, InterruptedException {
                    return function.invoke(repository);
                }
            });
            return (V)object;
        }
        finally {
            cacheLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public boolean changesSince(@CheckForNull SCMRevision revision, @NonNull OutputStream changeLogStream) throws UnsupportedOperationException, IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Extension(ordinal=-32768.0)
    public static class BuilderImpl
    extends SCMFileSystem.Builder {
        public boolean supports(SCM source) {
            return source instanceof GitSCM && ((GitSCM)source).getUserRemoteConfigs().size() == 1 && ((GitSCM)source).getBranches().size() == 1 && ((GitSCM)source).getBranches().get(0).getName().matches("^((\\Qrefs/heads/\\E.*)|([^/]+)|(\\*/[^/*]+(/[^/*]+)*))$");
        }

        public boolean supports(SCMSource source) {
            return source instanceof AbstractGitSCMSource;
        }

        public boolean supportsDescriptor(SCMDescriptor descriptor) {
            return descriptor instanceof GitSCM.DescriptorImpl;
        }

        public boolean supportsDescriptor(SCMSourceDescriptor descriptor) {
            return AbstractGitSCMSource.class.isAssignableFrom(descriptor.clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SCMFileSystem build(@NonNull Item owner, @NonNull SCM scm, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
            if (rev != null && !(rev instanceof AbstractGitSCMSource.SCMRevisionImpl)) {
                return null;
            }
            LogTaskListener listener = new LogTaskListener(LOGGER, Level.FINE);
            GitSCM gitSCM = (GitSCM)scm;
            UserRemoteConfig config = gitSCM.getUserRemoteConfigs().get(0);
            BranchSpec branchSpec = gitSCM.getBranches().get(0);
            String remote = config.getUrl();
            String cacheEntry = AbstractGitSCMSource.getCacheEntry(remote);
            Lock cacheLock = AbstractGitSCMSource.getCacheLock(cacheEntry);
            cacheLock.lock();
            try {
                File cacheDir = AbstractGitSCMSource.getCacheDir(cacheEntry);
                Git git = Git.with((TaskListener)listener, (EnvVars)new EnvVars(EnvVars.masterEnvVars)).in(cacheDir);
                GitTool tool = gitSCM.resolveGitTool((TaskListener)listener);
                if (tool != null) {
                    git.using(tool.getGitExe());
                }
                GitClient client = git.getClient();
                String credentialsId = config.getCredentialsId();
                if (credentialsId != null) {
                    StandardCredentials credential = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)remote).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), GitClient.CREDENTIALS_MATCHER}));
                    client.addDefaultCredentials(credential);
                    CredentialsProvider.track((Item)owner, (Credentials)credential);
                }
                if (!client.hasGitRepo()) {
                    listener.getLogger().println("Creating git repository in " + cacheDir);
                    client.init();
                }
                String remoteName = StringUtils.defaultIfBlank((String)config.getName(), (String)"origin");
                listener.getLogger().println("Setting " + remoteName + " to " + remote);
                client.setRemoteUrl(remoteName, remote);
                listener.getLogger().println("Fetching & pruning " + remoteName + "...");
                URIish remoteURI = null;
                try {
                    remoteURI = new URIish(remoteName);
                }
                catch (URISyntaxException ex) {
                    listener.getLogger().println("URI syntax exception for '" + remoteName + "' " + ex);
                }
                String headName = rev != null ? rev.getHead().getName() : (branchSpec.getName().startsWith("refs/heads/") ? branchSpec.getName().substring("refs/heads/".length()) : (branchSpec.getName().startsWith("*/") ? branchSpec.getName().substring(2) : branchSpec.getName()));
                client.fetch_().prune().from(remoteURI, Arrays.asList(new RefSpec("+refs/heads/" + headName + ":" + "refs/remotes/" + remoteName + "/" + headName))).execute();
                listener.getLogger().println("Done.");
                GitSCMFileSystem gitSCMFileSystem = new GitSCMFileSystem(client, remote, "refs/remotes/" + remoteName + "/" + headName, (AbstractGitSCMSource.SCMRevisionImpl)rev);
                return gitSCMFileSystem;
            }
            finally {
                cacheLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SCMFileSystem build(@NonNull SCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
            if (rev != null && !(rev instanceof AbstractGitSCMSource.SCMRevisionImpl)) {
                return null;
            }
            LogTaskListener listener = new LogTaskListener(LOGGER, Level.FINE);
            AbstractGitSCMSource gitSCMSource = (AbstractGitSCMSource)source;
            GitSCMBuilder<?> builder = gitSCMSource.newBuilder(head, rev);
            String cacheEntry = gitSCMSource.getCacheEntry();
            Lock cacheLock = AbstractGitSCMSource.getCacheLock(cacheEntry);
            cacheLock.lock();
            try {
                File cacheDir = AbstractGitSCMSource.getCacheDir(cacheEntry);
                Git git = Git.with((TaskListener)listener, (EnvVars)new EnvVars(EnvVars.masterEnvVars)).in(cacheDir);
                GitTool tool = gitSCMSource.resolveGitTool(builder.gitTool());
                if (tool != null) {
                    git.using(tool.getGitExe());
                }
                GitClient client = git.getClient();
                client.addDefaultCredentials((StandardCredentials)gitSCMSource.getCredentials());
                if (!client.hasGitRepo()) {
                    listener.getLogger().println("Creating git repository in " + cacheDir);
                    client.init();
                }
                String remoteName = builder.remoteName();
                listener.getLogger().println("Setting " + remoteName + " to " + gitSCMSource.getRemote());
                client.setRemoteUrl(remoteName, gitSCMSource.getRemote());
                listener.getLogger().println("Fetching & pruning " + remoteName + "...");
                URIish remoteURI = null;
                try {
                    remoteURI = new URIish(remoteName);
                }
                catch (URISyntaxException ex) {
                    listener.getLogger().println("URI syntax exception for '" + remoteName + "' " + ex);
                }
                client.fetch_().prune().from(remoteURI, builder.asRefSpecs()).execute();
                listener.getLogger().println("Done.");
                GitSCMFileSystem gitSCMFileSystem = new GitSCMFileSystem(client, gitSCMSource.getRemote(), "refs/remotes/" + remoteName + "/" + head.getName(), (AbstractGitSCMSource.SCMRevisionImpl)rev);
                return gitSCMFileSystem;
            }
            finally {
                cacheLock.unlock();
            }
        }
    }

    public static interface FSFunction<V> {
        public V invoke(Repository var1) throws IOException, InterruptedException;
    }
}

