/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserMergeOptions
extends AbstractDescribableImpl<UserMergeOptions>
implements Serializable {
    private String mergeRemote;
    private String mergeTarget;
    private String mergeStrategy;
    private MergeCommand.GitPluginFastForwardMode fastForwardMode;

    @Deprecated
    public UserMergeOptions(String mergeRemote, String mergeTarget, String mergeStrategy) {
        this(mergeRemote, mergeTarget, mergeStrategy, MergeCommand.GitPluginFastForwardMode.FF);
    }

    @DataBoundConstructor
    public UserMergeOptions(String mergeRemote, String mergeTarget, String mergeStrategy, MergeCommand.GitPluginFastForwardMode fastForwardMode) {
        this.mergeRemote = mergeRemote;
        this.mergeTarget = mergeTarget;
        this.mergeStrategy = mergeStrategy;
        this.fastForwardMode = fastForwardMode;
    }

    public UserMergeOptions(PreBuildMergeOptions pbm) {
        this(pbm.getRemoteBranchName(), pbm.getMergeTarget(), pbm.getMergeStrategy().toString(), pbm.getFastForwardMode());
    }

    public String getMergeRemote() {
        return this.mergeRemote;
    }

    public String getMergeTarget() {
        return this.mergeTarget;
    }

    public String getRef() {
        return this.mergeRemote + "/" + this.mergeTarget;
    }

    public MergeCommand.Strategy getMergeStrategy() {
        for (MergeCommand.Strategy strategy : MergeCommand.Strategy.values()) {
            if (!strategy.toString().equals(this.mergeStrategy)) continue;
            return strategy;
        }
        return MergeCommand.Strategy.DEFAULT;
    }

    public MergeCommand.GitPluginFastForwardMode getFastForwardMode() {
        for (MergeCommand.GitPluginFastForwardMode ffMode : MergeCommand.GitPluginFastForwardMode.values()) {
            if (!ffMode.equals((Object)this.fastForwardMode)) continue;
            return ffMode;
        }
        return MergeCommand.GitPluginFastForwardMode.FF;
    }

    public String toString() {
        return "UserMergeOptions{mergeRemote='" + this.mergeRemote + '\'' + ", mergeTarget='" + this.mergeTarget + '\'' + ", mergeStrategy='" + this.mergeStrategy + '\'' + ", fastForwardMode='" + this.fastForwardMode + '\'' + '}';
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UserMergeOptions) {
            UserMergeOptions that = (UserMergeOptions)other;
            if ((this.mergeRemote != null && this.mergeRemote.equals(that.mergeRemote) || this.mergeRemote == null && that.mergeRemote == null) && (this.mergeTarget != null && this.mergeTarget.equals(that.mergeTarget) || this.mergeTarget == null && that.mergeTarget == null) && (this.mergeStrategy != null && this.mergeStrategy.equals(that.mergeStrategy) || this.mergeStrategy == null && that.mergeStrategy == null) && (this.fastForwardMode != null && this.fastForwardMode.equals((Object)that.fastForwardMode) || this.fastForwardMode == null && that.fastForwardMode == null)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = this.mergeRemote != null ? this.mergeRemote.hashCode() : 0;
        result = 31 * result + (this.mergeTarget != null ? this.mergeTarget.hashCode() : 0);
        result = 31 * result + (this.mergeStrategy != null ? this.mergeStrategy.hashCode() : 0);
        result = 31 * result + (this.fastForwardMode != null ? this.fastForwardMode.hashCode() : 0);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<UserMergeOptions> {
        public String getDisplayName() {
            return "";
        }

        public ListBoxModel doFillMergeStrategyItems() {
            ListBoxModel m = new ListBoxModel();
            for (MergeCommand.Strategy strategy : MergeCommand.Strategy.values()) {
                m.add(strategy.toString(), strategy.toString());
            }
            return m;
        }
    }
}

