/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class Phabricator
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final String repo;

    @DataBoundConstructor
    public Phabricator(String repoUrl, String repo) {
        super(repoUrl);
        this.repo = repo;
    }

    public String getRepo() {
        return this.repo;
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        return new URL(this.getUrl(), String.format("/r%s%s", this.getRepo(), changeSet.getId().toString()));
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        String sha = changeSet.getId().toString();
        String spec = String.format("/diffusion/%s/change/master/%s;%s", this.getRepo(), path.getPath(), sha);
        return new URL(this.getUrl(), spec);
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        String sha = changeSet.getId().toString();
        String spec = String.format("/diffusion/%s/history/master/%s;%s", this.getRepo(), path.getPath(), sha);
        return new URL(this.getUrl(), spec);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class PhabricatorDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "phabricator";
        }

        public Phabricator newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            return (Phabricator)((Object)req.bindJSON(Phabricator.class, jsonObject));
        }
    }
}

