/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.plugins.git.Revision;
import java.io.IOException;
import java.util.Comparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitTimeComparator
implements Comparator<Revision> {
    private final RevWalk walk;

    public CommitTimeComparator(Repository r) {
        this.walk = new RevWalk(r);
    }

    @Override
    public int compare(Revision lhs, Revision rhs) {
        return this.compare(this.time(lhs), this.time(rhs));
    }

    private int time(Revision r) {
        try {
            return this.walk.parseCommit((AnyObjectId)r.getSha1()).getCommitTime();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse " + r.getSha1(), e);
        }
    }

    @Override
    private int compare(int lhs, int rhs) {
        if (lhs < rhs) {
            return -1;
        }
        if (lhs > rhs) {
            return 1;
        }
        return 0;
    }
}

