/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Hudson;
import hudson.model.UnprotectedRootAction;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.MultipleScmResolver;
import hudson.plugins.git.RevisionParameterAction;
import hudson.plugins.git.extensions.impl.IgnoreNotifyCommit;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.triggers.SCMTrigger;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class GitStatus
extends AbstractModelObject
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(GitStatus.class.getName());

    public String getDisplayName() {
        return "Git";
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "git";
    }

    public HttpResponse doNotifyCommit(@QueryParameter(required=true) String url, @QueryParameter(required=false) String branches, @QueryParameter(required=false) String sha1) throws ServletException, IOException {
        URIish uri;
        try {
            uri = new URIish(url);
        }
        catch (URISyntaxException e) {
            return HttpResponses.error((int)400, (Throwable)new Exception("Illegal URL: " + url, e));
        }
        branches = Util.fixEmptyAndTrim((String)branches);
        String[] branchesArray = branches == null ? new String[]{} : branches.split(",");
        final ArrayList<ResponseContributor> contributors = new ArrayList<ResponseContributor>();
        for (Listener listener : Jenkins.getInstance().getExtensionList(Listener.class)) {
            contributors.addAll(listener.onNotifyCommit(uri, sha1, branchesArray));
        }
        return new HttpResponse(){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.setStatus(200);
                rsp.setContentType("text/plain");
                for (ResponseContributor c : contributors) {
                    c.addHeaders(req, rsp);
                }
                PrintWriter w = rsp.getWriter();
                for (ResponseContributor c : contributors) {
                    c.writeBody(req, rsp, w);
                }
            }
        };
    }

    private static Collection<GitSCM> getProjectScms(AbstractProject<?, ?> project) {
        SCM scm;
        HashSet projectScms = Sets.newHashSet();
        if (Jenkins.getInstance().getPlugin("multiple-scms") != null) {
            MultipleScmResolver multipleScmResolver = new MultipleScmResolver();
            multipleScmResolver.resolveMultiScmIfConfigured(project, projectScms);
        }
        if (projectScms.isEmpty() && (scm = project.getScm()) instanceof GitSCM) {
            projectScms.add((GitSCM)scm);
        }
        return projectScms;
    }

    public static boolean looselyMatches(URIish lhs, URIish rhs) {
        return StringUtils.equals((String)lhs.getHost(), (String)rhs.getHost()) && StringUtils.equals((String)GitStatus.normalizePath(lhs.getPath()), (String)GitStatus.normalizePath(rhs.getPath()));
    }

    private static String normalizePath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.endsWith(".git")) {
            path = path.substring(0, path.length() - 4);
        }
        return path;
    }

    public static class CommitHookCause
    extends Cause {
        public final String sha1;

        public CommitHookCause(String sha1) {
            this.sha1 = sha1;
        }

        public String getShortDescription() {
            return "commit notification " + this.sha1;
        }
    }

    public static class MessageResponseContributor
    extends ResponseContributor {
        private final String msg;

        public MessageResponseContributor(String msg) {
            this.msg = msg;
        }

        public void writeBody(PrintWriter w) {
            w.println(this.msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class JenkinsAbstractProjectListener
    extends Listener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ResponseContributor> onNotifyCommit(URIish uri, String sha1, String ... branches) {
            ArrayList<ResponseContributor> result = new ArrayList<ResponseContributor>();
            SecurityContext old = ACL.impersonate((Authentication)ACL.SYSTEM);
            try {
                boolean scmFound = false;
                boolean urlFound = false;
                for (AbstractProject project : Hudson.getInstance().getAllItems(AbstractProject.class)) {
                    Collection projectSCMs = GitStatus.getProjectScms(project);
                    block4: for (GitSCM git : projectSCMs) {
                        scmFound = true;
                        for (RemoteConfig repository : git.getRepositories()) {
                            boolean repositoryMatches = false;
                            boolean branchMatches = false;
                            for (URIish remoteURL : repository.getURIs()) {
                                if (!GitStatus.looselyMatches(uri, remoteURL)) continue;
                                repositoryMatches = true;
                                break;
                            }
                            if (!repositoryMatches || git.getExtensions().get(IgnoreNotifyCommit.class) != null) continue;
                            SCMTrigger trigger = (SCMTrigger)project.getTrigger(SCMTrigger.class);
                            if (trigger != null && trigger.isIgnorePostCommitHooks()) {
                                LOGGER.info("PostCommitHooks are disabled on " + project.getFullDisplayName());
                                continue;
                            }
                            Boolean branchFound = false;
                            if (branches.length == 0) {
                                branchFound = true;
                            } else {
                                block7: for (BranchSpec branchSpec : git.getBranches()) {
                                    for (String branch : branches) {
                                        if (!branchSpec.matches(repository.getName() + "/" + branch)) continue;
                                        branchFound = true;
                                        break block7;
                                    }
                                }
                            }
                            if (!branchFound.booleanValue()) continue;
                            urlFound = true;
                            if (project.isDisabled()) continue block4;
                            if (StringUtils.isNotEmpty((String)sha1)) {
                                LOGGER.info("Scheduling " + project.getFullDisplayName() + " to build commit " + sha1);
                                project.scheduleBuild2(project.getQuietPeriod(), (Cause)new CommitHookCause(sha1), new Action[]{new RevisionParameterAction(sha1)});
                                result.add(new ScheduledResponseContributor(project));
                                continue block4;
                            }
                            if (trigger == null) continue block4;
                            LOGGER.info("Triggering the polling of " + project.getFullDisplayName());
                            trigger.run();
                            result.add(new PollingScheduledResponseContributor(project));
                            continue block4;
                        }
                    }
                }
                if (!scmFound) {
                    result.add(new MessageResponseContributor("No git jobs found"));
                } else if (!urlFound) {
                    result.add(new MessageResponseContributor("No git jobs using repository: " + uri.toString() + " and branches: " + StringUtils.join((Object[])branches, (String)",")));
                }
                ArrayList<ResponseContributor> arrayList = result;
                return arrayList;
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)old);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ScheduledResponseContributor
        extends ResponseContributor {
            private final AbstractProject<?, ?> project;

            public ScheduledResponseContributor(AbstractProject<?, ?> project) {
                this.project = project;
            }

            @Override
            public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
                rsp.addHeader("Triggered", this.project.getAbsoluteUrl());
            }

            @Override
            public void writeBody(PrintWriter w) {
                w.println("Scheduled " + this.project.getFullDisplayName());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class PollingScheduledResponseContributor
        extends ResponseContributor {
            private final AbstractProject<?, ?> project;

            public PollingScheduledResponseContributor(AbstractProject<?, ?> project) {
                this.project = project;
            }

            @Override
            public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
                rsp.addHeader("Triggered", this.project.getAbsoluteUrl());
            }

            @Override
            public void writeBody(PrintWriter w) {
                w.println("Scheduled polling of " + this.project.getFullDisplayName());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Listener
    implements ExtensionPoint {
        public List<ResponseContributor> onNotifyCommit(URIish uri, String[] branches) {
            return this.onNotifyCommit(uri, null, branches);
        }

        public List<ResponseContributor> onNotifyCommit(URIish uri, @Nullable String sha1, String ... branches) {
            return Collections.EMPTY_LIST;
        }
    }

    public static class ResponseContributor {
        public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
        }

        public void writeBody(StaplerRequest req, StaplerResponse rsp, PrintWriter w) {
            this.writeBody(w);
        }

        public void writeBody(PrintWriter w) {
        }
    }
}

