/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.SubmoduleCombinator;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.plugins.git.util.BuildData;
import java.io.IOException;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmoduleOption
extends GitSCMExtension {
    private boolean disableSubmodules;
    private boolean recursiveSubmodules;

    @DataBoundConstructor
    public SubmoduleOption(boolean disableSubmodules, boolean recursiveSubmodules) {
        this.disableSubmodules = disableSubmodules;
        this.recursiveSubmodules = recursiveSubmodules;
    }

    public boolean isDisableSubmodules() {
        return this.disableSubmodules;
    }

    public boolean isRecursiveSubmodules() {
        return this.recursiveSubmodules;
    }

    @Override
    public void onClean(GitSCM scm, GitClient git) throws IOException, InterruptedException, GitException {
        if (!this.disableSubmodules && git.hasGitModules()) {
            git.submoduleClean(this.recursiveSubmodules);
        }
    }

    @Override
    public void onCheckoutCompleted(GitSCM scm, AbstractBuild<?, ?> build, GitClient git, BuildListener listener) throws IOException, InterruptedException, GitException {
        BuildData revToBuild = scm.getBuildData((Run)build);
        if (!this.disableSubmodules && git.hasGitModules()) {
            git.setupSubmoduleUrls(revToBuild.lastBuild.getRevision(), (TaskListener)listener);
            git.submoduleUpdate(this.recursiveSubmodules);
        }
        if (scm.isDoGenerateSubmoduleConfigurations()) {
            SubmoduleCombinator combinator = new SubmoduleCombinator(git, (TaskListener)listener, scm.getSubmoduleCfg());
            combinator.createSubmoduleCombinations();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return "Advanced sub-modules behaviours";
        }
    }
}

