/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ViewGitWeb
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final String projectName;

    @DataBoundConstructor
    public ViewGitWeb(String url, String projectName) {
        super(url);
        this.projectName = projectName;
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType() == EditType.EDIT) {
            URL url = this.getUrl();
            String spec = this.buildCommitDiffSpec(url, path);
            return new URL(url, url.getPath() + spec);
        }
        return null;
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        URL url = this.getUrl();
        if (path.getEditType() == EditType.DELETE) {
            String spec = this.buildCommitDiffSpec(url, path);
            return new URL(url, url.getPath() + spec);
        }
        String spec = this.param(url).add("p=" + this.projectName).add("a=viewblob").add("h=" + path.getDst()).add("f=" + path.getPath()).toString();
        return new URL(url, url.getPath() + spec);
    }

    private String buildCommitDiffSpec(URL url, GitChangeSet.Path path) throws UnsupportedEncodingException {
        return this.param(url).add("p=" + this.projectName).add("a=commitdiff").add("h=" + path.getChangeSet().getId()).toString() + "#" + URLEncoder.encode(path.getPath(), "UTF-8").toString();
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, url.getPath() + this.param(url).add("p=" + this.projectName).add("a=commit").add("h=" + changeSet.getId()).toString());
    }

    private QueryBuilder param(URL url) {
        return new QueryBuilder(url.getQuery());
    }

    public String getProjectName() {
        return this.projectName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class ViewGitWebDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "viewgit";
        }

        public ViewGitWeb newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            return (ViewGitWeb)((Object)req.bindJSON(ViewGitWeb.class, jsonObject));
        }

        public FormValidation doCheckUrl(final @QueryParameter(fixEmpty=true) String url) throws IOException, ServletException {
            if (url == null) {
                return FormValidation.ok();
            }
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    String v = url;
                    if (!v.endsWith("/")) {
                        v = v + '/';
                    }
                    try {
                        if (this.findText(this.open(new URL(v)), "ViewGit")) {
                            return FormValidation.ok();
                        }
                        return FormValidation.error((String)"This is a valid URL but it doesn't look like ViewGit");
                    }
                    catch (IOException e) {
                        return this.handleIOException(v, e);
                    }
                }
            }.check();
        }
    }
}

