/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class BitbucketWeb
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public BitbucketWeb(String url) {
        super(url);
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, url.getPath() + "changeset/" + changeSet.getId());
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT || path.getSrc() == null || path.getDst() == null || path.getChangeSet().getParentCommit() == null) {
            return null;
        }
        String pathAsString = path.getPath();
        return this.getDiffLinkRegardlessOfEditType(path);
    }

    private URL getDiffLinkRegardlessOfEditType(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        String pathAsString = path.getPath();
        return new URL(this.getChangeSetLink(changeSet), "#chg-" + pathAsString);
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        String pathAsString = path.getPath();
        URL url = this.getUrl();
        return new URL(url, url.getPath() + "history/" + pathAsString);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class BitbucketWebDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "bitbucketweb";
        }

        public BitbucketWeb newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            return (BitbucketWeb)((Object)req.bindJSON(BitbucketWeb.class, jsonObject));
        }
    }
}

