/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitClientType;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import java.io.IOException;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneOption
extends GitSCMExtension {
    private boolean shallow;
    private String reference;

    @DataBoundConstructor
    public CloneOption(boolean shallow, String reference) {
        this.shallow = shallow;
        this.reference = reference;
    }

    public boolean isShallow() {
        return this.shallow;
    }

    public String getReference() {
        return this.reference;
    }

    @Override
    public void decorateCloneCommand(GitSCM scm, AbstractBuild<?, ?> build, GitClient git, BuildListener listener, CloneCommand cmd) throws IOException, InterruptedException, GitException {
        if (this.shallow) {
            listener.getLogger().println("Using shallow clone");
            cmd.shallow();
        }
        cmd.reference(build.getEnvironment((TaskListener)listener).expand(this.reference));
    }

    @Override
    public GitClientType getRequiredClient() {
        return GitClientType.GITCLI;
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return "Advanced clone behaviours";
        }
    }
}

