/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.Extension;
import hudson.model.Item;
import hudson.plugins.git.GitStatus;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.Messages;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSCMSource
extends AbstractGitSCMSource {
    private static final String DEFAULT_INCLUDES = "*";
    private static final String DEFAULT_EXCLUDES = "";
    public static final Logger LOGGER = Logger.getLogger(GitSCMSource.class.getName());
    private final String remote;
    private final String credentialsId;
    private final String includes;
    private final String excludes;

    @DataBoundConstructor
    public GitSCMSource(String id, String remote, String credentialsId, String includes, String excludes) {
        super(id);
        this.remote = remote;
        this.credentialsId = credentialsId;
        this.includes = includes;
        this.excludes = excludes;
    }

    @Override
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Override
    public String getRemote() {
        return this.remote;
    }

    @Override
    public String getIncludes() {
        return this.includes;
    }

    @Override
    public String getExcludes() {
        return this.excludes;
    }

    @Override
    protected List<RefSpec> getRefSpecs() {
        return Arrays.asList(new RefSpec("+refs/heads/*:refs/remotes/origin/*"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class ListenerImpl
    extends GitStatus.Listener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<GitStatus.ResponseContributor> onNotifyCommit(URIish uri, String ... branches) {
            ArrayList<GitStatus.ResponseContributor> result = new ArrayList<GitStatus.ResponseContributor>();
            boolean notified = false;
            Authentication old = SecurityContextHolder.getContext().getAuthentication();
            SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
            try {
                for (final SCMSourceOwner owner : SCMSourceOwners.all()) {
                    for (SCMSource source : owner.getSCMSources()) {
                        URIish remote;
                        if (!(source instanceof GitSCMSource)) continue;
                        GitSCMSource git = (GitSCMSource)source;
                        try {
                            remote = new URIish(git.getRemote());
                        }
                        catch (URISyntaxException e) {
                            continue;
                        }
                        if (!GitStatus.looselyMatches(uri, remote)) continue;
                        LOGGER.info("Triggering the indexing of " + owner.getFullDisplayName());
                        owner.onSCMSourceUpdated(source);
                        result.add(new GitStatus.ResponseContributor(){

                            public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
                                rsp.addHeader("Triggered", owner.getAbsoluteUrl());
                            }

                            public void writeBody(PrintWriter w) {
                                w.println("Scheduled indexing of " + owner.getFullDisplayName());
                            }
                        });
                        notified = true;
                    }
                }
            }
            finally {
                SecurityContextHolder.getContext().setAuthentication(old);
            }
            if (!notified) {
                result.add(new GitStatus.MessageResponseContributor("No git consumers for URI " + uri.toString()));
            }
            return result;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        public String getDisplayName() {
            return Messages.GitSCMSource_DisplayName();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String remote) {
            StandardListBoxModel result = new StandardListBoxModel();
            result.withEmptySelection();
            result.withMatching(GitClient.CREDENTIALS_MATCHER, (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)remote).build()));
            return result;
        }
    }
}

