/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.AbstractBuild;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitChangeSetList;
import hudson.scm.ChangeLogParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitChangeLogParser
extends ChangeLogParser {
    private boolean authorOrCommitter;
    private static int THRESHOLD = 1000;

    public GitChangeLogParser(boolean authorOrCommitter) {
        this.authorOrCommitter = authorOrCommitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitChangeSetList parse(AbstractBuild build, File changelogFile) throws IOException, SAXException {
        LinkedHashSet<GitChangeSet> r = new LinkedHashSet<GitChangeSet>();
        BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(changelogFile), Charset.forName("UTF-8")));
        try {
            String line;
            ArrayList<String> lines = null;
            while ((line = rdr.readLine()) != null) {
                if (line.startsWith("commit ")) {
                    if (lines != null) {
                        r.add(this.parseCommit(lines, this.authorOrCommitter));
                    }
                    lines = new ArrayList<String>();
                }
                if (lines == null || lines.size() >= THRESHOLD) continue;
                lines.add(line);
            }
            if (lines != null) {
                r.add(this.parseCommit((List<String>)lines, this.authorOrCommitter));
            }
            GitChangeSetList gitChangeSetList = new GitChangeSetList(build, new ArrayList<GitChangeSet>(r));
            return gitChangeSetList;
        }
        finally {
            rdr.close();
        }
    }

    private GitChangeSet parseCommit(List<String> lines, boolean authorOrCommitter) {
        return new GitChangeSet(lines, authorOrCommitter);
    }
}

