/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import hudson.Extension;
import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.UnprotectedRootAction;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.MultipleScmResolver;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.triggers.SCMTrigger;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class GitStatus
extends AbstractModelObject
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(GitStatus.class.getName());

    public String getDisplayName() {
        return "Git";
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "git";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse doNotifyCommit(@QueryParameter(required=true) String url, @QueryParameter(required=false) String branches) throws ServletException, IOException {
        Authentication old = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
        try {
            URIish uri;
            try {
                uri = new URIish(url);
            }
            catch (URISyntaxException e) {
                HttpResponses.HttpResponseException httpResponseException = HttpResponses.error((int)400, (Throwable)new Exception("Illegal URL: " + url, e));
                SecurityContextHolder.getContext().setAuthentication(old);
                return httpResponseException;
            }
            if (branches == null) {
                branches = "";
            }
            String[] branchesArray = branches.split(",");
            final ArrayList projects = Lists.newArrayList();
            boolean scmFound = false;
            boolean triggerFound = false;
            boolean urlFound = false;
            for (AbstractProject project : Hudson.getInstance().getAllItems(AbstractProject.class)) {
                Collection<GitSCM> projectSCMs = this.getProjectScms(project);
                block7: for (GitSCM git : projectSCMs) {
                    scmFound = true;
                    for (RemoteConfig repository : git.getRepositories()) {
                        boolean repositoryMatches = false;
                        boolean branchMatches = false;
                        for (URIish remoteURL : repository.getURIs()) {
                            if (!this.looselyMatches(uri, remoteURL)) continue;
                            repositoryMatches = true;
                            break;
                        }
                        if (!repositoryMatches || git.isIgnoreNotifyCommit()) continue;
                        if (branchesArray.length == 1 && branchesArray[0] == "") {
                            branchMatches = true;
                        } else {
                            for (BranchSpec branchSpec : git.getBranches()) {
                                for (int i = 0; i < branchesArray.length; ++i) {
                                    if (!branchSpec.matches(repository.getName() + "/" + branchesArray[i])) continue;
                                    branchMatches = true;
                                    break;
                                }
                                if (!branchMatches) continue;
                                break;
                            }
                        }
                        if (!branchMatches) continue;
                        urlFound = true;
                        SCMTrigger trigger = (SCMTrigger)project.getTrigger(SCMTrigger.class);
                        if (trigger == null) continue;
                        triggerFound = true;
                        if (project.isDisabled()) continue block7;
                        LOGGER.info("Triggering the polling of " + project.getFullDisplayName());
                        trigger.run();
                        projects.add(project);
                        continue block7;
                    }
                }
            }
            final String msg = !scmFound ? "No git jobs found" : (!urlFound ? "No git jobs using repository: " + url + " and branches: " + branches : (!triggerFound ? "Jobs found but they aren't configured for polling" : null));
            HttpResponse httpResponse = new HttpResponse(){

                public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                    rsp.setStatus(200);
                    rsp.setContentType("text/plain");
                    for (AbstractProject p : projects) {
                        rsp.addHeader("Triggered", p.getAbsoluteUrl());
                    }
                    PrintWriter w = rsp.getWriter();
                    for (AbstractProject p : projects) {
                        w.println("Scheduled polling of " + p.getFullDisplayName());
                    }
                    if (msg != null) {
                        w.println(msg);
                    }
                }
            };
            return httpResponse;
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(old);
        }
    }

    private Collection<GitSCM> getProjectScms(AbstractProject<?, ?> project) {
        SCM scm;
        HashSet projectScms = Sets.newHashSet();
        if (Jenkins.getInstance().getPlugin("multiple-scms") != null) {
            MultipleScmResolver multipleScmResolver = new MultipleScmResolver();
            multipleScmResolver.resolveMultiScmIfConfigured(project, projectScms);
        }
        if (projectScms.isEmpty() && (scm = project.getScm()) instanceof GitSCM) {
            projectScms.add((GitSCM)scm);
        }
        return projectScms;
    }

    protected boolean looselyMatches(URIish lhs, URIish rhs) {
        return StringUtils.equals((String)lhs.getHost(), (String)rhs.getHost()) && StringUtils.equals((String)this.normalizePath(lhs.getPath()), (String)this.normalizePath(rhs.getPath()));
    }

    private String normalizePath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.endsWith(".git")) {
            path = path.substring(0, path.length() - 4);
        }
        return path;
    }
}

