/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.git.RevisionParameterAction;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitRevisionBuildParameters
extends AbstractBuildParameters {
    private boolean combineQueuedCommits = false;

    @DataBoundConstructor
    public GitRevisionBuildParameters(boolean combineQueuedCommits) {
        this.combineQueuedCommits = combineQueuedCommits;
    }

    public GitRevisionBuildParameters() {
    }

    public Action getAction(AbstractBuild<?, ?> build, TaskListener listener) {
        BuildData data = (BuildData)build.getAction(BuildData.class);
        if (data == null) {
            listener.getLogger().println("This project doesn't use Git as SCM. Can't pass the revision to downstream");
            return null;
        }
        return new RevisionParameterAction(data.getLastBuiltRevision().getSha1String(), this.getCombineQueuedCommits());
    }

    public boolean getCombineQueuedCommits() {
        return this.combineQueuedCommits;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension(optional=true)
    public static class DescriptorImpl
    extends Descriptor<AbstractBuildParameters> {
        public String getDisplayName() {
            return "Pass-through Git Commit that was built";
        }
    }
}

