/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class CGit
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final URL url;

    @DataBoundConstructor
    public CGit(String url) throws MalformedURLException {
        this.url = CGit.normalizeToEndWithSlash((URL)new URL(url));
    }

    public URL getUrl() {
        return this.url;
    }

    private QueryBuilder param() {
        return new QueryBuilder(this.url.getQuery());
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        return new URL(this.url, this.url.getPath() + "commit/" + this.param().add("id=" + changeSet.getId()).toString());
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        return new URL(this.url, this.url.getPath() + "diff/" + path.getPath() + this.param().add("id=" + changeSet.getId()).toString());
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        if (path.getEditType() == EditType.DELETE) {
            return new URL(this.url, this.url.getPath() + "tree/" + path.getPath() + this.param().add("id=" + changeSet.getParentCommit()).toString());
        }
        return new URL(this.url, this.url.getPath() + "tree/" + path.getPath() + this.param().add("id=" + changeSet.getId()).toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class CGITDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "cgit";
        }

        public CGit newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            return (CGit)((Object)req.bindParameters(CGit.class, "cgit."));
        }
    }
}

