/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.Branch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchSpec
implements Serializable {
    private static final long serialVersionUID = -6177158367915899356L;
    private String name;
    private transient Pattern pattern;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name.length() == 0 ? "**" : name.trim();
    }

    @DataBoundConstructor
    public BranchSpec(String name) {
        this.setName(name);
    }

    public String toString() {
        return this.pattern + " (" + this.name + ")";
    }

    public boolean matches(String item) {
        return this.getPattern().matcher(item).matches();
    }

    public List<String> filterMatching(Collection<String> branches) {
        ArrayList<String> items = new ArrayList<String>();
        for (String b : branches) {
            if (!this.matches(b)) continue;
            items.add(b);
        }
        return items;
    }

    public List<Branch> filterMatchingBranches(Collection<Branch> branches) {
        ArrayList<Branch> items = new ArrayList<Branch>();
        for (Branch b : branches) {
            if (!this.matches(b.getName())) continue;
            items.add(b);
        }
        return items;
    }

    private Pattern getPattern() {
        if (this.pattern != null) {
            return this.pattern;
        }
        String qualifiedName = !this.name.contains("**") && !this.name.contains("/") ? "*/" + this.name : this.name;
        StringBuilder builder = new StringBuilder();
        boolean foundWildcard = false;
        StringTokenizer tokenizer = new StringTokenizer(qualifiedName, "*", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("*")) {
                if (foundWildcard) {
                    builder.append(".*");
                    foundWildcard = false;
                    continue;
                }
                foundWildcard = true;
                continue;
            }
            if (foundWildcard) {
                builder.append("[^/]*");
                foundWildcard = false;
            }
            builder.append(Pattern.quote(token));
        }
        if (foundWildcard) {
            builder.append("[^/]*");
        }
        this.pattern = Pattern.compile(builder.toString());
        return this.pattern;
    }
}

