/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitserver;

import hudson.FilePath;
import hudson.remoting.Pipe;
import hudson.remoting.VirtualChannel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.BasePackFetchConnection;
import org.eclipse.jgit.transport.BasePackPushConnection;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UploadPack;

public class ChannelTransport
extends Transport
implements PackTransport {
    private final FilePath remoteRepository;

    public static Transport open(Repository local, FilePath remoteRepository) throws NotSupportedException, URISyntaxException, TransportException {
        if (remoteRepository.isRemote()) {
            return new ChannelTransport(local, remoteRepository);
        }
        return Transport.open((Repository)local, (String)remoteRepository.getRemote());
    }

    public ChannelTransport(Repository local, FilePath remoteRepository) throws URISyntaxException {
        super(local, new URIish("channel:" + remoteRepository.getRemote()));
        this.remoteRepository = remoteRepository;
    }

    public FetchConnection openFetch() throws NotSupportedException, TransportException {
        final Pipe l2r = Pipe.createLocalToRemote();
        final Pipe r2l = Pipe.createRemoteToLocal();
        try {
            this.remoteRepository.actAsync((FilePath.FileCallable)new GitFetchTask(l2r, r2l));
        }
        catch (IOException e) {
            throw new TransportException("Failed to open a fetch connection", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TransportException("Failed to open a fetch connection", (Throwable)e);
        }
        return new BasePackFetchConnection(this){
            {
                super(packTransport);
                this.init(new BufferedInputStream(r2l.getIn()), new BufferedOutputStream(l2r.getOut()));
                this.readAdvertisedRefs();
            }
        };
    }

    public PushConnection openPush() throws NotSupportedException, TransportException {
        final Pipe l2r = Pipe.createLocalToRemote();
        final Pipe r2l = Pipe.createRemoteToLocal();
        try {
            this.remoteRepository.actAsync((FilePath.FileCallable)new GitPushTask(l2r, r2l));
        }
        catch (IOException e) {
            throw new TransportException("Failed to open a fetch connection", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TransportException("Failed to open a fetch connection", (Throwable)e);
        }
        return new BasePackPushConnection(this){
            {
                super(packTransport);
                this.init(new BufferedInputStream(r2l.getIn()), new BufferedOutputStream(l2r.getOut()));
                this.readAdvertisedRefs();
            }
        };
    }

    public void close() {
    }

    private static class GitPushTask
    extends MasterToSlaveFileCallable<Void> {
        private final Pipe l2r;
        private final Pipe r2l;

        public GitPushTask(Pipe l2r, Pipe r2l) {
            this.l2r = l2r;
            this.r2l = r2l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            Repository repo = ((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(f)).build();
            try {
                ReceivePack rp = new ReceivePack(repo);
                rp.receive((InputStream)new BufferedInputStream(this.l2r.getIn()), (OutputStream)new BufferedOutputStream(this.r2l.getOut()), null);
                Void void_ = null;
                return void_;
            }
            finally {
                IOUtils.closeQuietly((InputStream)this.l2r.getIn());
                IOUtils.closeQuietly((OutputStream)this.r2l.getOut());
                repo.close();
            }
        }
    }

    private static class GitFetchTask
    extends MasterToSlaveFileCallable<Void> {
        private final Pipe l2r;
        private final Pipe r2l;

        public GitFetchTask(Pipe l2r, Pipe r2l) {
            this.l2r = l2r;
            this.r2l = r2l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            Repository repo = ((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(f)).build();
            try {
                UploadPack rp = new UploadPack(repo);
                rp.upload((InputStream)new BufferedInputStream(this.l2r.getIn()), (OutputStream)new BufferedOutputStream(this.r2l.getOut()), null);
                Void void_ = null;
                return void_;
            }
            finally {
                IOUtils.closeQuietly((InputStream)this.l2r.getIn());
                IOUtils.closeQuietly((OutputStream)this.r2l.getOut());
                repo.close();
            }
        }
    }
}

