/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitserver;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.http.server.GitServlet;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;
import org.jenkinsci.plugins.gitserver.CSRFExclusionImpl;
import org.jenkinsci.plugins.gitserver.Jenkins2521Workaround;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class HttpGitRepository {
    private GitServlet g;
    private Exception causeOfDeath;
    private static final Logger LOGGER = Logger.getLogger(HttpGitRepository.class.getName());

    public abstract Repository openRepository() throws IOException;

    public abstract ReceivePack createReceivePack(HttpServletRequest var1, Repository var2) throws ServiceNotEnabledException, ServiceNotAuthorizedException;

    public abstract UploadPack createUploadPack(HttpServletRequest var1, Repository var2) throws ServiceNotEnabledException, ServiceNotAuthorizedException;

    protected GitServlet init() {
        GitServlet g = new GitServlet();
        g.setRepositoryResolver((RepositoryResolver)new RepositoryResolver<HttpServletRequest>(){

            public Repository open(HttpServletRequest req, String name) throws RepositoryNotFoundException {
                try {
                    return HttpGitRepository.this.openRepository();
                }
                catch (IOException e) {
                    throw new RepositoryNotFoundException(req.getRequestURI(), (Throwable)e);
                }
            }
        });
        g.setReceivePackFactory((ReceivePackFactory)new ReceivePackFactory<HttpServletRequest>(){

            public ReceivePack create(HttpServletRequest req, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
                return HttpGitRepository.this.createReceivePack(req, db);
            }
        });
        g.setUploadPackFactory((UploadPackFactory)new UploadPackFactory<HttpServletRequest>(){

            public UploadPack create(HttpServletRequest req, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
                return HttpGitRepository.this.createUploadPack(req, db);
            }
        });
        try {
            g.init(new ServletConfig(){

                public String getServletName() {
                    return "";
                }

                public ServletContext getServletContext() {
                    return Jenkins.getInstance().servletContext;
                }

                public String getInitParameter(String name) {
                    return null;
                }

                public Enumeration getInitParameterNames() {
                    return new Vector().elements();
                }
            });
        }
        catch (ServletException e) {
            LOGGER.log(Level.WARNING, "Failed to initialize GitServlet for " + this, e);
            this.causeOfDeath = e;
        }
        return g;
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (this.g == null) {
            this.g = this.init();
        }
        if (this.causeOfDeath != null) {
            throw new ServletException((Throwable)this.causeOfDeath);
        }
        Object realRequest = CSRFExclusionImpl.unwrapRequest((HttpServletRequest)req);
        if (realRequest == null) {
            realRequest = req;
        }
        realRequest = new Jenkins2521Workaround((HttpServletRequest)realRequest);
        this.g.service((ServletRequest)realRequest, (ServletResponse)rsp);
    }
}

