/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitserver;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.jenkinsci.plugins.gitserver.HttpGitRepository;

public abstract class FileBackedHttpGitRepository
extends HttpGitRepository {
    public final File workspace;
    private static final Logger LOGGER = Logger.getLogger(FileBackedHttpGitRepository.class.getName());

    protected FileBackedHttpGitRepository(File workspace) {
        this.workspace = workspace;
        workspace.mkdirs();
    }

    public Repository openRepository() throws IOException {
        Repository r = ((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(this.workspace)).build();
        if (!r.getObjectDatabase().exists()) {
            this.createInitialRepository(r);
        }
        return r;
    }

    protected void createInitialRepository(Repository r) throws IOException {
        r.create();
        try {
            Git git = new Git(r);
            AddCommand cmd = git.add();
            cmd.addFilepattern(".");
            cmd.call();
            CommitCommand co = git.commit();
            co.setAuthor("Jenkins", "noreply@jenkins-ci.org");
            co.setMessage("Initial import of the existing contents");
            co.call();
        }
        catch (GitAPIException e) {
            LOGGER.log(Level.WARNING, "Initial import of " + this.workspace + " into Git repository failed", e);
        }
    }

    public UploadPack createUploadPack(HttpServletRequest context, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
        return new UploadPack(db);
    }

    public ReceivePack createReceivePack(HttpServletRequest context, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
        Authentication a = Jenkins.getAuthentication();
        ReceivePack rp = this.createReceivePack(db);
        rp.setRefLogIdent(new PersonIdent(a.getName(), a.getName() + "@" + context.getRemoteAddr()));
        return rp;
    }

    public ReceivePack createReceivePack(Repository db) {
        this.checkPushPermission();
        ReceivePack rp = new ReceivePack(db);
        rp.setPostReceiveHook(new PostReceiveHook(){

            public void onPostReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
                try {
                    FileBackedHttpGitRepository.this.updateWorkspace(rp.getRepository());
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    rp.sendMessage("Failed to update workspace: " + sw);
                }
            }
        });
        return rp;
    }

    protected void updateWorkspace(Repository repo) throws IOException, GitAPIException {
        ResetCommand cmd = new Git(repo).reset();
        cmd.setMode(ResetCommand.ResetType.HARD);
        cmd.setRef("master");
        cmd.call();
    }

    protected abstract void checkPushPermission();
}

