/*
 * Decompiled with CFR 0.152.
 */
package net.uaznia.lukanus.hudson.plugins.gitparameter;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.Revision;
import hudson.scm.SCM;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.uaznia.lukanus.hudson.plugins.gitparameter.GitParameterValue;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class GitParameterDefinition
extends ParameterDefinition
implements Comparable<GitParameterDefinition> {
    private static final long serialVersionUID = 9157832967140868122L;
    public static final String PARAMETER_TYPE_TAG = "PT_TAG";
    public static final String PARAMETER_TYPE_REVISION = "PT_REVISION";
    private final UUID uuid;
    private static final Logger LOGGER = Logger.getLogger(GitParameterDefinition.class.getName());
    private String type;
    private String branch;
    private String tagFilter;
    private SortMode sortMode;
    private String errorMessage;
    private String defaultValue;
    private Map<String, String> revisionMap;
    private Map<String, String> tagMap;

    @DataBoundConstructor
    public GitParameterDefinition(String name, String type, String defaultValue, String description, String branch, String tagFilter, SortMode sortMode) {
        super(name, description);
        this.type = type;
        this.defaultValue = defaultValue;
        this.branch = branch;
        this.uuid = UUID.randomUUID();
        this.sortMode = sortMode;
        this.tagFilter = GitParameterDefinition.isNullOrWhitespace(tagFilter) ? "*" : tagFilter;
    }

    public ParameterValue createValue(StaplerRequest request) {
        String[] value = request.getParameterValues(this.getName());
        if (value == null) {
            return this.getDefaultParameterValue();
        }
        return null;
    }

    public ParameterValue createValue(StaplerRequest request, JSONObject jO) {
        Object value = jO.get("value");
        String strValue = "";
        if (value instanceof String) {
            strValue = (String)value;
        } else if (value instanceof JSONArray) {
            JSONArray jsonValues = (JSONArray)value;
            for (int i = 0; i < jsonValues.size(); ++i) {
                strValue = strValue + jsonValues.getString(i);
                if (i >= jsonValues.size() - 1) continue;
                strValue = strValue + ",";
            }
        }
        if ("".equals(strValue)) {
            strValue = this.defaultValue;
        }
        GitParameterValue gitParameterValue = new GitParameterValue(jO.getString("name"), strValue);
        return gitParameterValue;
    }

    public ParameterValue getDefaultParameterValue() {
        String defValue = this.getDefaultValue();
        if (!StringUtils.isBlank((String)defValue)) {
            return new GitParameterValue(this.getName(), defValue);
        }
        return super.getDefaultParameterValue();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type.equals(PARAMETER_TYPE_TAG) || type.equals(PARAMETER_TYPE_REVISION)) {
            this.type = type;
        } else {
            this.errorMessage = "wrongType";
        }
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String nameOfBranch) {
        this.branch = nameOfBranch;
    }

    public SortMode getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(SortMode sortMode) {
        this.sortMode = sortMode;
    }

    public String getTagFilter() {
        return this.tagFilter;
    }

    public void setTagFilter(String tagFilter) {
        this.tagFilter = tagFilter;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public AbstractProject<?, ?> getParentProject() {
        AbstractProject context = null;
        List jobs = Hudson.getInstance().getItems(AbstractProject.class);
        block0: for (AbstractProject project : jobs) {
            List parameterDefinitions;
            ParametersDefinitionProperty property = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
            if (property == null || (parameterDefinitions = property.getParameterDefinitions()) == null) continue;
            for (ParameterDefinition pd : parameterDefinitions) {
                if (!(pd instanceof GitParameterDefinition) || ((GitParameterDefinition)pd).compareTo(this) != 0) continue;
                context = project;
                continue block0;
            }
        }
        return context;
    }

    @Override
    public int compareTo(GitParameterDefinition pd) {
        if (pd.uuid.equals(this.uuid)) {
            return 0;
        }
        return -1;
    }

    public String prettyRevisionInfo(GitClient newgit, Revision r) {
        List test3 = null;
        try {
            test3 = newgit.showRevision(r.getSha1());
        }
        catch (GitException e1) {
            return "";
        }
        catch (InterruptedException e1) {
            return "";
        }
        String[] authorDate = ((String)test3.get(3)).split(">");
        String author = authorDate[0].replaceFirst("author ", "").replaceFirst("committer ", "") + ">";
        String goodDate = null;
        try {
            String totmp = authorDate[1].trim().split("\\+")[0].trim();
            long timestamp = Long.parseLong(totmp, 10) * 1000L;
            Date date = new Date();
            date.setTime(timestamp);
            goodDate = new SimpleDateFormat("yyyy:MM:dd HH:mm").format(date);
        }
        catch (Exception e) {
            e.toString();
        }
        return r.getSha1String().substring(0, 8) + " " + goodDate + " " + author;
    }

    public void generateContents(String contenttype) throws IOException, InterruptedException {
        SCM scm;
        AbstractProject<?, ?> project = this.getParentProject();
        if (project.getSomeWorkspace() == null) {
            this.errorMessage = "noWorkspace";
        }
        if ((scm = project.getScm()) instanceof GitSCM) {
            this.errorMessage = "notGit";
        }
        GitSCM git = (GitSCM)scm;
        String defaultGitExe = File.separatorChar != '/' ? "git.exe" : "git";
        int n = 0;
        GitTool.DescriptorImpl descriptor = (GitTool.DescriptorImpl)Hudson.getInstance().getDescriptor(GitTool.class);
        GitTool[] installations = (GitTool[])descriptor.getInstallations();
        GitTool[] gitToolArray = installations;
        int n2 = gitToolArray.length;
        if (n < n2) {
            GitTool gt = gitToolArray[n];
            if (gt.getGitExe() != null) {
                // empty if block
            }
            defaultGitExe = gt.getGitExe();
        }
        EnvVars environment = null;
        try {
            environment = project.getSomeBuildWithWorkspace().getEnvironment(TaskListener.NULL);
        }
        catch (Exception e) {
            // empty catch block
        }
        Iterator iterator = git.getRepositories().iterator();
        if (iterator.hasNext()) {
            RemoteConfig repository = (RemoteConfig)iterator.next();
            LOGGER.log(Level.INFO, "generateContents contenttype " + contenttype + " RemoteConfig " + repository.getURIs());
            for (URIish remoteURL : repository.getURIs()) {
                ArrayList<String> orderedTagNames;
                GitClient newgit = new Git(TaskListener.NULL, environment).using(defaultGitExe).in(project.getSomeWorkspace()).getClient();
                FilePath wsDir = null;
                if (project.getSomeBuildWithWorkspace() != null) {
                    wsDir = project.getSomeBuildWithWorkspace().getWorkspace();
                    if (wsDir == null || !wsDir.exists()) {
                        LOGGER.log(Level.WARNING, "generateContents create wsDir " + wsDir + " for " + remoteURL);
                        wsDir.mkdirs();
                        if (!wsDir.exists()) {
                            LOGGER.log(Level.SEVERE, "generateContents wsDir.mkdirs() failed ");
                            return;
                        }
                        newgit.init();
                        newgit.clone(remoteURL.toASCIIString(), "origin", false, null);
                        LOGGER.log(Level.INFO, "generateContents clone done");
                    }
                } else {
                    LOGGER.log(Level.INFO, "getSomeBuildWithWorkspace is null");
                    return;
                }
                FetchCommand fetch = newgit.fetch_().from(remoteURL, repository.getFetchRefSpecs());
                fetch.execute();
                if (this.type.equalsIgnoreCase(PARAMETER_TYPE_REVISION)) {
                    this.revisionMap = new LinkedHashMap<String, String>();
                    List oid = this.branch != null && !this.branch.isEmpty() ? newgit.revList(this.branch) : newgit.revListAll();
                    for (ObjectId noid : oid) {
                        Revision r = new Revision(noid);
                        this.revisionMap.put(r.getSha1String(), this.prettyRevisionInfo(newgit, r));
                    }
                    continue;
                }
                if (!this.type.equalsIgnoreCase(PARAMETER_TYPE_TAG)) continue;
                this.tagMap = new LinkedHashMap<String, String>();
                Set tagSet = newgit.getTagNames(this.tagFilter);
                if (this.getSortMode().getIsSorting()) {
                    orderedTagNames = this.sortTagNames(tagSet);
                    if (this.getSortMode().getIsDescending()) {
                        Collections.reverse(orderedTagNames);
                    }
                } else {
                    orderedTagNames = new ArrayList(tagSet);
                }
                for (String tagName : orderedTagNames) {
                    this.tagMap.put(tagName, tagName);
                }
            }
        }
    }

    public ArrayList<String> sortTagNames(Set<String> tagSet) {
        ArrayList<String> tags = new ArrayList<String>(tagSet);
        if (!this.getSortMode().getIsUsingSmartSort()) {
            Collections.sort(tags);
        } else {
            Collections.sort(tags, new SmartNumberStringComparer());
        }
        return tags;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Map<String, String> getRevisionMap() throws IOException, InterruptedException {
        this.generateContents(PARAMETER_TYPE_REVISION);
        return this.revisionMap;
    }

    public Map<String, String> getTagMap() throws IOException, InterruptedException {
        this.generateContents(PARAMETER_TYPE_TAG);
        return this.tagMap;
    }

    private static boolean isNullOrWhitespace(String s) {
        return s == null || GitParameterDefinition.isWhitespace(s);
    }

    private static boolean isWhitespace(String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static class SmartNumberStringComparer
    implements Comparator<String> {
        SmartNumberStringComparer() {
        }

        private String getToken(String str, int index) {
            char nextChar = str.charAt(index++);
            String token = String.valueOf(nextChar);
            if (!Character.isDigit(nextChar)) {
                return token;
            }
            while (index < str.length() && Character.isDigit(nextChar = str.charAt(index++))) {
                token = token + nextChar;
            }
            return token;
        }

        private boolean stringContainsInteger(String str) {
            for (int charIndex = 0; charIndex < str.length(); ++charIndex) {
                if (Character.isDigit(str.charAt(charIndex))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int compare(String a, String b) {
            String bToken;
            String aToken;
            int aIndex = 0;
            for (int bIndex = 0; aIndex < a.length() && bIndex < b.length(); aIndex += aToken.length(), bIndex += bToken.length()) {
                int difference;
                aToken = this.getToken(a, aIndex);
                bToken = this.getToken(b, bIndex);
                if (this.stringContainsInteger(aToken) && this.stringContainsInteger(bToken)) {
                    int aInt = Integer.parseInt(aToken);
                    int bInt = Integer.parseInt(bToken);
                    difference = aInt - bInt;
                } else {
                    difference = aToken.compareTo(bToken);
                }
                if (difference == 0) continue;
                return difference;
            }
            return new Integer(a.length()).compareTo(new Integer(b.length()));
        }
    }

    static enum SortMode {
        NONE,
        ASCENDING_SMART,
        DESCENDING_SMART,
        ASCENDING,
        DESCENDING;


        public boolean getIsUsingSmartSort() {
            return this == ASCENDING_SMART || this == DESCENDING_SMART;
        }

        public boolean getIsDescending() {
            return this == DESCENDING || this == DESCENDING_SMART;
        }

        public boolean getIsSorting() {
            return this != NONE;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Git Parameter";
        }
    }
}

