/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.plugins.git.GitTool;
import hudson.tools.ToolProperty;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import io.jenkins.plugins.casc.model.Sequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.jenkinsci.plugins.gitclient.JGitApacheTool;
import org.jenkinsci.plugins.gitclient.JGitTool;

@Extension(optional=true)
public class GitToolConfigurator
extends BaseConfigurator<GitTool> {
    private static final Logger logger = Logger.getLogger(GitToolConfigurator.class.getName());

    @NonNull
    public String getName() {
        return "git";
    }

    public String getDisplayName() {
        return "Git";
    }

    public Class getTarget() {
        return GitTool.class;
    }

    public boolean canConfigure(Class clazz) {
        return clazz == GitTool.class;
    }

    @NonNull
    public Class getImplementedAPI() {
        return this.getTarget();
    }

    @NonNull
    public List<Configurator<GitTool>> getConfigurators(ConfigurationContext context) {
        return Collections.singletonList(this);
    }

    @NonNull
    public List<Attribute<GitTool, ?>> getAttributes() {
        Attribute name = new Attribute("name", String.class);
        Attribute home = new Attribute("home", String.class);
        Attribute p = new Attribute("properties", ToolProperty.class);
        p.multiple(true);
        return Arrays.asList(name, home, p);
    }

    protected GitTool instance(Mapping mapping, @NonNull ConfigurationContext context) throws ConfiguratorException {
        if (mapping == null) {
            return new GitTool("Default", "", this.instantiateProperties(null, context));
        }
        CNode mproperties = (CNode)mapping.remove((Object)"properties");
        String name = mapping.getScalarValue("name");
        if ("jgit".equals(name)) {
            if (mapping.remove((Object)"home") != null) {
                logger.warning("property `home` is ignored for `jgit`");
            }
            return new JGitTool(this.instantiateProperties(mproperties, context));
        }
        if ("jgitapache".equals(name)) {
            if (mapping.remove((Object)"home") != null) {
                logger.warning("property `home` is ignored for `jgitapache`");
            }
            return new JGitApacheTool(this.instantiateProperties(mproperties, context));
        }
        if (mapping.get((Object)"home") == null) {
            throw new ConfiguratorException((Configurator)this, "Home required for cli git configuration.");
        }
        String home = mapping.getScalarValue("home");
        return new GitTool(name, home, this.instantiateProperties(mproperties, context));
    }

    @NonNull
    private List<ToolProperty<?>> instantiateProperties(@CheckForNull CNode props, @NonNull ConfigurationContext context) throws ConfiguratorException {
        ArrayList toolProperties = new ArrayList();
        if (props == null) {
            return toolProperties;
        }
        Configurator configurator = context.lookupOrFail(ToolProperty.class);
        if (props instanceof Sequence) {
            Sequence s = (Sequence)props;
            for (CNode cNode : s) {
                toolProperties.add((ToolProperty)configurator.configure(cNode, context));
            }
        } else {
            toolProperties.add((ToolProperty)configurator.configure(props, context));
        }
        return toolProperties;
    }

    @CheckForNull
    public CNode describe(GitTool instance, ConfigurationContext context) throws Exception {
        Mapping mapping = new Mapping();
        if (instance instanceof JGitTool) {
            mapping.put("name", "jgit");
        } else if (instance instanceof JGitApacheTool) {
            mapping.put("name", "jgitapache");
        } else if (instance != null) {
            mapping.put("name", instance.getName());
            mapping.put("home", instance.getHome());
        }
        if (context != null && instance != null && instance.getProperties() != null && !instance.getProperties().isEmpty()) {
            Configurator configurator = context.lookupOrFail(ToolProperty.class);
            Sequence s = new Sequence(instance.getProperties().size());
            for (ToolProperty property : instance.getProperties()) {
                s.add((Object)configurator.describe((Object)property, context));
            }
            mapping.put((Object)"properties", (Object)s);
        }
        return mapping;
    }
}

