/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient.trilead;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.model.TaskListener;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class CredentialsProviderImpl
extends CredentialsProvider {
    public final TaskListener listener;
    public final StandardUsernameCredentials cred;

    public CredentialsProviderImpl(TaskListener listener, StandardUsernameCredentials cred) {
        this.listener = listener;
        this.cred = cred;
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean supports(CredentialItem ... items) {
        if (!(this.cred instanceof StandardUsernamePasswordCredentials)) {
            return false;
        }
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.Username || i instanceof CredentialItem.Password) continue;
            return false;
        }
        return true;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        if (!(this.cred instanceof StandardUsernamePasswordCredentials)) {
            return false;
        }
        StandardUsernamePasswordCredentials _cred = (StandardUsernamePasswordCredentials)this.cred;
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.Username) {
                ((CredentialItem.Username)i).setValue(_cred.getUsername());
                continue;
            }
            if (i instanceof CredentialItem.Password) {
                ((CredentialItem.Password)i).setValue(_cred.getPassword().getPlainText().toCharArray());
                continue;
            }
            if (i instanceof CredentialItem.StringType && i.getPromptText().equals("Password: ")) {
                ((CredentialItem.StringType)i).setValue(_cred.getPassword().getPlainText());
                continue;
            }
            throw new UnsupportedCredentialItem(uri, i.getClass().getName() + ":" + i.getPromptText());
        }
        return true;
    }
}

