/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jgit.lib.ObjectId;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class GitObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    final ObjectId sha1;
    final String name;

    public GitObject(String name, ObjectId sha1) {
        this.name = name;
        this.sha1 = sha1;
    }

    @SuppressFBWarnings(value={"NM_CONFUSING"}, justification="Published API in GitObject and Revision")
    public ObjectId getSHA1() {
        return this.sha1;
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @Exported(name="SHA1")
    @SuppressFBWarnings(value={"NM_CONFUSING"}, justification="Published API in GitObject and Revision")
    public String getSHA1String() {
        return this.sha1 != null ? this.sha1.name() : null;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.sha1);
        hash = 97 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GitObject other = (GitObject)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.sha1, other.sha1);
    }
}

