/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Main;
import hudson.model.TaskListener;
import hudson.plugins.git.GitAPI;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import javax.annotation.Nullable;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.JGitAPIImpl;
import org.jenkinsci.plugins.gitclient.jgit.PreemptiveAuthHttpClientConnectionFactory;

public class Git
implements Serializable {
    @Nullable
    private FilePath repository;
    private TaskListener listener;
    private EnvVars env;
    private String exe;
    public static final boolean USE_CLI = Boolean.valueOf(System.getProperty(Git.class.getName() + ".useCLI", "true"));
    private static final long serialVersionUID = 1L;

    public Git(TaskListener listener, EnvVars env) {
        this.listener = listener;
        this.env = env;
    }

    public static Git with(TaskListener listener, EnvVars env) {
        return new Git(listener, env);
    }

    public Git in(File repository) {
        return this.in(new FilePath(repository));
    }

    public Git in(FilePath repository) {
        this.repository = repository;
        return this;
    }

    public Git using(String exe) {
        this.exe = exe;
        return this;
    }

    public GitClient getClient() throws IOException, InterruptedException {
        MasterToSlaveFileCallable<GitClient> callable = new MasterToSlaveFileCallable<GitClient>(){

            public GitClient invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                if (Git.this.listener == null) {
                    Git.this.listener = TaskListener.NULL;
                }
                if (Git.this.env == null) {
                    Git.this.env = new EnvVars();
                }
                if (Main.isUnitTest && System.getProperty(Git.class.getName() + ".mockClient") != null) {
                    return Git.this.initMockClient(System.getProperty(Git.class.getName() + ".mockClient"), Git.this.exe, Git.this.env, f, Git.this.listener);
                }
                if (Git.this.exe == null || "jgit".equalsIgnoreCase(Git.this.exe)) {
                    return new JGitAPIImpl(f, Git.this.listener);
                }
                if ("jgitapache".equalsIgnoreCase(Git.this.exe)) {
                    PreemptiveAuthHttpClientConnectionFactory factory = new PreemptiveAuthHttpClientConnectionFactory();
                    return new JGitAPIImpl(f, Git.this.listener, factory);
                }
                return new GitAPI(Git.this.exe, f, Git.this.listener, Git.this.env);
            }
        };
        GitClient git = this.repository != null ? (GitClient)this.repository.act((FilePath.FileCallable)callable) : (GitClient)callable.invoke(null, null);
        Jenkins jenkinsInstance = Jenkins.getInstance();
        if (jenkinsInstance != null && git != null) {
            git.setProxy(jenkinsInstance.proxy);
        }
        return git;
    }

    private GitClient initMockClient(String className, String exe, EnvVars env, File f, TaskListener listener) throws RuntimeException {
        try {
            Class<?> it = Class.forName(className);
            Constructor<?> constructor = it.getConstructor(String.class, EnvVars.class, File.class, TaskListener.class);
            return (GitClient)constructor.newInstance(exe, env, f, listener);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize mock GitClient " + className, e);
        }
    }
}

