/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient.trilead;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.trilead.ssh2.Connection;
import java.io.IOException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.jenkinsci.plugins.gitclient.trilead.CredentialsProviderImpl;
import org.jenkinsci.plugins.gitclient.trilead.SmartCredentialsProvider;
import org.jenkinsci.plugins.gitclient.trilead.StandardUsernameCredentialsCredentialItem;
import org.jenkinsci.plugins.gitclient.trilead.TrileadSession;

public class TrileadSessionFactory
extends SshSessionFactory {
    public RemoteSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
        try {
            boolean authenticated;
            int p = uri.getPort();
            if (p < 0) {
                p = 22;
            }
            Connection con = new Connection(uri.getHost(), p);
            con.setTCPNoDelay(true);
            con.connect();
            if (credentialsProvider instanceof SmartCredentialsProvider) {
                SmartCredentialsProvider smart = (SmartCredentialsProvider)credentialsProvider;
                StandardUsernameCredentialsCredentialItem item = new StandardUsernameCredentialsCredentialItem("Credentials for " + uri, false);
                authenticated = smart.supports(item) && smart.get(uri, item) && SSHAuthenticator.newInstance((Object)con, (StandardUsernameCredentials)item.getValue(), (String)uri.getUser()).authenticate(smart.listener);
            } else if (credentialsProvider instanceof CredentialsProviderImpl) {
                CredentialsProviderImpl sshcp = (CredentialsProviderImpl)credentialsProvider;
                authenticated = SSHAuthenticator.newInstance((Object)con, (StandardUsernameCredentials)sshcp.cred).authenticate(sshcp.listener);
            } else {
                authenticated = false;
            }
            if (!authenticated && con.isAuthenticationComplete()) {
                throw new TransportException("Authentication failure");
            }
            return this.wrap(con);
        }
        catch (IOException | InterruptedException | UnsupportedCredentialItem e) {
            throw new TransportException(uri, "Failed to connect", e);
        }
    }

    protected TrileadSession wrap(Connection con) {
        return new TrileadSession(con);
    }
}

