/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient.trilead;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jgit.transport.RemoteSession;

public class TrileadSession
implements RemoteSession {
    protected final Connection con;

    public TrileadSession(Connection con) {
        this.con = con;
    }

    public Process exec(String commandName, final int timeout) throws IOException {
        final Session s = this.con.openSession();
        s.execCommand(commandName);
        return new Process(){

            public OutputStream getOutputStream() {
                return s.getStdin();
            }

            public InputStream getInputStream() {
                return s.getStdout();
            }

            public InputStream getErrorStream() {
                return s.getStderr();
            }

            public int waitFor() throws InterruptedException {
                int r = s.waitForCondition(32, (long)(timeout * 1000));
                if ((r & 0x20) != 0) {
                    return this.exitValue();
                }
                throw new InterruptedException("Timed out: " + r);
            }

            public int exitValue() {
                Integer i = s.getExitStatus();
                if (i == null) {
                    throw new IllegalThreadStateException();
                }
                return i;
            }

            public void destroy() {
                s.close();
            }
        };
    }

    public void disconnect() {
        this.con.close();
    }
}

