/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.git.GitAPI;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.JGitAPIImpl;

public class Git
implements Serializable {
    @Nullable
    private FilePath repository;
    private TaskListener listener;
    private EnvVars env;
    private String exe;
    public static final boolean USE_CLI = Boolean.valueOf(System.getProperty(Git.class.getName() + ".useCLI", "true"));
    private static final long serialVersionUID = 1L;

    public Git(TaskListener listener, EnvVars env) {
        this.listener = listener;
        this.env = env;
    }

    public static Git with(TaskListener listener, EnvVars env) {
        return new Git(listener, env);
    }

    public Git in(File repository) {
        return this.in(new FilePath(repository));
    }

    public Git in(FilePath repository) {
        this.repository = repository;
        return this;
    }

    public Git using(String exe) {
        this.exe = exe;
        return this;
    }

    public GitClient getClient() throws IOException, InterruptedException {
        GitClient git;
        FilePath.FileCallable<GitClient> callable = new FilePath.FileCallable<GitClient>(){

            public GitClient invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                if (Git.this.listener == null) {
                    Git.this.listener = TaskListener.NULL;
                }
                if (Git.this.env == null) {
                    Git.this.env = new EnvVars();
                }
                if (Git.this.exe == null || "jgit".equalsIgnoreCase(Git.this.exe)) {
                    return new JGitAPIImpl(f, Git.this.listener);
                }
                return new GitAPI(Git.this.exe, f, Git.this.listener, Git.this.env);
            }
        };
        GitClient gitClient = git = this.repository != null ? (GitClient)this.repository.act((FilePath.FileCallable)callable) : (GitClient)callable.invoke(null, null);
        if (Jenkins.getInstance() != null) {
            git.setProxy(Jenkins.getInstance().proxy);
        }
        return git;
    }
}

