/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import antlr.ANTLRException;
import com.coravy.hudson.plugins.github.GithubProjectProperty;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterValue;
import hudson.model.queue.QueueTaskFuture;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.ghprb.Ghprb;
import org.jenkinsci.plugins.ghprb.GhprbCause;
import org.jenkinsci.plugins.ghprb.GhprbGitHub;
import org.jenkinsci.plugins.ghprb.GhprbPullRequest;
import org.kohsuke.github.GHAuthorization;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GitHub;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GhprbTrigger
extends Trigger<AbstractProject<?, ?>> {
    private static final Logger logger = Logger.getLogger(GhprbTrigger.class.getName());
    private final String adminlist;
    private String whitelist;
    private final String orgslist;
    private final String cron;
    private final String triggerPhrase;
    private final Boolean onlyTriggerPhrase;
    private final Boolean useGitHubHooks;
    private final Boolean permitAll;
    private Boolean autoCloseFailedPullRequests;
    private transient Ghprb ml;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public GhprbTrigger(String adminlist, String whitelist, String orgslist, String cron, String triggerPhrase, Boolean onlyTriggerPhrase, Boolean useGitHubHooks, Boolean permitAll, Boolean autoCloseFailedPullRequests) throws ANTLRException {
        super(cron);
        this.adminlist = adminlist;
        this.whitelist = whitelist;
        this.orgslist = orgslist;
        this.cron = cron;
        this.triggerPhrase = triggerPhrase;
        this.onlyTriggerPhrase = onlyTriggerPhrase;
        this.useGitHubHooks = useGitHubHooks;
        this.permitAll = permitAll;
        this.autoCloseFailedPullRequests = autoCloseFailedPullRequests;
    }

    public void start(AbstractProject<?, ?> project, boolean newInstance) {
        if (project.getProperty(GithubProjectProperty.class) == null) {
            logger.log(Level.INFO, "GitHub project not set up, cannot start trigger for job " + project.getName());
            return;
        }
        try {
            this.ml = Ghprb.getBuilder().setProject(project).setTrigger(this).setPulls(GhprbTrigger.DESCRIPTOR.getPullRequests(project.getFullName())).build();
        }
        catch (IllegalStateException ex) {
            logger.log(Level.SEVERE, "Can't start trigger", ex);
            return;
        }
        super.start(project, newInstance);
    }

    public Ghprb getGhprb() {
        return this.ml;
    }

    public void stop() {
        if (this.ml != null) {
            this.ml.stop();
            this.ml = null;
        }
        super.stop();
    }

    public QueueTaskFuture<?> startJob(GhprbCause cause) {
        ArrayList<ParameterValue> values = this.getDefaultParameters();
        if (cause.isMerged()) {
            values.add((ParameterValue)new StringParameterValue("sha1", "origin/pr/" + cause.getPullID() + "/merge"));
        } else {
            values.add((ParameterValue)new StringParameterValue("sha1", cause.getCommit()));
        }
        values.add((ParameterValue)new StringParameterValue("ghprbActualCommit", cause.getCommit()));
        values.add((ParameterValue)new StringParameterValue("ghprbPullId", String.valueOf(cause.getPullID())));
        values.add((ParameterValue)new StringParameterValue("ghprbTargetBranch", String.valueOf(cause.getTargetBranch())));
        values.add((ParameterValue)new StringParameterValue("ghprbPullAuthorEmail", cause.getAuthorEmail() != null ? cause.getAuthorEmail() : ""));
        return ((AbstractProject)this.job).scheduleBuild2(0, (Cause)cause, new Action[]{new ParametersAction(values)});
    }

    private ArrayList<ParameterValue> getDefaultParameters() {
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        ParametersDefinitionProperty pdp = (ParametersDefinitionProperty)((AbstractProject)this.job).getProperty(ParametersDefinitionProperty.class);
        if (pdp != null) {
            for (ParameterDefinition pd : pdp.getParameterDefinitions()) {
                if (pd.getName().equals("sha1")) continue;
                values.add(pd.getDefaultParameterValue());
            }
        }
        return values;
    }

    public void run() {
        if (this.ml == null) {
            return;
        }
        this.ml.run();
        DESCRIPTOR.save();
    }

    public void addWhitelist(String author) {
        this.whitelist = this.whitelist + " " + author;
        try {
            ((AbstractProject)this.job).save();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Failed to save new whitelist", ex);
        }
    }

    public String getAdminlist() {
        if (this.adminlist == null) {
            return "";
        }
        return this.adminlist;
    }

    public String getWhitelist() {
        if (this.whitelist == null) {
            return "";
        }
        return this.whitelist;
    }

    public String getOrgslist() {
        if (this.orgslist == null) {
            return "";
        }
        return this.orgslist;
    }

    public String getCron() {
        return this.cron;
    }

    public String getTriggerPhrase() {
        if (this.triggerPhrase == null) {
            return "";
        }
        return this.triggerPhrase;
    }

    public Boolean getOnlyTriggerPhrase() {
        return this.onlyTriggerPhrase != null && this.onlyTriggerPhrase != false;
    }

    public Boolean getUseGitHubHooks() {
        return this.useGitHubHooks != null && this.useGitHubHooks != false;
    }

    public Boolean getPermitAll() {
        return this.permitAll != null && this.permitAll != false;
    }

    public Boolean isAutoCloseFailedPullRequests() {
        if (this.autoCloseFailedPullRequests == null) {
            Boolean autoClose = this.getDescriptor().getAutoCloseFailedPullRequests();
            return autoClose != null && autoClose != false;
        }
        return this.autoCloseFailedPullRequests;
    }

    public static GhprbTrigger getTrigger(AbstractProject p) {
        Trigger trigger = p.getTrigger(GhprbTrigger.class);
        if (trigger == null || !(trigger instanceof GhprbTrigger)) {
            return null;
        }
        return (GhprbTrigger)trigger;
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static DescriptorImpl getDscp() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends TriggerDescriptor {
        private String serverAPIUrl = "https://api.github.com";
        private String username;
        private String password;
        private String accessToken;
        private String adminlist;
        private String publishedURL;
        private String requestForTestingPhrase;
        private String whitelistPhrase = ".*add\\W+to\\W+whitelist.*";
        private String okToTestPhrase = ".*ok\\W+to\\W+test.*";
        private String retestPhrase = ".*test\\W+this\\W+please.*";
        private String cron = "*/5 * * * *";
        private Boolean useComments = false;
        private String unstableAs = GHCommitState.FAILURE.name();
        private Boolean autoCloseFailedPullRequests = false;
        private String msgSuccess = "Test PASSed.";
        private String msgFailure = "Test FAILed.";
        private transient GhprbGitHub gh;
        private Map<String, Map<Integer, GhprbPullRequest>> jobs;
        private static final Pattern adminlistPattern = Pattern.compile("((\\p{Alnum}[\\p{Alnum}-]*)|\\s)*");

        public DescriptorImpl() {
            this.load();
            if (this.jobs == null) {
                this.jobs = new HashMap<String, Map<Integer, GhprbPullRequest>>();
            }
        }

        public boolean isApplicable(Item item) {
            return item instanceof AbstractProject;
        }

        public String getDisplayName() {
            return "GitHub pull requests builder";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.serverAPIUrl = formData.getString("serverAPIUrl");
            this.username = formData.getString("username");
            this.password = formData.getString("password");
            this.accessToken = formData.getString("accessToken");
            this.adminlist = formData.getString("adminlist");
            this.publishedURL = formData.getString("publishedURL");
            this.requestForTestingPhrase = formData.getString("requestForTestingPhrase");
            this.whitelistPhrase = formData.getString("whitelistPhrase");
            this.okToTestPhrase = formData.getString("okToTestPhrase");
            this.retestPhrase = formData.getString("retestPhrase");
            this.cron = formData.getString("cron");
            this.useComments = formData.getBoolean("useComments");
            this.unstableAs = formData.getString("unstableAs");
            this.autoCloseFailedPullRequests = formData.getBoolean("autoCloseFailedPullRequests");
            this.msgSuccess = formData.getString("msgSuccess");
            this.msgFailure = formData.getString("msgFailure");
            this.save();
            this.gh = new GhprbGitHub();
            return super.configure(req, formData);
        }

        public FormValidation doCheckAdminlist(@QueryParameter String value) throws ServletException {
            if (!adminlistPattern.matcher(value).matches()) {
                return FormValidation.error((String)"GitHub username may only contain alphanumeric characters or dashes and cannot begin with a dash. Separate them with whitespece.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCron(@QueryParameter String value) {
            return new TimerTrigger.DescriptorImpl().doCheckSpec(value);
        }

        public FormValidation doCheckServerAPIUrl(@QueryParameter String value) {
            if ("https://api.github.com".equals(value)) {
                return FormValidation.ok();
            }
            if (value.endsWith("/api/v3")) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)"GitHub api url is \"https://api.github.com\". GitHub enterprise api url ends with \"/api/v3\"");
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getAdminlist() {
            return this.adminlist;
        }

        public String getPublishedURL() {
            return this.publishedURL;
        }

        public String getRequestForTestingPhrase() {
            return this.requestForTestingPhrase;
        }

        public String getWhitelistPhrase() {
            return this.whitelistPhrase;
        }

        public String getOkToTestPhrase() {
            return this.okToTestPhrase;
        }

        public String getRetestPhrase() {
            return this.retestPhrase;
        }

        public String getCron() {
            return this.cron;
        }

        public Boolean getUseComments() {
            return this.useComments;
        }

        public Boolean getAutoCloseFailedPullRequests() {
            return this.autoCloseFailedPullRequests;
        }

        public String getServerAPIUrl() {
            return this.serverAPIUrl;
        }

        public String getUnstableAs() {
            return this.unstableAs;
        }

        public String getMsgSuccess() {
            if (this.msgSuccess == null) {
                return "Test PASSed.";
            }
            return this.msgSuccess;
        }

        public String getMsgFailure() {
            if (this.msgFailure == null) {
                return "Test FAILed.";
            }
            return this.msgFailure;
        }

        public boolean isUseComments() {
            return this.useComments != null && this.useComments != false;
        }

        public GhprbGitHub getGitHub() {
            if (this.gh == null) {
                this.gh = new GhprbGitHub();
            }
            return this.gh;
        }

        private Map<Integer, GhprbPullRequest> getPullRequests(String projectName) {
            HashMap<Integer, GhprbPullRequest> ret;
            if (this.jobs.containsKey(projectName)) {
                ret = this.jobs.get(projectName);
            } else {
                ret = new HashMap();
                this.jobs.put(projectName, ret);
            }
            return ret;
        }

        public FormValidation doCreateApiToken(@QueryParameter(value="username") String username, @QueryParameter(value="password") String password) {
            try {
                GitHub gh = GitHub.connectToEnterprise((String)this.serverAPIUrl, (String)username, (String)password);
                GHAuthorization token = gh.createToken(Arrays.asList("repo:status", "repo"), "Jenkins GitHub Pull Request Builder", null);
                return FormValidation.ok((String)("Access token created: " + token.getToken()));
            }
            catch (IOException ex) {
                return FormValidation.error((String)("GitHub API token couldn't be created" + ex.getMessage()));
            }
        }
    }
}

